/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.connection;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterType;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoUtils;
import io.debezium.connector.mongodb.connection.ConnectionStrings;
import io.debezium.connector.mongodb.connection.client.DefaultMongoDbClientFactory;
import io.debezium.connector.mongodb.connection.client.MongoDbClientFactory;
import io.debezium.function.BlockingConsumer;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbConnectionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbConnectionContext.class);
    private final MongoDbConnectorConfig connectorConfig;
    private final MongoDbClientFactory clientFactory;

    public MongoDbConnectionContext(Configuration config) {
        this.connectorConfig = new MongoDbConnectorConfig(config);
        this.clientFactory = new DefaultMongoDbClientFactory(config);
    }

    public MongoDbConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public ConnectionString getConnectionString() {
        return this.connectorConfig.getConnectionString();
    }

    public String getMaskedConnectionString() {
        return ConnectionStrings.mask(this.getConnectionString());
    }

    public MongoClient getMongoClient() {
        return this.clientFactory.getMongoClient();
    }

    public ClusterDescription getClusterDescription() {
        try (MongoClient client = this.getMongoClient();){
            LOGGER.info("Reading description of cluster at {}", (Object)this.getMaskedConnectionString());
            ClusterDescription clusterDescription = MongoUtils.clusterDescription(client);
            return clusterDescription;
        }
    }

    public ClusterType getClusterType() {
        return this.getClusterDescription().getType();
    }

    public boolean isShardedCluster() {
        return ClusterType.SHARDED == this.getClusterType();
    }

    public Set<String> getShardNames() {
        if (!this.isShardedCluster()) {
            return Set.of();
        }
        HashSet<String> shardNames = new HashSet<String>();
        try (MongoClient client = this.getMongoClient();){
            MongoUtils.onCollectionDocuments(client, "config", "shards", (BlockingConsumer<Document>)((BlockingConsumer)doc -> {
                String shardName = doc.getString((Object)"_id");
                shardNames.add(shardName);
            }));
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to read shard topology.");
        }
        return shardNames;
    }

    public Optional<String> getRequiredReplicaSetName() {
        return Optional.of(this.getConnectionString()).map(ConnectionString::getRequiredReplicaSetName);
    }

    public boolean hasRequiredReplicaSetName() {
        if (this.getRequiredReplicaSetName().isPresent()) {
            return true;
        }
        return this.getClusterDescription().getType() == ClusterType.SHARDED;
    }
}

