/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.rest;

import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.rest.DebeziumMongoDbConnectRestExtension;
import io.debezium.testing.testcontainers.Connector;
import io.debezium.testing.testcontainers.ConnectorConfiguration;
import io.debezium.testing.testcontainers.MongoDbReplicaSet;
import io.debezium.testing.testcontainers.testhelper.RestExtensionTestInfrastructure;
import io.debezium.testing.testcontainers.util.DockerUtils;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Locale;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testcontainers.utility.MountableFile;

public class DebeziumMongoDbConnectorResourceIT {
    public static final MountableFile INIT_SCRIPT_RESOURCE = MountableFile.forClasspathResource((String)"/initialize-mongo-single.js");
    public static final String INIT_SCRIPT_PATH = "/docker-entrypoint-initdb.d/initialize-mongo-single.js";

    @BeforeClass
    public static void checkCondition() {
        Assume.assumeThat((String)"Skipping DebeziumMongoDbConnectorResourceIT tests when assembly profile is not active!", (Object)System.getProperty("isAssemblyProfileActive", "false"), (Matcher)CoreMatchers.is((Object)"true"));
    }

    @Before
    public void start() {
        RestExtensionTestInfrastructure.setupDebeziumContainer((String)Module.version(), (String)DebeziumMongoDbConnectRestExtension.class.getName());
        DockerUtils.enableFakeDnsIfRequired();
        RestExtensionTestInfrastructure.startContainers((RestExtensionTestInfrastructure.DATABASE)RestExtensionTestInfrastructure.DATABASE.MONGODB);
        RestExtensionTestInfrastructure.getMongoDbContainer().execMongoScript(INIT_SCRIPT_RESOURCE, INIT_SCRIPT_PATH);
    }

    @After
    public void stop() {
        RestExtensionTestInfrastructure.stopContainers();
        DockerUtils.disableFakeDns();
    }

    @Test
    public void testValidConnection() {
        ConnectorConfiguration config = DebeziumMongoDbConnectorResourceIT.getMongoDbConnectorConfiguration(1, new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mongodb/validate/connection", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testInvalidIpConnection() {
        ConnectorConfiguration config = DebeziumMongoDbConnectorResourceIT.getMongoDbConnectorConfiguration(1, new String[0]).with(MongoDbConnectorConfig.CONNECTION_STRING.name(), "mongodb://192.168.222.222:27017/?replicaSet=zz666");
        Locale.setDefault(new Locale("en", "US"));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mongodb/validate/connection", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)1), new Object[0])).rootPath("validationResults[0]")).body("property", CoreMatchers.equalTo((Object)MongoDbConnectorConfig.CONNECTION_STRING.name()), new Object[0])).body("message", CoreMatchers.startsWith((String)"Unable to connect: "), new Object[0]);
    }

    @Test
    public void testInvalidConnection() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body("{\"connector.class\": \"" + MongoDbConnector.class.getName() + "\"}").put("/debezium/mongodb/validate/connection", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)2), new Object[0])).body("validationResults", CoreMatchers.hasItems((Object[])new Map[]{Map.of("property", MongoDbConnectorConfig.CONNECTION_STRING.name(), "message", "The 'mongodb.connection.string' value is invalid: Missing connection string"), Map.of("property", MongoDbConnectorConfig.TOPIC_PREFIX.name(), "message", "The 'topic.prefix' value is invalid: A value is required")}), new Object[0]);
    }

    @Test
    public void testFiltersWithEmptyFilters() {
        ConnectorConfiguration config = DebeziumMongoDbConnectorResourceIT.getMongoDbConnectorConfiguration(1, new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mongodb/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)3), new Object[0])).body("matchingCollections", CoreMatchers.hasItems((Object[])new Map[]{Map.of("realm", "rs0", "namespace", "inventory", "name", "customers", "identifier", "rs0.inventory.customers"), Map.of("realm", "rs0", "namespace", "inventory", "name", "orders", "identifier", "rs0.inventory.orders"), Map.of("realm", "rs0", "namespace", "inventory", "name", "products", "identifier", "rs0.inventory.products")}), new Object[0]);
    }

    @Test
    public void testFiltersWithValidCollectionIncludeList() {
        ConnectorConfiguration config = DebeziumMongoDbConnectorResourceIT.getMongoDbConnectorConfiguration(1, new String[0]).with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST.name(), "inventory\\.product.*");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mongodb/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)1), new Object[0])).body("matchingCollections", CoreMatchers.hasItems((Object[])new Map[]{Map.of("realm", "rs0", "namespace", "inventory", "name", "products", "identifier", "rs0.inventory.products")}), new Object[0]);
    }

    @Test
    public void testFiltersWithValidDatabaseIncludeList() {
        ConnectorConfiguration config = DebeziumMongoDbConnectorResourceIT.getMongoDbConnectorConfiguration(1, new String[0]).with(MongoDbConnectorConfig.DATABASE_INCLUDE_LIST.name(), "inventory");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mongodb/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)3), new Object[0])).body("matchingCollections", CoreMatchers.hasItems((Object[])new Map[]{Map.of("realm", "rs0", "namespace", "inventory", "name", "customers", "identifier", "rs0.inventory.customers"), Map.of("realm", "rs0", "namespace", "inventory", "name", "orders", "identifier", "rs0.inventory.orders"), Map.of("realm", "rs0", "namespace", "inventory", "name", "products", "identifier", "rs0.inventory.products")}), new Object[0]);
    }

    @Test
    public void testFiltersWithInvalidDatabaseIncludeListPattern() {
        ConnectorConfiguration config = DebeziumMongoDbConnectorResourceIT.getMongoDbConnectorConfiguration(1, new String[0]).with(MongoDbConnectorConfig.DATABASE_INCLUDE_LIST.name(), "+");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mongodb/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)0), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)1), new Object[0])).rootPath("validationResults[0]")).body("property", CoreMatchers.equalTo((Object)MongoDbConnectorConfig.DATABASE_INCLUDE_LIST.name()), new Object[0])).body("message", CoreMatchers.equalTo((Object)"The 'database.include.list' value is invalid: A comma-separated list of valid regular expressions is expected, but Dangling meta character '+' near index 0\n+\n^"), new Object[0]);
    }

    @Test
    public void testFiltersWithInvalidDatabaseExcludeListPattern() {
        ConnectorConfiguration config = DebeziumMongoDbConnectorResourceIT.getMongoDbConnectorConfiguration(1, new String[0]).with(MongoDbConnectorConfig.DATABASE_EXCLUDE_LIST.name(), "+");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mongodb/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)0), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)1), new Object[0])).rootPath("validationResults[0]")).body("property", CoreMatchers.equalTo((Object)MongoDbConnectorConfig.DATABASE_EXCLUDE_LIST.name()), new Object[0])).body("message", CoreMatchers.equalTo((Object)"The 'database.exclude.list' value is invalid: A comma-separated list of valid regular expressions is expected, but Dangling meta character '+' near index 0\n+\n^"), new Object[0]);
    }

    @Test
    public void testMetricsEndpoint() throws InterruptedException {
        ConnectorConfiguration config = DebeziumMongoDbConnectorResourceIT.getMongoDbConnectorConfiguration(1, new String[0]);
        String connectorName = "my-mongodb-connector";
        RestExtensionTestInfrastructure.getDebeziumContainer().registerConnector(connectorName, config);
        RestExtensionTestInfrastructure.getDebeziumContainer().ensureConnectorState(connectorName, Connector.State.RUNNING);
        RestExtensionTestInfrastructure.waitForConnectorTaskStatus((String)connectorName, (int)0, (Connector.State)Connector.State.RUNNING);
        RestExtensionTestInfrastructure.getDebeziumContainer().waitForStreamingRunning("mongodb", config.asProperties().getProperty("topic.prefix"), "streaming", String.valueOf(0));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).get("/debezium/mongodb/connectors/{connector-name}/metrics", new Object[]{connectorName})).then()).log().all()).statusCode(200)).body("name", CoreMatchers.equalTo((Object)connectorName), new Object[0])).body("connector.metrics.Connected", CoreMatchers.equalTo((Object)"true"), new Object[0])).body("tasks[0].id", CoreMatchers.equalTo((Object)0), new Object[0])).body("tasks[0].namespaces[0].metrics.MilliSecondsSinceLastEvent", CoreMatchers.equalTo((Object)"-1"), new Object[0])).body("tasks[0].namespaces[0].metrics.TotalNumberOfEventsSeen", CoreMatchers.equalTo((Object)"0"), new Object[0]);
    }

    public static ConnectorConfiguration getMongoDbConnectorConfiguration(int id, String ... options) {
        ConnectorConfiguration config = ConnectorConfiguration.forMongoDbReplicaSet((MongoDbReplicaSet)RestExtensionTestInfrastructure.getMongoDbContainer()).with(MongoDbConnectorConfig.SERVER_SELECTION_TIMEOUT_MS.name(), Integer.valueOf(10000)).with(MongoDbConnectorConfig.SNAPSHOT_MODE.name(), "never").with(MongoDbConnectorConfig.USER.name(), "debezium").with(MongoDbConnectorConfig.PASSWORD.name(), "dbz").with(MongoDbConnectorConfig.TOPIC_PREFIX.name(), "mongo" + id);
        if (options != null && options.length > 0) {
            for (int i = 0; i < options.length; i += 2) {
                config.with(options[i], options[i + 1]);
            }
        }
        return config;
    }
}

