/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.junit;

import io.debezium.connector.mongodb.junit.DocumentDb;
import io.debezium.connector.mongodb.junit.MongoDbDatabaseProvider;
import io.debezium.testing.testcontainers.MongoDbDeployment;
import java.util.function.Supplier;

public enum MongoDbPlatform {
    MONGODB_DOCKER(MongoDbDatabaseProvider::dockerReplicaSet),
    DOCUMENT_DB(DocumentDb::new);

    public final Supplier<MongoDbDeployment> provider;

    private MongoDbPlatform(Supplier<MongoDbDeployment> provider) {
        this.provider = provider;
    }

    public final String value() {
        return this.name().toLowerCase();
    }

    public static MongoDbPlatform fromValue(String value) {
        return MongoDbPlatform.valueOf(value.toUpperCase());
    }
}

