/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.junit;

import com.mongodb.ConnectionString;
import io.debezium.testing.testcontainers.MongoDbDeployment;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MongoDbExternal
implements MongoDbDeployment {
    public static final String MONGO_CONNECTION_STRING = "mongodb.connection.string";
    private final String connectionString;

    public MongoDbExternal() {
        this(System.getProperty(MONGO_CONNECTION_STRING));
    }

    public MongoDbExternal(String connectionString) {
        this.connectionString = Objects.requireNonNull(connectionString, "Connection string is required for external MongoDB deployments");
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public List<String> getHosts() {
        ConnectionString cs = new ConnectionString(this.getConnectionString());
        return cs.getHosts().stream().map(h -> h.split(":")[0]).collect(Collectors.toList());
    }

    public void start() {
    }

    public void stop() {
    }
}

