/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.Configurator;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.doc.FixFor;
import org.apache.kafka.connect.errors.ConnectException;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiltersTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(FiltersTest.class);
    private Configurator build;
    private Filters filters;
    private Field.Set configFields;

    @Before
    public void beforeEach() {
        this.build = new Configurator();
        this.filters = null;
        this.configFields = Field.setOf((Field[])new Field[]{MongoDbConnectorConfig.FIELD_EXCLUDE_LIST, MongoDbConnectorConfig.FIELD_RENAMES});
    }

    @Test
    public void shouldIncludeDatabaseCoveredByLiteralInIncludeList() {
        this.filters = this.build.includeDatabases("db1").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isTrue();
        this.filters = this.build.useLiteralFilters().createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isTrue();
    }

    @Test
    public void shouldIncludeDatabaseCoveredByMultipleLiteralsInIncludeList() {
        this.filters = this.build.includeDatabases("db1,db2").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isTrue();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db2")).isTrue();
        this.filters = this.build.useLiteralFilters().createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isTrue();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db2")).isTrue();
    }

    @Test
    public void shouldIncludeDatabaseCoveredByMultipleLiteralsWithSpacesInIncludeListForLiteralFilters() {
        this.filters = this.build.useLiteralFilters().includeDatabases(" db1 ,  db2 ").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isTrue();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db2")).isTrue();
    }

    @Test
    public void shouldIncludeDatabaseCoveredByWildcardInIncludeList() {
        this.filters = this.build.includeDatabases("db.*").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isTrue();
    }

    @Test
    public void shouldIncludeDatabaseCoveredByMultipleWildcardsInIncludeList() {
        this.filters = this.build.includeDatabases("db.*,mongo.*").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isTrue();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("mongo2")).isTrue();
    }

    @Test
    public void shouldExcludeDatabaseCoveredByLiteralInExcludeList() {
        this.filters = this.build.excludeDatabases("db1").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isFalse();
        this.filters = this.build.useLiteralFilters().createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isFalse();
    }

    @Test
    public void shouldExcludeDatabaseCoveredByMultipleLiteralsInExcludeList() {
        this.filters = this.build.excludeDatabases("db1,db2").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isFalse();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db2")).isFalse();
        this.filters = this.build.useLiteralFilters().createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isFalse();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db2")).isFalse();
    }

    @Test
    public void shouldExcludeDatabaseCoveredByMultipleLiteralsWithSpacesInExcludeListForLiteralFilters() {
        this.filters = this.build.useLiteralFilters().excludeDatabases(" db1 ,  db2 ").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isFalse();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db2")).isFalse();
    }

    @Test
    public void shouldNotExcludeDatabaseNotCoveredByLiteralInExcludeList() {
        this.filters = this.build.excludeDatabases("db1").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db2")).isTrue();
        this.filters = this.build.useLiteralFilters().createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db2")).isTrue();
    }

    @Test
    public void shouldExcludeDatabaseCoveredByWildcardInExcludeList() {
        this.filters = this.build.excludeDatabases("db.*").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isFalse();
    }

    @Test
    public void shouldExcludeDatabaseCoveredByMultipleWildcardsInExcludeList() {
        this.filters = this.build.excludeDatabases("db.*,mongo.*").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isFalse();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("mongo2")).isFalse();
    }

    @Test
    public void shouldIncludeCollectionCoveredByLiteralWithPeriodAsWildcardInIncludeListAndNoExcludeList() {
        this.filters = this.build.includeCollections("db1.coll[.]?ection[x]?A,db1[.](.*)B").createFilters();
        this.assertCollectionIncluded("db1xcoll.ectionA");
        this.assertCollectionIncluded("db1.collectionA");
    }

    @Test
    public void shouldIncludeCollectionCoveredByLiteralInIncludeListAndNoExcludeList() {
        this.filters = this.build.includeCollections("db1.collectionA").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionExcluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
        this.filters = this.build.useLiteralFilters().createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionExcluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
    }

    @Test
    public void shouldIncludeCollectionCoveredByLiteralWithEscapedPeriodInIncludeListAndNoExcludeList() {
        this.filters = this.build.includeCollections("db1[.]collectionA").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionExcluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
        this.filters = this.build.includeCollections("db1\\.collectionA").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionExcluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
    }

    @Test
    public void shouldIncludeCollectionCoveredByMultipleLiteralsInIncludeListAndNoExcludeList() {
        this.filters = this.build.includeCollections("db1.collectionA,db1.collectionB").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionIncluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
        this.assertCollectionExcluded("db2.collectionB");
        this.filters = this.build.useLiteralFilters().createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionIncluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
        this.assertCollectionExcluded("db2.collectionB");
    }

    @Test
    public void shouldIncludeCollectionCoveredByMultipleLiteralsWithSpacesInIncludeListAndNoExcludeListForLiteralFilters() {
        this.filters = this.build.useLiteralFilters().includeCollections(" db1.collectionA ,  db1.collectionB ").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionIncluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
        this.assertCollectionExcluded("db2.collectionB");
    }

    @Test
    public void shouldIncludeCollectionCoveredByMultipleRegexInIncludeListAndNoExcludeList() {
        this.filters = this.build.includeCollections("db1.collection[x]?A,db1[.](.*)B").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionIncluded("db1.collectionxA");
        this.assertCollectionExcluded("db1.collectionx");
        this.assertCollectionExcluded("db1.collectioxA");
        this.assertCollectionIncluded("db1.B");
        this.assertCollectionIncluded("db1.collB");
        this.assertCollectionIncluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
        this.assertCollectionExcluded("db2.collectionxA");
        this.assertCollectionExcluded("db2.B");
        this.assertCollectionExcluded("db2.collB");
        this.assertCollectionExcluded("db2.collectionB");
    }

    @Test
    public void shouldIncludeCollectionCoveredByRegexWithWildcardInIncludeListAndNoExcludeList() {
        this.filters = this.build.includeCollections("db1[.](.*)").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionIncluded("db1.collectionxA");
        this.assertCollectionIncluded("db1.collectionx");
        this.assertCollectionIncluded("db1.collectioxA");
        this.assertCollectionIncluded("db1.B");
        this.assertCollectionIncluded("db1.collB");
        this.assertCollectionIncluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
        this.assertCollectionExcluded("db2.collectionxA");
        this.assertCollectionExcluded("db12.B");
        this.assertCollectionExcluded("db12.collB");
        this.assertCollectionExcluded("db12.collectionB");
    }

    @Test
    public void shouldExcludeCollectionCoveredByLiteralInExcludeList() {
        this.filters = this.build.excludeCollections("db1.collectionA").createFilters();
        this.assertCollectionExcluded("db1.collectionA");
        this.assertCollectionIncluded("db1.collectionB");
        this.assertCollectionIncluded("db2.collectionA");
        this.filters = this.build.useLiteralFilters().createFilters();
        this.assertCollectionExcluded("db1.collectionA");
        this.assertCollectionIncluded("db1.collectionB");
        this.assertCollectionIncluded("db2.collectionA");
    }

    @Test
    public void shouldExcludeCollectionCoveredByMultipleLiteralsnExcludeList() {
        this.filters = this.build.excludeCollections("db1.collectionA,db1.collectionB").createFilters();
        this.assertCollectionExcluded("db1.collectionA");
        this.assertCollectionExcluded("db1.collectionB");
        this.assertCollectionIncluded("db1.collectionC");
        this.assertCollectionIncluded("db2.collectionA");
        this.filters = this.build.useLiteralFilters().createFilters();
        this.assertCollectionExcluded("db1.collectionA");
        this.assertCollectionExcluded("db1.collectionB");
        this.assertCollectionIncluded("db1.collectionC");
        this.assertCollectionIncluded("db2.collectionA");
    }

    @Test
    public void shouldExcludeCollectionCoveredByMultipleLiteralsWithSpacesInExcludeListForLiteralFilters() {
        this.filters = this.build.useLiteralFilters().excludeCollections(" db1.collectionA ,  db1.collectionB ").createFilters();
        this.assertCollectionExcluded("db1.collectionA");
        this.assertCollectionExcluded("db1.collectionB");
        this.assertCollectionIncluded("db1.collectionC");
        this.assertCollectionIncluded("db2.collectionA");
    }

    @Test
    public void shouldIncludeAllCollectionsFromDatabaseWithSignalingCollection() {
        this.filters = this.build.includeDatabases("db1").signalingCollection("db1.singal").createFilters();
        this.assertCollectionIncluded("db1.other");
        this.filters = this.build.useLiteralFilters().createFilters();
        this.assertCollectionIncluded("db1.other");
    }

    @Test
    public void shouldIncludeSignalingCollectionAndNoIncludeListAndNoExcludeList() {
        this.filters = this.build.signalingCollection("db1.signal").createFilters();
        this.assertCollectionIncluded("db1.signal");
        this.filters = this.build.useLiteralFilters().createFilters();
        this.assertCollectionIncluded("db1.signal");
    }

    @Test
    public void shouldIncludeSignalingCollectionNotCoveredByIncludeList() {
        this.filters = this.build.includeCollections("db1.table").signalingCollection("db1.signal").createFilters();
        this.assertCollectionIncluded("db1.signal");
        this.filters = this.build.useLiteralFilters().createFilters();
        this.assertCollectionIncluded("db1.signal");
    }

    @Test
    public void shouldIncludeSignalingCollectionCoveredByLiteralInExcludeList() {
        this.filters = this.build.excludeCollections("db1.signal").signalingCollection("db1.signal").createFilters();
        this.assertCollectionIncluded("db1.signal");
        this.filters = this.build.useLiteralFilters().createFilters();
        this.assertCollectionIncluded("db1.signal");
    }

    @Test
    public void shouldIncludeSignalingCollectionCoveredByRegexInExcludeList() {
        this.filters = this.build.excludeCollections("db1.*").signalingCollection("db1.signal").createFilters();
        this.assertCollectionIncluded("db1.signal");
    }

    @Test
    public void excludeFilterShouldRemoveMatchingField() {
        this.filters = this.build.excludeFields("db1.collectionA.key1").createFilters();
        this.validateConfigFields();
        CollectionId id = CollectionId.parse((String)"rs1.", (String)"db1.collectionA");
        Assert.assertEquals((Object)Document.parse((String)" { \"key2\" : \"value2\" }"), (Object)this.filters.fieldFilterFor(id).apply(Document.parse((String)" { \"key1\" : \"value1\", \"key2\" : \"value2\" }")));
    }

    @Test
    public void excludeFilterShouldRemoveMatchingFieldWithLeadingWhiteSpaces() {
        this.filters = this.build.excludeFields(" *.collectionA.key1").createFilters();
        this.validateConfigFields();
        CollectionId id = CollectionId.parse((String)"rs1.", (String)" *.collectionA");
        Assert.assertEquals((Object)Document.parse((String)" { \"key2\" : \"value2\" }"), (Object)this.filters.fieldFilterFor(id).apply(Document.parse((String)" { \"key1\" : \"value1\", \"key2\" : \"value2\" }")));
    }

    @Test
    @FixFor(value={"DBZ-5818"})
    public void excludeFilterShouldRemoveMatchingFieldWithLeadingMultipleAsterisks() {
        this.filters = this.build.excludeFields(" *.*.key1").createFilters();
        this.validateConfigFields();
        CollectionId id = CollectionId.parse((String)"rs1.", (String)" *.collectionA");
        Assert.assertEquals((Object)Document.parse((String)" { \"key2\" : \"value2\" }"), (Object)this.filters.fieldFilterFor(id).apply(Document.parse((String)" { \"key1\" : \"value1\", \"key2\" : \"value2\" }")));
    }

    @Test
    public void excludeFilterShouldRemoveMatchingFieldWithTrailingWhiteSpaces() {
        this.filters = this.build.excludeFields("db.collectionA.key1 ,db.collectionA.key2 ").createFilters();
        this.validateConfigFields();
        CollectionId id = CollectionId.parse((String)"rs1.", (String)"db.collectionA");
        Assert.assertEquals((Object)Document.parse((String)" { \"key3\" : \"value3\" }"), (Object)this.filters.fieldFilterFor(id).apply(Document.parse((String)" { \"key1\" : \"value1\", \"key2\" : \"value2\", \"key3\" : \"value3\" }")));
    }

    @Test
    public void renameFilterShouldRenameMatchingField() {
        this.filters = this.build.renameFields("db1.collectionA.key1:key2").createFilters();
        this.validateConfigFields();
        CollectionId id = CollectionId.parse((String)"rs1.", (String)"db1.collectionA");
        Assert.assertEquals((Object)Document.parse((String)" { \"key2\" : \"value1\" }"), (Object)this.filters.fieldFilterFor(id).apply(Document.parse((String)" { \"key1\" : \"value1\" }")));
    }

    @Test
    public void renameFilterShouldRenameMatchingFieldWithLeadingWhiteSpaces() {
        this.filters = this.build.renameFields(" *.collectionA.key2:key3").createFilters();
        this.validateConfigFields();
        CollectionId id = CollectionId.parse((String)"rs1.", (String)" *.collectionA");
        Assert.assertEquals((Object)Document.parse((String)" { \"key1\" : \"valueA\", \"key3\" : \"valueB\" }"), (Object)this.filters.fieldFilterFor(id).apply(Document.parse((String)" { \"key1\" : \"valueA\", \"key2\" : \"valueB\" }")));
    }

    @Test
    @FixFor(value={"DBZ-5818"})
    public void renameFilterShouldRenameMatchingFieldWithLeadingMultipleAsterisks() {
        this.filters = this.build.renameFields(" *.*.key2:key3").createFilters();
        this.validateConfigFields();
        CollectionId id = CollectionId.parse((String)"rs1.", (String)" *.collectionA");
        Assert.assertEquals((Object)Document.parse((String)" { \"key1\" : \"valueA\", \"key3\" : \"valueB\" }"), (Object)this.filters.fieldFilterFor(id).apply(Document.parse((String)" { \"key1\" : \"valueA\", \"key2\" : \"valueB\" }")));
    }

    @Test
    public void renameFilterShouldRenameMatchingFieldWithTrailingWhiteSpaces() {
        this.filters = this.build.renameFields("db2.collectionA.key1:key2 ,db2.collectionA.key3:key4 ").createFilters();
        this.validateConfigFields();
        CollectionId id = CollectionId.parse((String)"rs1.", (String)"db2.collectionA");
        Assert.assertEquals((Object)Document.parse((String)" { \"key2\" : \"valueA\", \"key4\" : \"valueB\" }"), (Object)this.filters.fieldFilterFor(id).apply(Document.parse((String)" { \"key1\" : \"valueA\", \"key3\" : \"valueB\" }")));
    }

    protected void assertCollectionIncluded(String fullyQualifiedCollectionName) {
        CollectionId id = CollectionId.parse((String)"rs1.", (String)fullyQualifiedCollectionName);
        Assertions.assertThat((Object)id).isNotNull();
        Assertions.assertThat((boolean)this.filters.collectionFilter().test(id)).isTrue();
    }

    protected void assertCollectionExcluded(String fullyQualifiedCollectionName) {
        CollectionId id = CollectionId.parse((String)"rs1.", (String)fullyQualifiedCollectionName);
        Assertions.assertThat((Object)id).isNotNull();
        Assertions.assertThat((boolean)this.filters.collectionFilter().test(id)).isFalse();
    }

    private void validateConfigFields() {
        Configuration config = this.build.config();
        if (!config.validateAndRecord((Iterable)this.configFields, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new ConnectException("Unable to validate config.");
        }
    }
}

