/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.client.MongoClient;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterType;
import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.MongoUtil;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.connector.mongodb.connection.ConnectionContext;
import io.debezium.connector.mongodb.connection.ConnectionStrings;
import io.debezium.connector.mongodb.connection.ReplicaSet;
import io.debezium.function.BlockingConsumer;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ReplicaSetDiscovery {
    public static final String CONFIG_DATABASE_NAME = "config";
    public static final String SHARDS_COLLECTION_NAME = "shards";
    public static final String ADMIN_DATABASE_NAME = "admin";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicaSetDiscovery.class);
    private final MongoDbTaskContext context;
    private final String maskedConnectionSeed;

    public ReplicaSetDiscovery(MongoDbTaskContext context) {
        this.context = context;
        this.maskedConnectionSeed = context.getConnectionContext().maskedConnectionSeed();
    }

    public ReplicaSets getReplicaSets(MongoClient client) {
        ConnectionContext connectionContext = this.context.getConnectionContext();
        HashSet<ReplicaSet> replicaSetSpecs = new HashSet<ReplicaSet>();
        LOGGER.info("Reading description of cluster at {}", (Object)this.maskedConnectionSeed);
        ClusterDescription clusterDescription = MongoUtil.clusterDescription(client);
        if (clusterDescription.getType() == ClusterType.SHARDED) {
            LOGGER.info("Cluster identified as sharded cluster");
            MongoDbConnectorConfig.ConnectionMode connectionMode = this.context.getConnectorConfig().getConnectionMode();
            if (MongoDbConnectorConfig.ConnectionMode.SHARDED.equals((Object)connectionMode)) {
                LOGGER.info("ConnectionMode set to '{}', single connection to sharded cluster will be used", (Object)connectionMode.getValue());
                this.readShardedClusterAsReplicaSet(replicaSetSpecs, connectionContext);
            } else if (MongoDbConnectorConfig.ConnectionMode.REPLICA_SET.equals((Object)connectionMode)) {
                LOGGER.info("ConnectionMode set to '{}, individual shard connections will be used", (Object)connectionMode.getValue());
                this.readReplicaSetsFromShardedCluster(replicaSetSpecs, client);
            } else {
                LOGGER.warn("Incompatible connection mode '{}' specified", (Object)connectionMode.getValue());
            }
        }
        if (clusterDescription.getType() == ClusterType.REPLICA_SET) {
            LOGGER.info("Cluster identified as replicaSet");
            this.readReplicaSetsFromCluster(replicaSetSpecs, clusterDescription, connectionContext);
        }
        if (replicaSetSpecs.isEmpty()) {
            LOGGER.error("Found no replica sets at {}, so there is nothing to monitor and no connector tasks will be started.", (Object)this.maskedConnectionSeed);
        }
        return new ReplicaSets(replicaSetSpecs);
    }

    private void readShardedClusterAsReplicaSet(Set<ReplicaSet> replicaSetSpecs, ConnectionContext connectionContext) {
        LOGGER.info("Using '{}' as sharded cluster connection", (Object)this.maskedConnectionSeed);
        ConnectionString connectionString = connectionContext.connectionString();
        replicaSetSpecs.add(new ReplicaSet(connectionString));
    }

    private void readReplicaSetsFromCluster(Set<ReplicaSet> replicaSetSpecs, ClusterDescription clusterDescription, ConnectionContext connectionContext) {
        String connectionString = this.ensureReplicaSetName(connectionContext.connectionSeed(), clusterDescription);
        LOGGER.info("Using '{}' as replica set connection string", (Object)ConnectionStrings.mask(connectionString));
        replicaSetSpecs.add(new ReplicaSet(connectionString));
    }

    public void readReplicaSetsFromShardedCluster(Set<ReplicaSet> replicaSetSpecs, MongoClient client) {
        try {
            String csParams = this.context.getConnectorConfig().getShardConnectionParameters();
            MongoUtil.onCollectionDocuments(client, CONFIG_DATABASE_NAME, SHARDS_COLLECTION_NAME, (BlockingConsumer<Document>)((BlockingConsumer)doc -> {
                String shardName = doc.getString((Object)"_id");
                String hostStr = doc.getString((Object)"host");
                LOGGER.info("Reading shard details for {}", (Object)shardName);
                ConnectionStrings.parseFromHosts(hostStr).map(cs -> ConnectionStrings.appendParameters(cs, csParams)).ifPresentOrElse(cs -> replicaSetSpecs.add(new ReplicaSet((String)cs)), () -> LOGGER.info("Shard {} is not a valid replica set", (Object)shardName));
            }));
        }
        catch (MongoInterruptedException e) {
            LOGGER.error("Interrupted while reading the '{}' collection in the '{}' database: {}", new Object[]{SHARDS_COLLECTION_NAME, CONFIG_DATABASE_NAME, e.getMessage(), e});
            Thread.currentThread().interrupt();
        }
        catch (MongoException e) {
            LOGGER.error("Error while reading the '{}' collection in the '{}' database: {}", new Object[]{SHARDS_COLLECTION_NAME, CONFIG_DATABASE_NAME, e.getMessage(), e});
        }
    }

    private String ensureReplicaSetName(String connectionString, ClusterDescription clusterDescription) {
        ConnectionString cs = new ConnectionString(connectionString);
        if (cs.getRequiredReplicaSetName() != null) {
            return connectionString;
        }
        LOGGER.warn("Replica set not specified in '{}'", (Object)this.maskedConnectionSeed);
        LOGGER.warn("Parameter 'replicaSet' should be added to connection string");
        LOGGER.warn("Trying to determine replica set name for '{}'", (Object)this.maskedConnectionSeed);
        Optional<String> rsName = MongoUtil.replicaSetName(clusterDescription);
        if (rsName.isPresent()) {
            LOGGER.info("Found '{}' replica set for '{}'", (Object)rsName.get(), (Object)this.maskedConnectionSeed);
            return ConnectionStrings.appendParameter(connectionString, "replicaSet", rsName.get());
        }
        LOGGER.warn("Unable to find replica set name for '{}'", (Object)this.maskedConnectionSeed);
        return connectionString;
    }
}

