/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.connector.mongodb.JsonSerialization;
import org.assertj.core.api.Assertions;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.junit.Test;

public class JsonSerializationTest {
    private JsonSerialization serialization = new JsonSerialization();

    @Test
    public void shouldGeOnlyIdFromCompositeKey() {
        BsonInt32 id = new BsonInt32(42);
        BsonDocument composite = new BsonDocument("email", (BsonValue)new BsonString("foo@bar.com")).append("_id", (BsonValue)id);
        String key = this.serialization.getDocumentId(composite);
        Assertions.assertThat((String)key).isEqualTo((Object)"42");
    }

    @Test
    public void shouldGetEqualDocumentIdFromSimpleAndComposite() {
        BsonObjectId id = new BsonObjectId();
        BsonDocument simple = new BsonDocument("_id", (BsonValue)id);
        BsonDocument composite = new BsonDocument("email", (BsonValue)new BsonString("foo@bar.com")).append("_id", (BsonValue)id);
        String simpleKey = this.serialization.getDocumentId(simple);
        String compositeKey = this.serialization.getDocumentId(composite);
        Assertions.assertThat((String)compositeKey).isEqualTo((Object)simpleKey);
    }
}

