/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.rest;

import io.debezium.rest.model.MetricsAttributes;
import io.debezium.rest.model.MetricsDescriptor;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.kafka.connect.connector.Connector;

public interface MetricsResource
extends MetricsAttributes {
    public static final String CONNECTOR_METRICS_ENDPOINT = "/connectors/{connector-name}/metrics";
    public static final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();

    public Connector getConnector();

    public MetricsDescriptor getMetrics(String var1) throws MalformedObjectNameException, InstanceNotFoundException, IntrospectionException, ReflectionException, AttributeNotFoundException, MBeanException;

    default public ObjectName getObjectName(String connector, String context, String serverName) throws MalformedObjectNameException {
        return new ObjectName(String.format("debezium.%s:type=connector-metrics,context=%s,server=%s", connector, context, serverName));
    }

    default public ObjectName getObjectName(String connector, String context, String serverName, String task) throws MalformedObjectNameException {
        return new ObjectName(String.format("debezium.%s:type=connector-metrics,context=%s,server=%s,task=%s", connector, context, serverName, task));
    }

    default public ObjectName getObjectName(String connector, String context, String serverName, String task, String databaseName) throws MalformedObjectNameException {
        return new ObjectName(String.format("debezium.%s:type=connector-metrics,context=%s,server=%s,task=%s,database=%s", connector, context, serverName, task, databaseName));
    }

    default public Map<String, String> getAttributes(List<String> attributes, ObjectName objectName, String connectorName, MBeanServer mBeanServer) {
        return attributes.stream().collect(Collectors.toMap(attribute -> attribute, attribute -> this.getAttributeValue((String)attribute, objectName, connectorName, mBeanServer)));
    }

    default public String getAttributeValue(String attribute, ObjectName objectName, String connectorName, MBeanServer mBeanServer) {
        try {
            return mBeanServer.getAttribute(objectName, attribute).toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get attribute " + attribute + " for connector " + connectorName + e);
        }
    }

    default public MetricsDescriptor queryMetrics(Map<String, String> connectorConfig, String connectorName, String connector, String context) throws MalformedObjectNameException {
        String serverName = connectorConfig.get("topic.prefix");
        String tasksMax = connectorConfig.get("tasks.max");
        String databaseNames = connectorConfig.get("database.names");
        String[] namespaces = null;
        if (databaseNames != null) {
            namespaces = databaseNames.split(",");
        }
        ArrayList<MetricsDescriptor.Task> tasksPayload = new ArrayList<MetricsDescriptor.Task>();
        MetricsDescriptor.Connector connectorPayload = null;
        for (int task = 0; task < Integer.parseInt(tasksMax); ++task) {
            Map<String, String> connectorAttributes;
            ObjectName objectName = connector.equals("sql_server") || connector.equals("mongodb") ? this.getObjectName(connector, context, serverName, String.valueOf(task)) : this.getObjectName(connector, context, serverName);
            Map<String, String> connectionAttributes = this.getAttributes(this.getConnectionAttributes(), objectName, connectorName, mBeanServer);
            connectorPayload = new MetricsDescriptor.Connector(connectionAttributes);
            ArrayList<MetricsDescriptor.Namespace> namespacesPayload = new ArrayList<MetricsDescriptor.Namespace>();
            if (namespaces != null) {
                for (String namespace : namespaces) {
                    ObjectName objectNameWithNamespace = this.getObjectName(connector, context, serverName, String.valueOf(task), namespace);
                    connectorAttributes = this.getAttributes(this.getConnectorAttributes(), objectNameWithNamespace, connectorName, mBeanServer);
                    namespacesPayload.add(new MetricsDescriptor.Namespace(namespace, connectorAttributes));
                }
            } else {
                connectorAttributes = this.getAttributes(this.getConnectorAttributes(), objectName, connectorName, mBeanServer);
                namespacesPayload.add(new MetricsDescriptor.Namespace("", connectorAttributes));
            }
            tasksPayload.add(new MetricsDescriptor.Task(task, namespacesPayload));
        }
        return new MetricsDescriptor(connectorName, tasksMax, connectorPayload, tasksPayload);
    }

    @Override
    default public List<String> getConnectionAttributes() {
        return CONNECTION_ATTRIBUTES;
    }

    @Override
    default public List<String> getConnectorAttributes() {
        return CONNECTOR_ATTRIBUTES;
    }

    @GET
    @Path(value="/connectors/{connector-name}/metrics")
    @Produces(value={"application/json"})
    default public MetricsDescriptor getConnectorMetrics(@PathParam(value="connector-name") String connectorName) throws ReflectionException, MalformedObjectNameException, InstanceNotFoundException, IntrospectionException, AttributeNotFoundException, MBeanException {
        if (this.getConnector() == null) {
            throw new RuntimeException("Unable to fetch metrics for connector " + connectorName + " as the connector is not available.");
        }
        return this.getMetrics(connectorName);
    }
}

