/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.ConnectionString;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.mongodb.ChangeStreamPipeline;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbSourceInfoStructMaker;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.connector.mongodb.connection.ConnectionStrings;
import io.debezium.connector.mongodb.connection.DefaultMongoDbAuthProvider;
import io.debezium.connector.mongodb.connection.ReplicaSet;
import io.debezium.schema.DefaultTopicNamingStrategy;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.data.Struct;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbConnectorConfig
extends CommonConnectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbConnectorConfig.class);
    protected static final String COLLECTION_INCLUDE_LIST_ALREADY_SPECIFIED_ERROR_MSG = "\"collection.include.list\" is already specified";
    protected static final String DATABASE_INCLUDE_LIST_ALREADY_SPECIFIED_ERROR_MSG = "\"database.include.list\" is already specified";
    protected static final Pattern PATTERN_SPILT = Pattern.compile(",");
    protected static final Pattern FIELD_EXCLUDE_LIST_PATTERN = Pattern.compile("^[*|\\w|\\-|\\s*]+(?:\\.[*|\\w|\\-]+\\.[*|\\w|\\-]+)+(\\.[*|\\w|\\-]+)*\\s*$");
    protected static final String QUALIFIED_FIELD_EXCLUDE_LIST_PATTERN = "<databaseName>.<collectionName>.<fieldName>.<nestedFieldName>";
    protected static final Pattern FIELD_RENAMES_PATTERN = Pattern.compile("^[*|\\w|\\-|\\s*]+(?:\\.[*|\\w|\\-]+\\.[*|\\w|\\-]+)+(\\.[*|\\w|\\-]+)*:(?:[*|\\w|\\-]+)+\\s*$");
    protected static final String QUALIFIED_FIELD_RENAMES_PATTERN = "<databaseName>.<collectionName>.<fieldName>.<nestedFieldName>:<newNestedFieldName>";
    private final String shardConnectionParameters;
    protected static final int DEFAULT_SNAPSHOT_FETCH_SIZE = 0;
    public static final Field TASK_CONNECTION_STRINGS = Field.createInternal((String)"mongodb.internal.task.connection.strings").withDescription("Internal use only").withType(ConfigDef.Type.LIST);
    public static final Field ALLOW_OFFSET_INVALIDATION = Field.createInternal((String)"mongodb.allow.offset.invalidation").withDescription("Allows offset invalidation when required by change of connection mode").withDefault(false).withType(ConfigDef.Type.BOOLEAN);
    public static final Field CONNECTION_STRING = Field.create((String)"mongodb.connection.string").withDisplayName("Connection String").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)1)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{MongoDbConnectorConfig::validateConnectionString}).withDescription("Database connection string.");
    public static final Field SHARD_CONNECTION_PARAMS = Field.create((String)"mongodb.connection.string.shard.params").withDisplayName("Shard connection parameters").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)6)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The connection string parameters used when connecting to individual shards of sharded cluster.Only applicable with replica_set connection mode.");
    public static final Field CONNECTION_MODE = Field.create((String)"mongodb.connection.mode").withDisplayName("Connection mode").withEnum(ConnectionMode.class, (Enum)ConnectionMode.SHARDED).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)2)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("The method used to connect to MongoDB cluster. Options include: 'replica_set' to individually connect to each replica set / shard 'sharded' (the default) to connect via single connection obtained from connection string");
    public static final Field USER = Field.create((String)"mongodb.user").withDisplayName("User").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)3)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Database user for connecting to MongoDB, if necessary.");
    public static final Field PASSWORD = Field.create((String)"mongodb.password").withDisplayName("Password").withType(ConfigDef.Type.PASSWORD).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)4)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Password to be used when connecting to MongoDB, if necessary.");
    public static final Field MONGODB_POLL_INTERVAL_MS = Field.create((String)"mongodb.poll.interval.ms").withDisplayName("Replica membership poll interval (ms)").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)5)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(30000L).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("Interval for looking for new, removed, or changed replica sets, given in milliseconds. Defaults to 30 seconds (30,000 ms).");
    public static final Field SSL_ENABLED = Field.create((String)"mongodb.ssl.enabled").withDisplayName("Enable SSL connection to MongoDB").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(false).withValidation(new Field.Validator[]{Field::isBoolean}).withDescription("Should connector use SSL to connect to MongoDB instances");
    public static final Field SSL_ALLOW_INVALID_HOSTNAMES = Field.create((String)"mongodb.ssl.invalid.hostname.allowed").withDisplayName("Allow invalid hostnames for SSL connection").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(false).withValidation(new Field.Validator[]{Field::isBoolean}).withDescription("Whether invalid host names are allowed when using SSL. If true the connection will not prevent man-in-the-middle attacks");
    public static final Field CONNECT_TIMEOUT_MS = Field.create((String)"mongodb.connect.timeout.ms").withDisplayName("Connect Timeout MS").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(10000).withDescription("The connection timeout, given in milliseconds. Defaults to 10 seconds (10,000 ms).");
    public static final Field AUTH_SOURCE = Field.create((String)"mongodb.authsource").withDisplayName("Credentials Database").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault("admin").withDescription("Database containing user credentials.");
    public static final Field SERVER_SELECTION_TIMEOUT_MS = Field.create((String)"mongodb.server.selection.timeout.ms").withDisplayName("Server selection timeout MS").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)2)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(30000).withDescription("The server selection timeout, given in milliseconds. Defaults to 10 seconds (10,000 ms).");
    public static final Field SOCKET_TIMEOUT_MS = Field.create((String)"mongodb.socket.timeout.ms").withDisplayName("Socket timeout MS").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)3)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(0).withDescription("The socket timeout, given in milliseconds. Defaults to 0 ms.");
    public static final Field HEARTBEAT_FREQUENCY_MS = Field.create((String)"mongodb.heartbeat.frequency.ms").withDisplayName("Heartbeat frequency ms").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)4)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(10000).withDescription("The frequency that the cluster monitor attempts to reach each server. Defaults to 10 seconds (10,000 ms).");
    public static final Field AUTH_PROVIDER_CLASS = Field.create((String)"mongodb.authentication.class").withDisplayName("Authentication Provider Custom Class").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)5)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDefault(DefaultMongoDbAuthProvider.class.getName()).withDescription("This class must implement the 'MongoDbAuthProvider' interface and is called on each app boot to provide the MongoDB credentials from the provided config.");
    public static final Field DATABASE_INCLUDE_LIST = Field.create((String)"database.include.list").withDisplayName("Include Databases").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry((Field.Group)Field.Group.FILTERS, (int)0)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{MongoDbConnectorConfig::validateListOfRegexesOrLiterals}).withDescription("A comma-separated list of regular expressions or literals that match the database names for which changes are to be captured");
    public static final Field DATABASE_EXCLUDE_LIST = Field.create((String)"database.exclude.list").withDisplayName("Exclude Databases").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry((Field.Group)Field.Group.FILTERS, (int)1)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{MongoDbConnectorConfig::validateListOfRegexesOrLiterals, MongoDbConnectorConfig::validateDatabaseExcludeList}).withDescription("A comma-separated list of regular expressions or literals that match the database names for which changes are to be excluded");
    public static final Field COLLECTION_INCLUDE_LIST = Field.create((String)"collection.include.list").withDisplayName("Include Collections").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry((Field.Group)Field.Group.FILTERS, (int)2)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{MongoDbConnectorConfig::validateListOfRegexesOrLiterals}).withDescription("A comma-separated list of regular expressions or literals that match the collection names for which changes are to be captured");
    public static final Field COLLECTION_EXCLUDE_LIST = Field.create((String)"collection.exclude.list").withGroup(Field.createGroupEntry((Field.Group)Field.Group.FILTERS, (int)3)).withValidation(new Field.Validator[]{MongoDbConnectorConfig::validateListOfRegexesOrLiterals, MongoDbConnectorConfig::validateCollectionExcludeList}).withInvisibleRecommender().withDescription("A comma-separated list of regular expressions or literals that match the collection names for which changes are to be excluded");
    public static final Field FILTERS_MATCH_MODE = Field.create((String)"filters.match.mode").withDisplayName("Database and collection include/exclude match mode").withEnum(FiltersMatchMode.class, (Enum)FiltersMatchMode.REGEX).withGroup(Field.createGroupEntry((Field.Group)Field.Group.FILTERS, (int)6)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The mode used by the aggregation pipeline to match events based on included/excluded database and collection namesOptions include: 'regex' (the default) Database and collection includes/excludes are evaluated as regular expressions; 'literal' Database and collection includes/excludes are evaluated as comma-separated list of string literals; ");
    public static final Field FIELD_EXCLUDE_LIST = Field.create((String)"field.exclude.list").withDisplayName("Exclude Fields").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.FILTERS, (int)5)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{MongoDbConnectorConfig::validateFieldExcludeList}).withDescription("A comma-separated list of the fully-qualified names of fields that should be excluded from change event message values");
    public static final Field FIELD_RENAMES = Field.create((String)"field.renames").withDisplayName("Rename Fields").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)0)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{MongoDbConnectorConfig::validateFieldRenamesList}).withDescription("A comma-separated list of the fully-qualified replacements of fields that should be used to rename fields in change event message values. Fully-qualified replacements for fields are of the form databaseName.collectionName.fieldName.nestedFieldName:newNestedFieldName, where databaseName and collectionName may contain the wildcard (*) which matches any characters, the colon character (:) is used to determine rename mapping of field.");
    public static final Field CAPTURE_MODE = Field.create((String)"capture.mode").withDisplayName("Capture mode").withEnum(CaptureMode.class, (Enum)CaptureMode.CHANGE_STREAMS_UPDATE_FULL).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The method used to capture changes from MongoDB server. Options include: 'change_streams' to capture changes via MongoDB Change Streams, update events do not contain full documents; 'change_streams_update_full' (the default) to capture changes via MongoDB Change Streams, update events contain full documents");
    public static final Field CAPTURE_SCOPE = Field.create((String)"capture.scope").withDisplayName("Capture scope").withEnum(CaptureScope.class, (Enum)CaptureScope.DEPLOYMENT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)2)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The scope of captured changes. Options include: 'deployment' (the default) to capture changes from the entire MongoDB deployment; 'database' to capture changes from a specific MongoDB database");
    public static final Field CAPTURE_TARGET = Field.create((String)"capture.target").withDisplayName("Capture target").withType(ConfigDef.Type.STRING).withValidation(new Field.Validator[]{MongoDbConnectorConfig::validateCaptureTarget}).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)3)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Name of captured database for " + CAPTURE_SCOPE.name() + "=" + CaptureScope.DATABASE.value);
    protected static final Field TASK_ID = Field.create((String)"mongodb.task.id").withDescription("Internal use only").withValidation(new Field.Validator[]{Field::isInteger}).withInvisibleRecommender();
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The criteria for running a snapshot upon startup of the connector. Select one of the following snapshot options: 'initial' (default):  If the connector does not detect any offsets for the logical server name, it runs a snapshot that captures the current full state of the configured tables. After the snapshot completes, the connector begins to stream changes from the oplog. 'never': The connector does not run a snapshot. Upon first startup, the connector immediately begins reading from the beginning of the oplog.");
    public static final Field SNAPSHOT_FILTER_QUERY_BY_COLLECTION = Field.create((String)"snapshot.collection.filter.overrides").withDisplayName("Snapshot mode").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)1)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("This property contains a comma-separated list of <dbName>.<collectionName>, for which  the initial snapshot may be a subset of data present in the data source. The subset would be defined by mongodb filter query specified as value for property snapshot.collection.filter.override.<dbname>.<collectionName>");
    public static final Field CURSOR_MAX_AWAIT_TIME_MS = Field.create((String)"cursor.max.await.time.ms").withDisplayName("Server's oplog streaming cursor max await time").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The maximum processing time in milliseconds to wait for the oplog cursor to process a single poll request");
    public static final Field CURSOR_PIPELINE = Field.create((String)"cursor.pipeline").withDisplayName("Pipeline stages applied to the change stream cursor").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)4)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withValidation(new Field.Validator[]{MongoDbConnectorConfig::validateChangeStreamPipeline}).withDescription("Applies processing to change events as part of the the standard MongoDB aggregation stream pipeline. A pipeline is a MongoDB aggregation pipeline composed of instructions to the database to filter or transform data. This can be used customize the data that the connector consumes. Note that this comes after the internal pipelines used to support the connector (e.g. filtering database and collection names).");
    public static final Field CURSOR_PIPELINE_ORDER = Field.create((String)"cursor.pipeline.order").withDisplayName("Change stream cursor pipeline order").withEnum(CursorPipelineOrder.class, (Enum)CursorPipelineOrder.INTERNAL_FIRST).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)5)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The order used to construct the effective MongoDB aggregation stream pipeline Options include: 'internal_first' (the default) Internal stages defined by the connector are applied first; 'user_first' Stages defined by the 'cursor.pipeline' property are applied first; 'user_only' Stages defined by the 'cursor.pipeline' property will replace internal stages defined by the connector; ");
    public static final Field CURSOR_OVERSIZE_HANDLING_MODE = Field.create((String)"cursor.oversize.handling.mode").withDisplayName("Oversize document handling mode").withEnum(OversizeHandlingMode.class, (Enum)OversizeHandlingMode.FAIL).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)6)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The strategy used to handle change events for documents exceeding specified BSON size. Options include: 'fail' (the default) the connector fails if the total size of change event exceed the maximum BSON size'skip' any change events for documents exceeding the maximum size will be ignored'split' change events exceeding the maximum BSON size will be split using the $changeStreamSplitLargeEvent aggregation");
    public static final Field CURSOR_OVERSIZE_SKIP_THRESHOLD = Field.create((String)"cursor.oversize.skip.threshold").withDisplayName("Oversize document skip threshold").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)7)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(0).withValidation(new Field.Validator[]{MongoDbConnectorConfig::validateOversizeSkipThreshold}).withDescription("The maximum allowed size of the stored document for which change events are processed. This includes both, the size before and after database operation, more specifically this limits the size of fullDocument and fullDocumentBeforeChange filed of MongoDB change events.");
    public static final Field TOPIC_NAMING_STRATEGY = Field.create((String)"topic.naming.strategy").withDisplayName("Topic naming strategy class").withType(ConfigDef.Type.CLASS).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The name of the TopicNamingStrategy class that should be used to determine the topic name for data change, schema change, transaction, heartbeat event etc.").withDefault(DefaultTopicNamingStrategy.class.getName());
    public static final Field SOURCE_INFO_STRUCT_MAKER = CommonConnectorConfig.SOURCE_INFO_STRUCT_MAKER.withDefault(MongoDbSourceInfoStructMaker.class.getName());
    private static final ConfigDefinition CONFIG_DEFINITION = CommonConnectorConfig.CONFIG_DEFINITION.edit().name("MongoDB").type(new Field[]{TOPIC_PREFIX, CONNECTION_STRING, CONNECTION_MODE, ALLOW_OFFSET_INVALIDATION, USER, PASSWORD, AUTH_SOURCE, CONNECT_TIMEOUT_MS, HEARTBEAT_FREQUENCY_MS, SOCKET_TIMEOUT_MS, SERVER_SELECTION_TIMEOUT_MS, MONGODB_POLL_INTERVAL_MS, SSL_ENABLED, SSL_ALLOW_INVALID_HOSTNAMES, CURSOR_MAX_AWAIT_TIME_MS}).events(new Field[]{DATABASE_INCLUDE_LIST, DATABASE_EXCLUDE_LIST, COLLECTION_INCLUDE_LIST, COLLECTION_EXCLUDE_LIST, FIELD_EXCLUDE_LIST, FIELD_RENAMES, SNAPSHOT_FILTER_QUERY_BY_COLLECTION, SOURCE_INFO_STRUCT_MAKER}).connector(new Field[]{SNAPSHOT_MODE, CAPTURE_MODE, SCHEMA_NAME_ADJUSTMENT_MODE}).create();
    public static Field.Set ALL_FIELDS;
    protected static Field.Set EXPOSED_FIELDS;
    private final SnapshotMode snapshotMode;
    private CaptureMode captureMode;
    private final CaptureScope captureScope;
    private final String captureTarget;
    private final ConnectionMode connectionMode;
    private final boolean offsetInvalidationAllowed;
    private final int snapshotMaxThreads;
    private final int cursorMaxAwaitTimeMs;
    private final ReplicaSets replicaSets;
    private final CursorPipelineOrder cursorPipelineOrder;
    private final OversizeHandlingMode oversizeHandlingMode;
    private final FiltersMatchMode filtersMatchMode;
    private final int oversizeSkipThreshold;

    public static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public MongoDbConnectorConfig(Configuration config) {
        super(config, 0);
        String snapshotModeValue = config.getString(SNAPSHOT_MODE);
        this.snapshotMode = SnapshotMode.parse(snapshotModeValue, SNAPSHOT_MODE.defaultValueAsString());
        String captureModeValue = config.getString(CAPTURE_MODE);
        this.captureMode = CaptureMode.parse(captureModeValue, CAPTURE_MODE.defaultValueAsString());
        String connectionModeValue = config.getString(CONNECTION_MODE);
        this.connectionMode = ConnectionMode.parse(connectionModeValue, CONNECTION_MODE.defaultValueAsString());
        this.shardConnectionParameters = config.getString(SHARD_CONNECTION_PARAMS);
        this.offsetInvalidationAllowed = config.getBoolean(ALLOW_OFFSET_INVALIDATION);
        String captureScopeValue = config.getString(CAPTURE_SCOPE);
        this.captureScope = CaptureScope.parse(captureScopeValue, CAPTURE_SCOPE.defaultValueAsString());
        this.captureTarget = config.getString(CAPTURE_TARGET);
        String cursorPipelineOrderValue = config.getString(CURSOR_PIPELINE_ORDER);
        this.cursorPipelineOrder = CursorPipelineOrder.parse(cursorPipelineOrderValue, CURSOR_PIPELINE_ORDER.defaultValueAsString());
        String oversizeHandlingModeValue = config.getString(CURSOR_OVERSIZE_HANDLING_MODE);
        this.oversizeHandlingMode = OversizeHandlingMode.parse(oversizeHandlingModeValue, CURSOR_OVERSIZE_HANDLING_MODE.defaultValueAsString());
        this.oversizeSkipThreshold = config.getInteger(CURSOR_OVERSIZE_SKIP_THRESHOLD);
        String filterMatchModeValue = config.getString(FILTERS_MATCH_MODE);
        this.filtersMatchMode = FiltersMatchMode.parse(filterMatchModeValue, FILTERS_MATCH_MODE.defaultValueAsString());
        this.snapshotMaxThreads = MongoDbConnectorConfig.resolveSnapshotMaxThreads(config);
        this.cursorMaxAwaitTimeMs = config.getInteger(CURSOR_MAX_AWAIT_TIME_MS, 0);
        this.replicaSets = MongoDbConnectorConfig.resolveReplicaSets(config);
    }

    private static int validateHosts(Configuration config, Field field, Field.ValidationOutput problems) {
        String hosts = config.getString(field);
        String connectionString = config.getString(CONNECTION_STRING);
        if (hosts == null) {
            return 0;
        }
        LOGGER.warn("Config property '{}' will be removed in the future, use '{}' instead", (Object)field.name(), (Object)CONNECTION_STRING.name());
        if (connectionString != null) {
            LOGGER.warn("Config property '{}' is ignored, property '{}' takes precedence", (Object)field.name(), (Object)CONNECTION_STRING.name());
            return 0;
        }
        if (ConnectionStrings.parseFromHosts(hosts).isEmpty()) {
            problems.accept(field, null, "Invalid host specification");
            return 1;
        }
        return 0;
    }

    private static int validateChangeStreamPipeline(Configuration config, Field field, Field.ValidationOutput problems) {
        String value = config.getString(field);
        try {
            new ChangeStreamPipeline(value);
        }
        catch (Exception e) {
            problems.accept(field, (Object)value, "Change stream pipeline JSON is invalid: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    private static int validateOversizeSkipThreshold(Configuration config, Field field, Field.ValidationOutput problems) {
        String mode = config.getString(CURSOR_OVERSIZE_HANDLING_MODE);
        int value = config.getInteger(CURSOR_OVERSIZE_SKIP_THRESHOLD);
        if (OversizeHandlingMode.SKIP.getValue().equals(mode) && value <= 0) {
            problems.accept(field, (Object)value, "Invalid threshold value for skipped document size");
            return 1;
        }
        return 0;
    }

    private static int validateConnectionString(Configuration config, Field field, Field.ValidationOutput problems) {
        String connectionStringValue = config.getString(field);
        if (connectionStringValue == null) {
            problems.accept(field, null, "Missing connection string");
            return 1;
        }
        try {
            ConnectionString connectionString = new ConnectionString(connectionStringValue);
        }
        catch (Exception e) {
            problems.accept(field, (Object)connectionStringValue, "Invalid connection string");
            return 1;
        }
        return 0;
    }

    private static int validateFieldExcludeList(Configuration config, Field field, Field.ValidationOutput problems) {
        int problemCount = 0;
        String fieldExcludeList = config.getString(FIELD_EXCLUDE_LIST);
        if (fieldExcludeList != null) {
            for (String excludeField : PATTERN_SPILT.split(fieldExcludeList)) {
                if (FIELD_EXCLUDE_LIST_PATTERN.asPredicate().test(excludeField)) continue;
                problems.accept(FIELD_EXCLUDE_LIST, (Object)excludeField, excludeField + " has invalid format (expecting <databaseName>.<collectionName>.<fieldName>.<nestedFieldName>)");
                ++problemCount;
            }
        }
        return problemCount;
    }

    private static int validateFieldRenamesList(Configuration config, Field field, Field.ValidationOutput problems) {
        int problemCount = 0;
        String fieldRenamesList = config.getString(FIELD_RENAMES);
        if (fieldRenamesList != null) {
            for (String renameField : PATTERN_SPILT.split(fieldRenamesList)) {
                if (FIELD_RENAMES_PATTERN.asPredicate().test(renameField)) continue;
                problems.accept(FIELD_EXCLUDE_LIST, (Object)renameField, renameField + " has invalid format (expecting <databaseName>.<collectionName>.<fieldName>.<nestedFieldName>:<newNestedFieldName>)");
                ++problemCount;
            }
        }
        return problemCount;
    }

    private static int validateListOfRegexesOrLiterals(Configuration configuration, Field field, Field.ValidationOutput problems) {
        String matchMode = configuration.getString(FILTERS_MATCH_MODE);
        if (matchMode != null && matchMode.equals(FiltersMatchMode.REGEX.getValue())) {
            return Field.isListOfRegex((Configuration)configuration, (Field)field, (Field.ValidationOutput)problems);
        }
        String value = configuration.getString(field);
        List list = Strings.listOf((String)value, v -> v.split(","), String::trim);
        if (list.stream().anyMatch(String::isEmpty)) {
            problems.accept(field, (Object)value, field.name() + " contains empty values");
            return 1;
        }
        return 0;
    }

    private static int validateCollectionExcludeList(Configuration config, Field field, Field.ValidationOutput problems) {
        String includeList = config.getString(COLLECTION_INCLUDE_LIST);
        String excludeList = config.getString(COLLECTION_EXCLUDE_LIST);
        if (includeList != null && excludeList != null) {
            problems.accept(COLLECTION_EXCLUDE_LIST, (Object)excludeList, COLLECTION_INCLUDE_LIST_ALREADY_SPECIFIED_ERROR_MSG);
            return 1;
        }
        return 0;
    }

    private static int validateDatabaseExcludeList(Configuration config, Field field, Field.ValidationOutput problems) {
        String includeList = config.getString(DATABASE_INCLUDE_LIST);
        String excludeList = config.getString(DATABASE_EXCLUDE_LIST);
        if (includeList != null && excludeList != null) {
            problems.accept(DATABASE_EXCLUDE_LIST, (Object)excludeList, DATABASE_INCLUDE_LIST_ALREADY_SPECIFIED_ERROR_MSG);
            return 1;
        }
        return 0;
    }

    private static int validateCaptureTarget(Configuration config, Field field, Field.ValidationOutput problems) {
        String value = config.getString(field);
        String scope = config.getString(CAPTURE_SCOPE);
        if (value != null && CaptureScope.DEPLOYMENT.value.equals(scope)) {
            LOGGER.warn("Config property '{}' will be ignored due to {}={}", new Object[]{field.name(), CAPTURE_SCOPE.name(), scope});
        }
        if (value == null) {
            problems.accept(field, null, field.name() + "property is missing");
            return 1;
        }
        return 0;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    public CaptureMode getCaptureMode() {
        return this.captureMode;
    }

    public CaptureScope getCaptureScope() {
        return this.captureScope;
    }

    public Optional<String> getCaptureTarget() {
        return Optional.ofNullable(this.captureTarget);
    }

    public ConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public boolean isOffsetInvalidationAllowed() {
        return this.offsetInvalidationAllowed;
    }

    public String getShardConnectionParameters() {
        return this.shardConnectionParameters;
    }

    public ReplicaSets getReplicaSets() {
        return this.replicaSets;
    }

    public int getCursorMaxAwaitTime() {
        return this.cursorMaxAwaitTimeMs;
    }

    public CursorPipelineOrder getCursorPipelineOrder() {
        return this.cursorPipelineOrder;
    }

    public OversizeHandlingMode getOversizeHandlingMode() {
        return this.oversizeHandlingMode;
    }

    public int getOversizeSkipThreshold() {
        return this.oversizeSkipThreshold;
    }

    public FiltersMatchMode getFiltersMatchMode() {
        return this.filtersMatchMode;
    }

    public int getSnapshotMaxThreads() {
        return this.snapshotMaxThreads;
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return this.getSourceInfoStructMaker(SOURCE_INFO_STRUCT_MAKER, Module.name(), Module.version(), this);
    }

    public Optional<String> getSnapshotFilterQueryForCollection(CollectionId collectionId) {
        return Optional.ofNullable(this.getSnapshotFilterQueryByCollection().get(collectionId.dbName() + "." + collectionId.name()));
    }

    public Map<String, String> getSnapshotFilterQueryByCollection() {
        String collectionList = this.getConfig().getString(SNAPSHOT_FILTER_QUERY_BY_COLLECTION);
        if (collectionList == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> snapshotFilterQueryByCollection = new HashMap<String, String>();
        for (String collection : collectionList.split(",")) {
            snapshotFilterQueryByCollection.put(collection, this.getConfig().getString(SNAPSHOT_FILTER_QUERY_BY_COLLECTION + "." + collection));
        }
        return Collections.unmodifiableMap(snapshotFilterQueryByCollection);
    }

    public boolean supportsOperationFiltering() {
        return true;
    }

    public String getContextName() {
        return Module.contextName();
    }

    public String getConnectorName() {
        return Module.name();
    }

    private static int resolveSnapshotMaxThreads(Configuration config) {
        return config.getInteger(SNAPSHOT_MAX_THREADS);
    }

    private static ReplicaSets resolveReplicaSets(Configuration config) {
        if (!config.hasKey(TASK_CONNECTION_STRINGS)) {
            return new ReplicaSets(List.of());
        }
        List replicaSetSpecs = config.getList(TASK_CONNECTION_STRINGS, "|", ReplicaSet::new);
        return new ReplicaSets(replicaSetSpecs);
    }

    public Optional<String[]> parseSignallingMessage(Struct value) {
        String after = value.getString("after");
        if (after == null) {
            LOGGER.warn("After part of signal '{}' is missing", (Object)value);
            return Optional.empty();
        }
        Document fields = Document.parse((String)after);
        if (fields.size() != 3) {
            LOGGER.warn("The signal event '{}' should have 3 fields but has {}", (Object)after, (Object)fields.size());
            return Optional.empty();
        }
        String[] result = new String[3];
        int idx = 0;
        for (Object fieldValue : fields.values()) {
            if (fieldValue instanceof Document) {
                result[idx++] = ((Document)fieldValue).toJson();
                continue;
            }
            result[idx++] = fieldValue.toString();
        }
        return Optional.of(result);
    }

    public boolean isSignalDataCollection(DataCollectionId dataCollectionId) {
        CollectionId id = (CollectionId)dataCollectionId;
        return this.getSignalingDataCollectionId() != null && this.getSignalingDataCollectionId().equals(id.dbName() + "." + id.name());
    }

    static {
        EXPOSED_FIELDS = ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        INITIAL("initial", true),
        NEVER("never", false);

        private final String value;
        private final boolean includeData;

        private SnapshotMode(String value, boolean includeData) {
            this.value = value;
            this.includeData = includeData;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum CaptureMode implements EnumeratedValue
    {
        CHANGE_STREAMS("change_streams", true, false, false),
        CHANGE_STREAMS_UPDATE_FULL("change_streams_update_full", true, true, false),
        CHANGE_STREAMS_WITH_PRE_IMAGE("change_streams_with_pre_image", true, false, true),
        CHANGE_STREAMS_UPDATE_FULL_WITH_PRE_IMAGE("change_streams_update_full_with_pre_image", true, true, true);

        private final String value;
        private final boolean changeStreams;
        private final boolean fullUpdate;
        private final boolean includePreImage;

        private CaptureMode(String value, boolean changeStreams, boolean fullUpdate, boolean includePreImage) {
            this.value = value;
            this.changeStreams = changeStreams;
            this.fullUpdate = fullUpdate;
            this.includePreImage = includePreImage;
        }

        public String getValue() {
            return this.value;
        }

        public static CaptureMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (CaptureMode option : CaptureMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static CaptureMode parse(String value, String defaultValue) {
            CaptureMode mode = CaptureMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = CaptureMode.parse(defaultValue);
            }
            return mode;
        }

        public boolean isFullUpdate() {
            return this.fullUpdate;
        }

        public boolean isIncludePreImage() {
            return this.includePreImage;
        }
    }

    public static enum ConnectionMode implements EnumeratedValue
    {
        REPLICA_SET("replica_set"),
        SHARDED("sharded");

        private String value;

        private ConnectionMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ConnectionMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (ConnectionMode option : ConnectionMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static ConnectionMode parse(String value, String defaultValue) {
            ConnectionMode mode = ConnectionMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = ConnectionMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum CaptureScope implements EnumeratedValue
    {
        DEPLOYMENT("deployment"),
        DATABASE("database");

        private final String value;

        private CaptureScope(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static CaptureScope parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (CaptureScope option : CaptureScope.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static CaptureScope parse(String value, String defaultValue) {
            CaptureScope mode = CaptureScope.parse(value);
            if (mode == null && defaultValue != null) {
                mode = CaptureScope.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum CursorPipelineOrder implements EnumeratedValue
    {
        INTERNAL_FIRST("internal_first"),
        USER_FIRST("user_first"),
        USER_ONLY("user_only");

        private String value;

        private CursorPipelineOrder(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static CursorPipelineOrder parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (CursorPipelineOrder option : CursorPipelineOrder.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static CursorPipelineOrder parse(String value, String defaultValue) {
            CursorPipelineOrder mode = CursorPipelineOrder.parse(value);
            if (mode == null && defaultValue != null) {
                mode = CursorPipelineOrder.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum OversizeHandlingMode implements EnumeratedValue
    {
        FAIL("fail"),
        SKIP("skip"),
        SPLIT("split");

        private String value;

        private OversizeHandlingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static OversizeHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (OversizeHandlingMode option : OversizeHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static OversizeHandlingMode parse(String value, String defaultValue) {
            OversizeHandlingMode mode = OversizeHandlingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = OversizeHandlingMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum FiltersMatchMode implements EnumeratedValue
    {
        REGEX("regex"),
        LITERAL("literal");

        private String value;

        private FiltersMatchMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static FiltersMatchMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (FiltersMatchMode option : FiltersMatchMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static FiltersMatchMode parse(String value, String defaultValue) {
            FiltersMatchMode mode = FiltersMatchMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = FiltersMatchMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

