/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.ConnectionString;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.connector.mongodb.connection.ConnectionStrings;
import io.debezium.connector.mongodb.connection.ReplicaSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ReplicaSetsTest {
    @Test
    public void shouldHaveNoReplicaSetsInEmptyInstance() {
        Assertions.assertThat((int)ReplicaSets.empty().size()).isEqualTo(0);
    }

    @Test
    public void shouldParseNullHostString() {
        Assertions.assertThat((Optional)ConnectionStrings.parseFromHosts(null)).isEmpty();
    }

    @Test
    public void shouldParseEmptyHostString() {
        Assertions.assertThat((Optional)ConnectionStrings.parseFromHosts((String)"")).isEmpty();
    }

    @Test
    public void shouldParseBlankHostString() {
        Assertions.assertThat((Optional)ConnectionStrings.parseFromHosts((String)"")).isEmpty();
    }

    @Test
    public void shouldParseSingleHostStringWithStandaloneAddress() {
        Optional cs = ConnectionStrings.parseFromHosts((String)"localhost:27017");
        Assertions.assertThat((Optional)cs).hasValue((Object)"mongodb://localhost:27017/");
    }

    @Test
    public void shouldParseHostStringWithStandaloneAddresses() {
        String hosts = "localhost:27017,1.2.3.4:27017,localhost:28017,[fe80::601:9bff:feab:ec01]:27017";
        Optional cs = ConnectionStrings.parseFromHosts((String)hosts);
        Assertions.assertThat((Optional)cs).hasValue((Object)("mongodb://" + hosts + "/"));
    }

    @Test
    public void shouldParseHostStringWithAddressAndReplicaSet() {
        Optional cs = ConnectionStrings.parseFromHosts((String)"myReplicaSet/localhost:27017");
        Assertions.assertThat((Optional)cs).hasValue((Object)"mongodb://localhost:27017/?replicaSet=myReplicaSet");
    }

    @Test
    public void shouldParseHostStringWithIpv6AddressAndReplicaSet() {
        Optional cs = ConnectionStrings.parseFromHosts((String)"myReplicaSet/[fe80::601:9bff:feab:ec01]:27017");
        Assertions.assertThat((Optional)cs).hasValue((Object)"mongodb://[fe80::601:9bff:feab:ec01]:27017/?replicaSet=myReplicaSet");
    }

    @Test
    public void shouldParseHostStringWithAddressesAndReplicaSet() {
        String hosts = "localhost:27017,1.2.3.4:27017,localhost:28017,[fe80::601:9bff:feab:ec01]:27017";
        Optional cs = ConnectionStrings.parseFromHosts((String)("myReplicaSet/" + hosts));
        Assertions.assertThat((Optional)cs).hasValue((Object)("mongodb://" + hosts + "/?replicaSet=myReplicaSet"));
    }

    @Test
    public void shouldHaveAttributesFromConnectionString() {
        ConnectionString cs = new ConnectionString("mongodb://localhost:27017/?replicaSet=rs0");
        ReplicaSet rs = new ReplicaSet(cs);
        Assertions.assertThat((boolean)rs.hasReplicaSetName()).isTrue();
        Assertions.assertThat((String)rs.replicaSetName()).isEqualTo((Object)"rs0");
        Assertions.assertThat((Object)rs.connectionString()).isEqualTo((Object)cs);
    }

    @Test
    public void shouldConsiderUnchangedSameInstance() {
        ReplicaSet rs = new ReplicaSet("mongodb://localhost:27017/?replicaSet=rs0");
        ReplicaSets sets = ReplicaSets.of((ReplicaSet[])new ReplicaSet[]{rs});
        Assertions.assertThat((boolean)sets.haveChangedSince(sets)).isFalse();
    }

    @Test
    public void shouldConsiderUnchangedSameReplicaSets() {
        ReplicaSet rs0 = new ReplicaSet("mongodb://localhost:27017/?replicaSet=rs0");
        ReplicaSet rs1 = new ReplicaSet("mongodb://localhost:27017/?replicaSet=rs0");
        ReplicaSets sets0 = ReplicaSets.of((ReplicaSet[])new ReplicaSet[]{rs0});
        ReplicaSets sets1 = ReplicaSets.of((ReplicaSet[])new ReplicaSet[]{rs1});
        Assertions.assertThat((boolean)sets0.haveChangedSince(sets1)).isFalse();
    }

    @Test
    public void shouldConsiderUnchangedSameReplicaSetsWithDifferentAddresses() {
        ReplicaSet rs0 = new ReplicaSet("mongodb://1.2.3.4:27017,localhost:28017/?replicaSet=rs0");
        ReplicaSet rs1 = new ReplicaSet("mongodb://localhost:27017/?replicaSet=rs0");
        ReplicaSet rs2 = new ReplicaSet("mongodb://localhost:28017/?replicaSet=rs2");
        ReplicaSets sets0 = ReplicaSets.of((ReplicaSet[])new ReplicaSet[]{rs0, rs2});
        ReplicaSets sets1 = ReplicaSets.of((ReplicaSet[])new ReplicaSet[]{rs1, rs2});
        Assertions.assertThat((boolean)sets0.haveChangedSince(sets1)).isFalse();
    }

    @Test
    public void shouldConsiderChangedDifferentReplicaSetsWithSameAddresses() {
        ReplicaSet rs0 = new ReplicaSet("mongodb://localhost:27017/?replicaSet=rs0");
        ReplicaSet rs1 = new ReplicaSet("mongodb://localhost:27017/?replicaSet=rs1");
        ReplicaSets sets0 = ReplicaSets.of((ReplicaSet[])new ReplicaSet[]{rs0});
        ReplicaSets sets1 = ReplicaSets.of((ReplicaSet[])new ReplicaSet[]{rs1});
        Assertions.assertThat((boolean)sets0.haveChangedSince(sets1)).isTrue();
    }

    @Test
    public void shouldConsiderChangedReplicaSetsWithAdditionalReplicaSet() {
        ReplicaSet rs0 = new ReplicaSet("mongodb://localhost:27017/?replicaSet=rs0");
        ReplicaSet rs1 = new ReplicaSet("mongodb://localhost:27017/?replicaSet=rs0");
        ReplicaSets sets0 = ReplicaSets.of((ReplicaSet[])new ReplicaSet[]{rs0});
        ReplicaSets sets1 = ReplicaSets.of((ReplicaSet[])new ReplicaSet[]{rs0, rs1});
        Assertions.assertThat((boolean)sets1.haveChangedSince(sets0)).isTrue();
    }

    @Test
    public void shouldConsiderChangedReplicaSetsWithRemovedReplicaSet() {
        ReplicaSet rs0 = new ReplicaSet("mongodb://localhost:27017/?replicaSet=rs0");
        ReplicaSet rs1 = new ReplicaSet("mongodb://localhost:27017/?replicaSet=rs0");
        ReplicaSets sets0 = ReplicaSets.of((ReplicaSet[])new ReplicaSet[]{rs0, rs1});
        ReplicaSets sets1 = ReplicaSets.of((ReplicaSet[])new ReplicaSet[]{rs0});
        Assertions.assertThat((boolean)sets1.haveChangedSince(sets0)).isTrue();
    }

    @Test
    public void shouldNotSubdivideOneReplicaSet() {
        ReplicaSet rs0 = new ReplicaSet("mongodb://host0:27017,host1:27017/?replicaSet=rs0");
        ReplicaSets sets = ReplicaSets.of((ReplicaSet[])new ReplicaSet[]{rs0});
        ArrayList divided = new ArrayList();
        sets.subdivide(1, divided::add);
        Assertions.assertThat((int)divided.size()).isEqualTo(1);
        Assertions.assertThat((Object)((ReplicaSets)divided.get(0))).isEqualTo((Object)sets);
    }

    @Test
    public void shouldNotSubdivideMultipleReplicaSetsIntoOneGroup() {
        ReplicaSet rs0 = new ReplicaSet("mongodb://host0:27017,host1:27017/?replicaSet=rs0");
        ReplicaSet rs1 = new ReplicaSet("mongodb://host2:27017/?replicaSet=rs01");
        ReplicaSets sets = ReplicaSets.of((ReplicaSet[])new ReplicaSet[]{rs0});
        ArrayList divided = new ArrayList();
        sets.subdivide(1, divided::add);
        Assertions.assertThat((int)divided.size()).isEqualTo(1);
        Assertions.assertThat((Object)((ReplicaSets)divided.get(0))).isEqualTo((Object)sets);
    }

    @Test
    public void shouldSubdivideMultipleReplicaSetsWithIntoMultipleGroups() {
        ReplicaSet rs0 = new ReplicaSet("mongodb://host0:27017,host1:27017/?replicaSet=rs0");
        ReplicaSet rs1 = new ReplicaSet("mongodb://host2:27017/?replicaSet=rs01");
        ReplicaSets sets = ReplicaSets.of((ReplicaSet[])new ReplicaSet[]{rs0, rs1});
        ArrayList divided = new ArrayList();
        sets.subdivide(2, divided::add);
        Assertions.assertThat((int)divided.size()).isEqualTo(2);
        Assertions.assertThat((List)((ReplicaSets)divided.get(0)).all()).containsExactly((Object[])new ReplicaSet[]{(ReplicaSet)sets.all().get(0)});
        Assertions.assertThat((List)((ReplicaSets)divided.get(1)).all()).containsExactly((Object[])new ReplicaSet[]{(ReplicaSet)sets.all().get(1)});
    }
}

