/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.util.Testing;

public class Configurator {
    private Configuration.Builder configBuilder = Configuration.create();

    public Configurator with(Field field, String value) {
        this.configBuilder.with(field, value);
        return this;
    }

    public Configurator with(Field field, boolean value) {
        this.configBuilder.with(field, value);
        return this;
    }

    public Configurator with(Field field, int value) {
        this.configBuilder.with(field, value);
        return this;
    }

    public Configurator serverName(String serverName) {
        return this.with(CommonConnectorConfig.TOPIC_PREFIX, serverName);
    }

    public Configurator maxBatchSize(int maxBatchSize) {
        return this.with(MongoDbConnectorConfig.MAX_BATCH_SIZE, maxBatchSize);
    }

    public Configurator useLiteralFilters() {
        Testing.debug((Object)("Using \"" + MongoDbConnectorConfig.FILTERS_MATCH_MODE.name() + "\" config property"));
        return this.with(MongoDbConnectorConfig.FILTERS_MATCH_MODE, MongoDbConnectorConfig.FiltersMatchMode.LITERAL.getValue());
    }

    public Configurator includeDatabases(String regexList) {
        Testing.debug((Object)("Using \"" + MongoDbConnectorConfig.DATABASE_INCLUDE_LIST.name() + "\" config property"));
        return this.with(MongoDbConnectorConfig.DATABASE_INCLUDE_LIST, regexList);
    }

    public Configurator excludeDatabases(String regexList) {
        Testing.debug((Object)("Using \"" + MongoDbConnectorConfig.DATABASE_EXCLUDE_LIST.name() + "\" config property"));
        return this.with(MongoDbConnectorConfig.DATABASE_EXCLUDE_LIST, regexList);
    }

    public Configurator includeCollections(String regexList) {
        Testing.debug((Object)("Using \"" + MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST.name() + "\" config property"));
        return this.with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, regexList);
    }

    public Configurator excludeCollections(String regexList) {
        Testing.debug((Object)("Using \"" + MongoDbConnectorConfig.COLLECTION_EXCLUDE_LIST.name() + "\" config property"));
        return this.with(MongoDbConnectorConfig.COLLECTION_EXCLUDE_LIST, regexList);
    }

    public Configurator excludeFields(String excludeList) {
        Testing.debug((Object)("Using \"" + MongoDbConnectorConfig.FIELD_EXCLUDE_LIST.name() + "\" config property"));
        return this.with(MongoDbConnectorConfig.FIELD_EXCLUDE_LIST, excludeList);
    }

    public Configurator renameFields(String renames) {
        return this.with(MongoDbConnectorConfig.FIELD_RENAMES, renames);
    }

    public Configurator signalingCollection(String signalingCollection) {
        return this.with(MongoDbConnectorConfig.SIGNAL_DATA_COLLECTION, signalingCollection);
    }

    public Filters createFilters() {
        return new Filters(this.configBuilder.build());
    }

    public Configuration config() {
        return this.configBuilder.build();
    }
}

