/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.connector.mongodb.connection.MongoDbConnection;
import io.debezium.connector.mongodb.connection.ReplicaSet;
import io.debezium.connector.mongodb.junit.MongoDbDatabaseProvider;
import io.debezium.testing.testcontainers.MongoDbDeployment;
import io.debezium.testing.testcontainers.util.DockerUtils;
import io.debezium.util.Testing;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMongoIT {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractMongoIT.class);
    protected static MongoDbDeployment mongo;
    protected Configuration config;
    protected MongoDbTaskContext context;
    protected ReplicaSet replicaSet;
    protected MongoDbConnection connection;

    @BeforeClass
    public static void beforeAll() {
        DockerUtils.enableFakeDnsIfRequired();
        mongo = MongoDbDatabaseProvider.externalOrDockerReplicaSet();
        mongo.start();
    }

    @AfterClass
    public static void afterAll() {
        DockerUtils.disableFakeDns();
        if (mongo != null) {
            mongo.stop();
        }
    }

    protected MongoClient connect() {
        return MongoClients.create((String)mongo.getConnectionString());
    }

    @Before
    public void beforeEach() {
        Testing.Print.disable();
        Testing.Debug.disable();
        this.useConfiguration(TestHelper.getConfiguration(mongo));
    }

    protected void useConfiguration(Configuration config) {
        this.config = config;
        this.initialize(true);
    }

    protected void reuseConfiguration(Configuration config) {
        this.config = config;
        this.initialize(false);
    }

    private void initialize(boolean restartFromBeginning) {
        Map partition = null;
        Map offsetForPartition = null;
        if (!restartFromBeginning && this.context != null && this.replicaSet != null && this.context.source().hasOffset(this.replicaSet.replicaSetName())) {
            partition = this.context.source().partition(this.replicaSet.replicaSetName());
            offsetForPartition = this.context.source().lastOffset(this.replicaSet.replicaSetName());
        }
        this.context = new MongoDbTaskContext(this.config);
        Assertions.assertThat((String)this.context.getConnectionContext().connectionSeed()).isNotEmpty();
        this.replicaSet = TestHelper.replicaSet(mongo);
        this.context.configureLoggingContext(this.replicaSet.replicaSetName());
        if (partition != null) {
            this.context.source().setOffsetFor(partition, offsetForPartition);
        }
        this.connection = this.context.getConnectionContext().connect(this.replicaSet, this.context.filters(), TestHelper.connectionErrorHandler(3));
    }
}

