/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.metrics;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.mongodb.DisconnectEvent;
import io.debezium.connector.mongodb.MongoDbPartition;
import io.debezium.connector.mongodb.PrimaryElectionEvent;
import io.debezium.connector.mongodb.metrics.MongoDbStreamingChangeEventSourceMetricsMBean;
import io.debezium.pipeline.ConnectorEvent;
import io.debezium.pipeline.metrics.DefaultStreamingChangeEventSourceMetrics;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.util.Clock;
import io.debezium.util.Collect;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafe
public class MongoDbStreamingChangeEventSourceMetrics
extends DefaultStreamingChangeEventSourceMetrics<MongoDbPartition>
implements MongoDbStreamingChangeEventSourceMetricsMBean {
    private final AtomicLong numberOfPrimaryElections = new AtomicLong();
    private final AtomicLong numberOfDisconnects = new AtomicLong();
    private final AtomicLong lastSourceEventPollTime = new AtomicLong();
    private final AtomicLong lastEmptyPollTime = new AtomicLong();
    private final AtomicLong numberOfSourceEvents = new AtomicLong();
    private final AtomicLong numberOfEmptyPolls = new AtomicLong();

    public <T extends CdcSourceTaskContext> MongoDbStreamingChangeEventSourceMetrics(T taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider eventMetadataProvider) {
        super(taskContext, changeEventQueueMetrics, eventMetadataProvider, Collect.linkMapOf((Object)"context", (Object)"streaming", (Object)"server", (Object)taskContext.getConnectorName(), (Object)"task", (Object)taskContext.getTaskId()));
    }

    @Override
    public long getNumberOfPrimaryElections() {
        return this.numberOfPrimaryElections.get();
    }

    @Override
    public long getNumberOfDisconnects() {
        return this.numberOfDisconnects.get();
    }

    @Override
    public long getLastSourceEventPollTime() {
        return this.lastSourceEventPollTime.get();
    }

    @Override
    public long getLastEmptyPollTime() {
        return this.lastEmptyPollTime.get();
    }

    @Override
    public long getNumberOfEmptyPolls() {
        return this.numberOfEmptyPolls.get();
    }

    public void onSourceEventPolled(ChangeStreamDocument<?> event, Clock clock, Instant prePollTimestamp) {
        Instant now = clock.currentTimeAsInstant();
        long duration = Duration.between(prePollTimestamp, now).toMillis();
        if (event == null) {
            this.lastEmptyPollTime.set(duration);
            this.numberOfEmptyPolls.incrementAndGet();
        } else {
            this.lastSourceEventPollTime.set(duration);
        }
    }

    public void onConnectorEvent(MongoDbPartition partition, ConnectorEvent event) {
        if (event instanceof PrimaryElectionEvent) {
            this.numberOfPrimaryElections.incrementAndGet();
        } else if (event instanceof DisconnectEvent) {
            this.numberOfDisconnects.incrementAndGet();
        }
    }

    public void reset() {
        super.reset();
        this.numberOfPrimaryElections.set(0L);
        this.numberOfDisconnects.set(0L);
    }
}

