/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.connection;

import com.mongodb.ConnectionString;
import io.debezium.annotation.Immutable;
import java.util.Objects;

@Immutable
public final class ReplicaSet
implements Comparable<ReplicaSet> {
    public static final String CLUSTER_RS_NAME = "cluster";
    private final String replicaSetName;
    private final ConnectionString connectionString;
    private final int hc;

    public ReplicaSet(String connectionString) {
        this(new ConnectionString(connectionString));
    }

    public ReplicaSet(ConnectionString connectionString) {
        this(connectionString.getRequiredReplicaSetName(), connectionString);
    }

    private ReplicaSet(String replicaSetName, ConnectionString connectionString) {
        this.connectionString = Objects.requireNonNull(connectionString, "Connection string cannot be null");
        this.replicaSetName = Objects.requireNonNullElse(replicaSetName, CLUSTER_RS_NAME);
        this.hc = Objects.hash(connectionString);
    }

    public String replicaSetName() {
        return this.replicaSetName;
    }

    public ConnectionString connectionString() {
        return this.connectionString;
    }

    public boolean hasReplicaSetName() {
        return this.replicaSetName != null;
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ReplicaSet) {
            ReplicaSet that = (ReplicaSet)obj;
            return Objects.equals(this.replicaSetName, that.replicaSetName);
        }
        return false;
    }

    @Override
    public int compareTo(ReplicaSet that) {
        if (that == this) {
            return 0;
        }
        return this.replicaSetName.compareTo(that.replicaSetName);
    }

    public String toString() {
        return this.replicaSetName;
    }
}

