/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.rest;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.connection.MongoDbConnection;
import io.debezium.connector.mongodb.connection.ReplicaSet;
import io.debezium.rest.ConnectionValidationResource;
import io.debezium.rest.FilterValidationResource;
import io.debezium.rest.SchemaResource;
import io.debezium.rest.model.DataCollection;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.kafka.connect.connector.Connector;

@Path(value="/debezium/mongodb")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DebeziumMongoDbConnectorResource
implements SchemaResource,
ConnectionValidationResource,
FilterValidationResource {
    public static final String BASE_PATH = "/debezium/mongodb";
    public static final String VERSION_ENDPOINT = "/version";

    @GET
    @Path(value="/version")
    public String getConnectorVersion() {
        return Module.version();
    }

    public Connector getConnector() {
        return new MongoDbConnector();
    }

    protected MongoDbConnection getConnection(Configuration configuration) {
        MongoDbTaskContext context = new MongoDbTaskContext(configuration);
        ReplicaSet replicaSet = new ReplicaSet(context.getConnectionContext().connectionString());
        return context.getConnectionContext().connect(replicaSet, context.filters(), (s, throwable) -> {
            throw new DebeziumException(s, throwable);
        });
    }

    public List<DataCollection> getMatchingCollections(Configuration configuration) {
        MongoDbConnection connection = this.getConnection(configuration);
        try {
            List<DataCollection> list = connection.collections().stream().map(collectionId -> new DataCollection(collectionId.replicaSetName(), collectionId.dbName(), collectionId.name())).collect(Collectors.toList());
            if (connection != null) {
                connection.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new DebeziumException((Throwable)e);
            }
        }
    }

    public String getSchemaFilePath() {
        return "/META-INF/resources/mongodb.json";
    }
}

