/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.connector.mongodb.ChangeStreamPipeline;
import io.debezium.connector.mongodb.ChangeStreamPipelineFactory;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.data.Envelope;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.bson.conversions.Bson;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ChangeStreamPipelineFactoryTest {
    private static final List<String> SIZE_PIPELINE = List.of("{\n   \"$match\": {\n       \"$and\": [ {\n           \"$expr\": {\n \"$lte\": [{\"$bsonSize\": \"$fullDocument\"}, 42]}\n       }, {\n           \"$expr\": { \"$lte\": [{\"$bsonSize\": \"$fullDocumentBeforeChange\"}, 42]}}   ] }\n}");
    private static final List<String> INTERNAL_PIPELINE = List.of("{\n  \"$replaceRoot\" : {\n    \"newRoot\" : {\n      \"event\" : \"$$ROOT\",\n      \"namespace\" : {\n        \"$concat\" : [ \"$ns.db\", \".\", \"$ns.coll\" ]\n      }\n    }\n  }\n}", "{\n  \"$match\" : {\n    \"$and\" : [ {\n      \"namespace\" : {\n        \"$regularExpression\" : {\n          \"pattern\" : \"dbit.*\",\n          \"options\" : \"i\"\n        }\n      }\n    }, {\n      \"event.operationType\" : {\n        \"$in\" : [ \"insert\", \"update\", \"replace\", \"delete\" ]\n      }\n    } ]\n  }\n}", "{\n  \"$replaceRoot\" : {\n    \"newRoot\" : \"$event\"\n  }\n}");
    private static final List<String> INTERNAL_PIPELINE_LITERALS = List.of("{\n  \"$match\": {\n    \"$and\": [{\n        \"$or\": [\n          { \"ns\": { \"$in\": [ { \"db\": \"dbit\", \"coll\": \"col1\" }, { \"db\": \"dbit\", \"coll\": \"col2\" } ] } },\n          { \"ns\": { \"db\": \"signal\", \"coll\": \"col\" } }\n        ]\n      }, {\n        \"operationType\": {\n          \"$in\": [\"insert\", \"update\", \"replace\", \"delete\" ]\n        }\n      }]\n  }\n}");
    private static final List<String> USER_PIPELINE = List.of("{\n  \"$match\" : {\n    \"$and\" : [ {\n      \"operationType\" : \"insert\"\n    }, {\n      \"fullDocument.eventId\" : 1404\n    } ]\n  }\n}");
    @InjectMocks
    private ChangeStreamPipelineFactory sut;
    @Mock
    private MongoDbConnectorConfig connectorConfig;
    @Mock
    private Filters.FilterConfig filterConfig;

    @Test
    public void testCreateWithInternalFirstAndOversizeHandlingFail() {
        this.testCreate(MongoDbConnectorConfig.CursorPipelineOrder.INTERNAL_FIRST, this.mergeStages(INTERNAL_PIPELINE, USER_PIPELINE));
        this.testCreateLiterals(MongoDbConnectorConfig.CursorPipelineOrder.INTERNAL_FIRST, this.mergeStages(INTERNAL_PIPELINE_LITERALS, USER_PIPELINE));
    }

    @Test
    public void testCreateWithUserFirstAndOversizeHandlingFail() {
        this.testCreate(MongoDbConnectorConfig.CursorPipelineOrder.USER_FIRST, this.mergeStages(USER_PIPELINE, INTERNAL_PIPELINE));
        this.testCreateLiterals(MongoDbConnectorConfig.CursorPipelineOrder.USER_FIRST, this.mergeStages(USER_PIPELINE, INTERNAL_PIPELINE_LITERALS));
    }

    @Test
    public void testCreateWithInternalFirstAndOversizeHandlingSkip() {
        this.testCreateWithSkipOversized(MongoDbConnectorConfig.CursorPipelineOrder.INTERNAL_FIRST, this.mergeStages(INTERNAL_PIPELINE, USER_PIPELINE));
        this.testCreateLiteralsWithSkipOversized(MongoDbConnectorConfig.CursorPipelineOrder.INTERNAL_FIRST, this.mergeStages(INTERNAL_PIPELINE_LITERALS, USER_PIPELINE));
    }

    @Test
    public void testCreateWithUserFirstAndOversizeHandlingSkip() {
        this.testCreateWithSkipOversized(MongoDbConnectorConfig.CursorPipelineOrder.USER_FIRST, this.mergeStages(USER_PIPELINE, INTERNAL_PIPELINE));
        this.testCreateLiteralsWithSkipOversized(MongoDbConnectorConfig.CursorPipelineOrder.USER_FIRST, this.mergeStages(USER_PIPELINE, INTERNAL_PIPELINE_LITERALS));
    }

    @Test
    public void testCreateWithUserOnly() {
        BDDMockito.given((Object)this.connectorConfig.getCursorPipelineOrder()).willReturn((Object)MongoDbConnectorConfig.CursorPipelineOrder.USER_ONLY);
        BDDMockito.given((Object)this.connectorConfig.getSkippedOperations()).willReturn(EnumSet.of(Envelope.Operation.TRUNCATE));
        BDDMockito.given((Object)this.filterConfig.getCollectionIncludeList()).willReturn(Optional.of("dbit.*"));
        BDDMockito.given((Object)this.filterConfig.getUserPipeline()).willReturn((Object)new ChangeStreamPipeline(this.asJsonArray(USER_PIPELINE)));
        ChangeStreamPipeline pipeline = this.sut.create();
        ChangeStreamPipelineFactoryTest.assertPipelineStagesEquals(pipeline.getStages(), USER_PIPELINE);
    }

    @SafeVarargs
    private List<String> mergeStages(List<String> ... stages) {
        return Stream.of(stages).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private String asJsonArray(List<String> stages) {
        return stages.stream().collect(Collectors.joining(",", "[", "]"));
    }

    public void testCreate(MongoDbConnectorConfig.CursorPipelineOrder pipelineOrder, List<String> expectedStageJsons) {
        BDDMockito.given((Object)this.connectorConfig.getCursorPipelineOrder()).willReturn((Object)pipelineOrder);
        BDDMockito.given((Object)this.connectorConfig.getSkippedOperations()).willReturn(EnumSet.of(Envelope.Operation.TRUNCATE));
        BDDMockito.given((Object)this.filterConfig.getCollectionIncludeList()).willReturn(Optional.of("dbit.*"));
        BDDMockito.given((Object)this.filterConfig.getUserPipeline()).willReturn((Object)new ChangeStreamPipeline(this.asJsonArray(USER_PIPELINE)));
        ChangeStreamPipeline pipeline = this.sut.create();
        ChangeStreamPipelineFactoryTest.assertPipelineStagesEquals(pipeline.getStages(), expectedStageJsons);
    }

    public void testCreateLiterals(MongoDbConnectorConfig.CursorPipelineOrder pipelineOrder, List<String> expectedStageJsons) {
        BDDMockito.given((Object)this.connectorConfig.getCursorPipelineOrder()).willReturn((Object)pipelineOrder);
        BDDMockito.given((Object)this.connectorConfig.getSkippedOperations()).willReturn(EnumSet.of(Envelope.Operation.TRUNCATE));
        BDDMockito.given((Object)this.filterConfig.isLiteralsMatchMode()).willReturn((Object)true);
        BDDMockito.given((Object)this.filterConfig.getCollectionIncludeList()).willReturn(Optional.of("dbit.col1,dbit.col2"));
        BDDMockito.given((Object)this.filterConfig.getSignalDataCollection()).willReturn(Optional.of("signal.col"));
        BDDMockito.given((Object)this.filterConfig.getUserPipeline()).willReturn((Object)new ChangeStreamPipeline(this.asJsonArray(USER_PIPELINE)));
        ChangeStreamPipeline pipeline = this.sut.create();
        ChangeStreamPipelineFactoryTest.assertPipelineStagesEquals(pipeline.getStages(), expectedStageJsons);
    }

    public void testCreateWithSkipOversized(MongoDbConnectorConfig.CursorPipelineOrder pipelineOrder, List<String> expectedStageJsons) {
        BDDMockito.given((Object)this.connectorConfig.getOversizeHandlingMode()).willReturn((Object)MongoDbConnectorConfig.OversizeHandlingMode.SKIP);
        BDDMockito.given((Object)this.connectorConfig.getOversizeSkipThreshold()).willReturn((Object)42);
        this.testCreate(pipelineOrder, this.mergeStages(SIZE_PIPELINE, expectedStageJsons));
    }

    public void testCreateLiteralsWithSkipOversized(MongoDbConnectorConfig.CursorPipelineOrder pipelineOrder, List<String> expectedStageJsons) {
        BDDMockito.given((Object)this.connectorConfig.getOversizeHandlingMode()).willReturn((Object)MongoDbConnectorConfig.OversizeHandlingMode.SKIP);
        BDDMockito.given((Object)this.connectorConfig.getOversizeSkipThreshold()).willReturn((Object)42);
        this.testCreateLiterals(pipelineOrder, this.mergeStages(SIZE_PIPELINE, expectedStageJsons));
    }

    private static void assertPipelineStagesEquals(List<? extends Bson> stages, List<String> expectedStageJsons) {
        Assertions.assertThat(stages).hasSameSizeAs(expectedStageJsons);
        for (int i = 0; i < stages.size(); ++i) {
            String expectedStageJson = expectedStageJsons.get(i);
            ((ObjectAssert)Assertions.assertThat(stages).element(i)).satisfies(stage -> ChangeStreamPipelineFactoryTest.assertJsonEquals(stage.toBsonDocument().toJson(), expectedStageJson));
        }
    }

    private static void assertJsonEquals(String actual, String expected) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode actualNode = mapper.readTree(actual);
            JsonNode expectedNode = mapper.readTree(expected);
            Assertions.assertThat((Iterable)actualNode).isEqualTo((Object)expectedNode);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

