/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.DebeziumException;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.pipeline.signal.actions.snapshotting.AdditionalCondition;
import io.debezium.pipeline.source.snapshot.incremental.DataCollection;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.relational.Table;
import io.debezium.util.HexConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MongoDbIncrementalSnapshotContext<T>
implements IncrementalSnapshotContext<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbIncrementalSnapshotContext.class);
    public static final String INCREMENTAL_SNAPSHOT_KEY = "incremental_snapshot";
    public static final String DATA_COLLECTIONS_TO_SNAPSHOT_KEY = "incremental_snapshot_collections";
    public static final String DATA_COLLECTIONS_TO_SNAPSHOT_KEY_ID = "incremental_snapshot_collections_id";
    public static final String DATA_COLLECTIONS_TO_SNAPSHOT_KEY_ADDITIONAL_CONDITION = "incremental_snapshot_collections_additional_condition";
    public static final String EVENT_PRIMARY_KEY = "incremental_snapshot_primary_key";
    public static final String TABLE_MAXIMUM_KEY = "incremental_snapshot_maximum_key";
    public static final String CORRELATION_ID = "incremental_snapshot_correlation_id";
    protected boolean windowOpened = false;
    private Object[] chunkEndPosition;
    private final Queue<DataCollection<T>> dataCollectionsToSnapshot = new LinkedList<DataCollection<T>>();
    private Object[] lastEventKeySent;
    private String currentChunkId;
    private Object[] maximumKey;
    private Table schema;
    private boolean schemaVerificationPassed;
    private String correlationId;
    private AtomicBoolean paused = new AtomicBoolean(false);
    private ObjectMapper mapper = new ObjectMapper();
    private TypeReference<List<LinkedHashMap<String, String>>> mapperTypeRef = new TypeReference<List<LinkedHashMap<String, String>>>(){};

    public MongoDbIncrementalSnapshotContext(boolean useCatalogBeforeSchema) {
    }

    public boolean openWindow(String id) {
        if (this.notExpectedChunk(id)) {
            LOGGER.info("Received request to open window with id = '{}', expected = '{}', request ignored", (Object)id, (Object)this.currentChunkId);
            return false;
        }
        LOGGER.debug("Opening window for incremental snapshot chunk");
        this.windowOpened = true;
        return true;
    }

    public boolean closeWindow(String id) {
        if (this.notExpectedChunk(id)) {
            LOGGER.info("Received request to close window with id = '{}', expected = '{}', request ignored", (Object)id, (Object)this.currentChunkId);
            return false;
        }
        LOGGER.debug("Closing window for incremental snapshot chunk");
        this.windowOpened = false;
        return true;
    }

    public void pauseSnapshot() {
        LOGGER.info("Pausing incremental snapshot");
        this.paused.set(true);
    }

    public void resumeSnapshot() {
        LOGGER.info("Resuming incremental snapshot");
        this.paused.set(false);
    }

    public boolean isSnapshotPaused() {
        return this.paused.get();
    }

    private boolean notExpectedChunk(String id) {
        return this.currentChunkId == null || !id.startsWith(this.currentChunkId);
    }

    public boolean deduplicationNeeded() {
        return this.windowOpened;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String arrayToSerializedString(Object[] array) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String string;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(array);
                string = HexConverter.convertToHexString((byte[])bos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new DebeziumException(String.format("Cannot serialize chunk information %s", array));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Object[] serializedStringToArray(String field, String serialized) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(HexConverter.convertFromHex((String)serialized));){
            Object[] objectArray;
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                objectArray = (Object[])ois.readObject();
            }
            return objectArray;
        }
        catch (Exception e) {
            throw new DebeziumException(String.format("Failed to deserialize '%s' with value '%s'", field, serialized), (Throwable)e);
        }
    }

    private String dataCollectionsToSnapshotAsString() {
        try {
            List dataCollectionsMap = this.dataCollectionsToSnapshot.stream().map(x -> {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put(DATA_COLLECTIONS_TO_SNAPSHOT_KEY_ID, x.getId().toString());
                map.put(DATA_COLLECTIONS_TO_SNAPSHOT_KEY_ADDITIONAL_CONDITION, x.getAdditionalCondition().isEmpty() ? null : (String)x.getAdditionalCondition().orElse(null));
                return map;
            }).collect(Collectors.toList());
            return this.mapper.writeValueAsString(dataCollectionsMap);
        }
        catch (JsonProcessingException e) {
            throw new DebeziumException("Cannot serialize dataCollectionsToSnapshot information");
        }
    }

    private List<DataCollection<T>> stringToDataCollections(String dataCollectionsStr) {
        try {
            List dataCollections = (List)this.mapper.readValue(dataCollectionsStr, this.mapperTypeRef);
            List<DataCollection<T>> dataCollectionsList = dataCollections.stream().map(x -> new DataCollection((Object)CollectionId.parse((String)x.get(DATA_COLLECTIONS_TO_SNAPSHOT_KEY_ID)))).filter(x -> x.getId() != null).collect(Collectors.toList());
            return dataCollectionsList;
        }
        catch (JsonProcessingException e) {
            throw new DebeziumException("Cannot de-serialize dataCollectionsToSnapshot information");
        }
    }

    public boolean snapshotRunning() {
        return !this.dataCollectionsToSnapshot.isEmpty();
    }

    public Map<String, Object> store(Map<String, Object> offset) {
        if (!this.snapshotRunning()) {
            return offset;
        }
        offset.put(EVENT_PRIMARY_KEY, this.arrayToSerializedString(this.lastEventKeySent));
        offset.put(TABLE_MAXIMUM_KEY, this.arrayToSerializedString(this.maximumKey));
        offset.put(DATA_COLLECTIONS_TO_SNAPSHOT_KEY, this.dataCollectionsToSnapshotAsString());
        offset.put(CORRELATION_ID, this.correlationId);
        return offset;
    }

    private void addTablesIdsToSnapshot(List<DataCollection<T>> dataCollectionIds) {
        this.dataCollectionsToSnapshot.addAll(dataCollectionIds);
    }

    public List<DataCollection<T>> addDataCollectionNamesToSnapshot(String correlationId, List<String> dataCollectionIds, List<AdditionalCondition> additionalCondition, String surrogateKey) {
        List<DataCollection<T>> newDataCollectionIds = dataCollectionIds.stream().map(x -> new DataCollection((Object)CollectionId.parse(x))).filter(x -> x.getId() != null).collect(Collectors.toList());
        this.addTablesIdsToSnapshot(newDataCollectionIds);
        return newDataCollectionIds;
    }

    public void stopSnapshot() {
        this.dataCollectionsToSnapshot.clear();
        this.correlationId = null;
    }

    public boolean removeDataCollectionFromSnapshot(String dataCollectionId) {
        CollectionId collectionId = CollectionId.parse(dataCollectionId);
        return this.dataCollectionsToSnapshot.remove(new DataCollection((Object)collectionId));
    }

    public List<DataCollection<T>> getDataCollections() {
        return new ArrayList<DataCollection<T>>(this.dataCollectionsToSnapshot);
    }

    public void unsetCorrelationId() {
        this.correlationId = null;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    protected static <U> IncrementalSnapshotContext<U> init(MongoDbIncrementalSnapshotContext<U> context, Map<String, ?> offsets) {
        String lastEventSentKeyStr = (String)offsets.get(EVENT_PRIMARY_KEY);
        context.chunkEndPosition = lastEventSentKeyStr != null ? context.serializedStringToArray(EVENT_PRIMARY_KEY, lastEventSentKeyStr) : null;
        context.lastEventKeySent = null;
        String maximumKeyStr = (String)offsets.get(TABLE_MAXIMUM_KEY);
        context.maximumKey = maximumKeyStr != null ? context.serializedStringToArray(TABLE_MAXIMUM_KEY, maximumKeyStr) : null;
        String dataCollectionsStr = (String)offsets.get(DATA_COLLECTIONS_TO_SNAPSHOT_KEY);
        context.dataCollectionsToSnapshot.clear();
        if (dataCollectionsStr != null) {
            context.addTablesIdsToSnapshot(context.stringToDataCollections(dataCollectionsStr));
        }
        context.correlationId = (String)offsets.get(CORRELATION_ID);
        return context;
    }

    public void sendEvent(Object[] key) {
        this.lastEventKeySent = key;
    }

    public DataCollection<T> currentDataCollectionId() {
        return this.dataCollectionsToSnapshot.peek();
    }

    public int dataCollectionsToBeSnapshottedCount() {
        return this.dataCollectionsToSnapshot.size();
    }

    public void nextChunkPosition(Object[] end) {
        this.chunkEndPosition = end;
    }

    public Object[] chunkEndPosititon() {
        return this.chunkEndPosition;
    }

    private void resetChunk() {
        this.lastEventKeySent = null;
        this.chunkEndPosition = null;
        this.maximumKey = null;
        this.schema = null;
        this.schemaVerificationPassed = false;
    }

    public void revertChunk() {
        this.chunkEndPosition = this.lastEventKeySent;
        this.windowOpened = false;
    }

    public boolean isNonInitialChunk() {
        return this.chunkEndPosition != null;
    }

    public DataCollection<T> nextDataCollection() {
        this.resetChunk();
        return this.dataCollectionsToSnapshot.poll();
    }

    public void startNewChunk() {
        this.currentChunkId = UUID.randomUUID().toString();
        LOGGER.debug("Starting new chunk with id '{}'", (Object)this.currentChunkId);
    }

    public String currentChunkId() {
        return this.currentChunkId;
    }

    public void maximumKey(Object[] key) {
        this.maximumKey = key;
    }

    public Optional<Object[]> maximumKey() {
        return Optional.ofNullable(this.maximumKey);
    }

    public Table getSchema() {
        return this.schema;
    }

    public void setSchema(Table schema) {
        this.schema = schema;
    }

    public boolean isSchemaVerificationPassed() {
        return this.schemaVerificationPassed;
    }

    public void setSchemaVerificationPassed(boolean schemaVerificationPassed) {
        this.schemaVerificationPassed = schemaVerificationPassed;
        LOGGER.info("Incremental snapshot's schema verification passed = {}, schema = {}", (Object)schemaVerificationPassed, (Object)this.schema);
    }

    public static <U> MongoDbIncrementalSnapshotContext<U> load(Map<String, ?> offsets, boolean useCatalogBeforeSchema) {
        MongoDbIncrementalSnapshotContext context = new MongoDbIncrementalSnapshotContext(useCatalogBeforeSchema);
        MongoDbIncrementalSnapshotContext.init(context, offsets);
        return context;
    }

    public String toString() {
        return "MongoDbIncrementalSnapshotContext [windowOpened=" + this.windowOpened + ", chunkEndPosition=" + Arrays.toString(this.chunkEndPosition) + ", dataCollectionsToSnapshot=" + this.dataCollectionsToSnapshot + ", lastEventKeySent=" + Arrays.toString(this.lastEventKeySent) + ", maximumKey=" + Arrays.toString(this.maximumKey) + "]";
    }
}

