/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbTopicSelector;
import io.debezium.doc.FixFor;
import io.debezium.schema.TopicSelector;
import io.debezium.spi.schema.DataCollectionId;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

@Deprecated
public class TopicSelectorTest {
    private TopicSelector<CollectionId> noPrefix;
    private TopicSelector<CollectionId> withPrefix;

    @Before
    public void beforeEach() {
        this.noPrefix = MongoDbTopicSelector.defaultSelector(null, (String)"__debezium-heartbeat");
        this.withPrefix = MongoDbTopicSelector.defaultSelector((String)"prefix", (String)"__debezium-heartbeat");
    }

    @Test
    public void shouldHandleCollectionIdWithDatabaseAndCollection() {
        this.assertTopic(this.noPrefix, this.dbAndCollection("db", "coll")).isEqualTo((Object)"db.coll");
        this.assertTopic(this.withPrefix, this.dbAndCollection("db", "coll")).isEqualTo((Object)"prefix.db.coll");
    }

    @Test
    @FixFor(value={"DBZ-878"})
    public void shouldHandleCollectionIdWithInvalidTopicNameChar() {
        this.assertTopic(this.noPrefix, this.dbAndCollection("db", "my@collection")).isEqualTo((Object)"db.my_collection");
        this.assertTopic(this.withPrefix, this.dbAndCollection("db", "my@collection")).isEqualTo((Object)"prefix.db.my_collection");
    }

    protected AbstractStringAssert<?> assertTopic(TopicSelector<CollectionId> selector, CollectionId collectionId) {
        return Assertions.assertThat((String)selector.topicNameFor((DataCollectionId)collectionId));
    }

    protected CollectionId dbAndCollection(String dbName, String collectionName) {
        return new CollectionId("rs0", dbName, collectionName);
    }
}

