/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbSchema;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.schema.DataCollectionSchema;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class MongoDbSchemaIT {
    private Configuration config;
    private MongoDbTaskContext taskContext;

    @Test
    public void shouldAlwaysProduceCollectionSchema() {
        this.config = TestHelper.getConfiguration();
        this.taskContext = new MongoDbTaskContext(this.config);
        MongoDbSchema schema = MongoDbSchemaIT.getSchema(this.config, this.taskContext);
        for (int i = 0; i != 100; ++i) {
            CollectionId id = new CollectionId("rs0", "dbA", "c" + i);
            DataCollectionSchema collectionSchema = schema.schemaFor(id);
            Assertions.assertThat((Object)collectionSchema).isNotNull();
            Assertions.assertThat((Object)collectionSchema.id()).isSameAs((Object)id);
        }
    }

    private static MongoDbSchema getSchema(Configuration config, MongoDbTaskContext taskContext) {
        MongoDbConnectorConfig connectorConfig = new MongoDbConnectorConfig(config);
        return new MongoDbSchema(taskContext.filters(), taskContext.topicNamingStrategy(), connectorConfig.getSourceInfoStructMaker().schema(), connectorConfig.schemaNameAdjuster());
    }
}

