/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.AbstractMongoConnectorIT;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.connector.mongodb.connection.ConnectionContext;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class MongoDbConnectorWithConnectionStringIT
extends AbstractMongoConnectorIT {
    private Configuration getConfig(String connectionString, boolean ssl) {
        Properties properties = TestHelper.getConfiguration(mongo).asProperties();
        properties.remove(MongoDbConnectorConfig.HOSTS.name());
        return ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.from((Properties)properties).edit().with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, "dbit.*")).with(CommonConnectorConfig.TOPIC_PREFIX, "mongo")).with(MongoDbConnectorConfig.CONNECTION_STRING, connectionString)).with(MongoDbConnectorConfig.SSL_ENABLED, ssl)).build();
    }

    @Test
    public void shouldMaskCredentials() {
        this.config = this.getConfig("mongodb://admin:password@localhost:27017/", false);
        ConnectionContext connectionContext = new ConnectionContext(this.config);
        String masked = connectionContext.maskedConnectionSeed();
        Assertions.assertThat((String)masked).isEqualTo((Object)"mongodb://***:***@localhost:27017/");
    }
}

