/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.changestream.OperationType;
import io.debezium.connector.mongodb.ChangeStreamPipeline;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.data.Envelope;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChangeStreamPipelineFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeStreamPipelineFactory.class);
    private final MongoDbConnectorConfig connectorConfig;
    private final Filters.FilterConfig filterConfig;

    ChangeStreamPipelineFactory(MongoDbConnectorConfig connectorConfig, Filters.FilterConfig filterConfig) {
        this.connectorConfig = connectorConfig;
        this.filterConfig = filterConfig;
    }

    ChangeStreamPipeline create() {
        ChangeStreamPipeline internalPipeline = this.createInternalPipeline();
        ChangeStreamPipeline userPipeline = this.createUserPipeline();
        ChangeStreamPipeline effectivePipeline = internalPipeline.then(userPipeline);
        LOGGER.info("Effective change stream pipeline: {}", (Object)effectivePipeline);
        return effectivePipeline;
    }

    private ChangeStreamPipeline createInternalPipeline() {
        List filters = Stream.of(ChangeStreamPipelineFactory.createCollectionFilter(this.filterConfig), ChangeStreamPipelineFactory.createOperationTypeFilter(this.connectorConfig)).flatMap(Optional::stream).collect(Collectors.toList());
        Bson andFilter = Filters.and(filters);
        Bson matchFilter = Aggregates.match((Bson)andFilter);
        return new ChangeStreamPipeline(Aggregates.replaceRoot((Object)new BasicDBObject(Map.of("namespace", ChangeStreamPipelineFactory.concat("$ns.db", ".", "$ns.coll"), "event", "$$ROOT"))), matchFilter, Aggregates.replaceRoot((Object)"$event"));
    }

    private ChangeStreamPipeline createUserPipeline() {
        return this.filterConfig.getUserPipeline();
    }

    private static Optional<Bson> createCollectionFilter(Filters.FilterConfig filterConfig) {
        Optional<Object> dbFilters = Optional.empty();
        if (filterConfig.getDbIncludeList() != null) {
            dbFilters = Optional.of(Filters.regex((String)"event.ns.db", (String)filterConfig.getDbIncludeList().replaceAll(",", "|"), (String)"i"));
        } else if (filterConfig.getDbExcludeList() != null) {
            dbFilters = Optional.of(Filters.regex((String)"event.ns.db", (String)("(?!" + filterConfig.getDbExcludeList().replaceAll(",", "|") + ")"), (String)"i"));
        }
        Optional<Object> collectionsFilters = Optional.empty();
        if (filterConfig.getCollectionIncludeList() != null) {
            collectionsFilters = Optional.of(Filters.regex((String)"namespace", (String)filterConfig.getCollectionIncludeList().replaceAll(",", "|"), (String)"i"));
        } else if (filterConfig.getCollectionExcludeList() != null) {
            collectionsFilters = Optional.of(Filters.regex((String)"namespace", (String)("(?!" + filterConfig.getCollectionExcludeList().replaceAll(",", "|") + ")"), (String)"i"));
        }
        Optional<Object> includedSignalCollectionFilters = Optional.empty();
        if (filterConfig.getSignalDataCollection() != null) {
            includedSignalCollectionFilters = Optional.of(Filters.eq((String)"namespace", (Object)filterConfig.getSignalDataCollection()));
        }
        return ChangeStreamPipelineFactory.andFilters(dbFilters, ChangeStreamPipelineFactory.orFilters(includedSignalCollectionFilters, collectionsFilters));
    }

    private static Optional<Bson> createOperationTypeFilter(MongoDbConnectorConfig connectorConfig) {
        ArrayList<OperationType> includedOperations = new ArrayList<OperationType>();
        includedOperations.add(OperationType.INSERT);
        includedOperations.add(OperationType.UPDATE);
        includedOperations.add(OperationType.REPLACE);
        includedOperations.add(OperationType.DELETE);
        EnumSet skippedOperations = connectorConfig.getSkippedOperations();
        if (skippedOperations.contains(Envelope.Operation.CREATE)) {
            includedOperations.remove(OperationType.INSERT);
        }
        if (skippedOperations.contains(Envelope.Operation.UPDATE)) {
            includedOperations.remove(OperationType.UPDATE);
            includedOperations.remove(OperationType.REPLACE);
        }
        if (skippedOperations.contains(Envelope.Operation.DELETE)) {
            includedOperations.remove(OperationType.DELETE);
        }
        return Optional.of(Filters.in((String)"event.operationType", (Iterable)includedOperations.stream().map(OperationType::getValue).collect(Collectors.toList())));
    }

    @SafeVarargs
    private static Optional<Bson> andFilters(Optional<Bson> ... filters) {
        List<Bson> resolved = ChangeStreamPipelineFactory.resolveFilters(filters);
        if (resolved.isEmpty()) {
            return Optional.empty();
        }
        if (resolved.size() == 1) {
            return Optional.of(resolved.get(0));
        }
        return Optional.of(Filters.and(resolved));
    }

    @SafeVarargs
    private static Optional<Bson> orFilters(Optional<Bson> ... filters) {
        List<Bson> resolved = ChangeStreamPipelineFactory.resolveFilters(filters);
        if (resolved.isEmpty()) {
            return Optional.empty();
        }
        if (resolved.size() == 1) {
            return Optional.of(resolved.get(0));
        }
        return Optional.of(Filters.or(resolved));
    }

    @SafeVarargs
    private static List<Bson> resolveFilters(Optional<Bson> ... filters) {
        return Stream.of(filters).flatMap(Optional::stream).collect(Collectors.toList());
    }

    private static Bson concat(Object ... expressions) {
        return new BasicDBObject("$concat", List.of(expressions));
    }
}

