/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import io.debezium.connector.mongodb.ChangeStreamPipeline;
import io.debezium.connector.mongodb.ChangeStreamPipelineFactory;
import io.debezium.connector.mongodb.JsonSerialization;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.function.BlockingConsumer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoUtil.class);

    public static void forEachDatabaseName(MongoClient client, Consumer<String> operation) {
        MongoUtil.forEach(client.listDatabaseNames(), operation);
    }

    public static void forEachCollectionNameInDatabase(MongoClient client, String databaseName, Consumer<String> operation) {
        MongoDatabase db = client.getDatabase(databaseName);
        MongoUtil.forEach(db.listCollectionNames(), operation);
    }

    public static <T> void forEach(MongoIterable<T> iterable, Consumer<T> operation) {
        try (MongoCursor cursor = iterable.iterator();){
            while (cursor.hasNext()) {
                operation.accept(cursor.next());
            }
        }
    }

    public static void onDatabase(MongoClient client, String dbName, Consumer<MongoDatabase> dbOperation) {
        if (MongoUtil.contains((MongoIterable<String>)client.listDatabaseNames(), dbName)) {
            dbOperation.accept(client.getDatabase(dbName));
        }
    }

    public static void onCollection(MongoClient client, String dbName, String collectionName, Consumer<MongoCollection<Document>> collectionOperation) {
        MongoUtil.onDatabase(client, dbName, db -> {
            if (MongoUtil.contains((MongoIterable<String>)db.listCollectionNames(), collectionName)) {
                collectionOperation.accept(db.getCollection(collectionName));
            }
        });
    }

    public static void onCollectionDocuments(MongoClient client, String dbName, String collectionName, BlockingConsumer<Document> documentOperation) {
        MongoUtil.onCollection(client, dbName, collectionName, collection -> {
            try (MongoCursor cursor = collection.find().iterator();){
                while (cursor.hasNext()) {
                    try {
                        documentOperation.accept((Object)((Document)cursor.next()));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
        });
    }

    public static <T> boolean contains(MongoIterable<String> iterable, String match) {
        return MongoUtil.contains(iterable, (T v) -> Objects.equals(v, match));
    }

    public static <T> boolean contains(MongoIterable<T> iterable, Predicate<T> matcher) {
        try (MongoCursor cursor = iterable.iterator();){
            while (cursor.hasNext()) {
                if (!matcher.test(cursor.next())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static SourceInfo.SessionTransactionId getChangeStreamSessionTransactionId(ChangeStreamDocument<BsonDocument> event) {
        if (event.getLsid() == null || event.getTxnNumber() == null) {
            return null;
        }
        return new SourceInfo.SessionTransactionId(event.getLsid() == null ? null : event.getLsid().toJson(JsonSerialization.COMPACT_JSON_SETTINGS), event.getTxnNumber() == null ? null : Long.valueOf(event.getTxnNumber().longValue()));
    }

    public static ClusterDescription clusterDescription(MongoClient client) {
        ClusterDescription description = client.getClusterDescription();
        if (description.getType() == ClusterType.UNKNOWN) {
            client.listDatabaseNames().first();
            description = client.getClusterDescription();
        }
        return description;
    }

    public static Optional<String> replicaSetName(ClusterDescription clusterDescription) {
        List servers = clusterDescription.getServerDescriptions();
        return servers.stream().map(ServerDescription::getSetName).filter(Objects::nonNull).findFirst();
    }

    public static ChangeStreamIterable<BsonDocument> openChangeStream(MongoClient client, MongoDbTaskContext taskContext) {
        MongoDbConnectorConfig config = taskContext.getConnectorConfig();
        ChangeStreamPipeline pipeline = new ChangeStreamPipelineFactory(config, taskContext.filters().getConfig()).create();
        if (config.getCaptureScope() == MongoDbConnectorConfig.CaptureScope.DATABASE) {
            String database = config.getCaptureTarget().orElseThrow();
            LOGGER.info("Change stream is restricted to '{}' database", (Object)database);
            return client.getDatabase(database).watch(pipeline.getStages(), BsonDocument.class);
        }
        return client.watch(pipeline.getStages(), BsonDocument.class);
    }

    public static BsonTimestamp ping(MongoClient client, String dbName) {
        MongoDatabase database = client.getDatabase(dbName);
        BsonDocument result = (BsonDocument)database.runCommand((Bson)new Document("ping", (Object)1), BsonDocument.class);
        return result.getTimestamp((Object)"operationTime");
    }

    private MongoUtil() {
    }
}

