/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms;

import io.debezium.connector.mongodb.transforms.ExtractNewDocumentState;
import io.debezium.doc.FixFor;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipTestRule;
import io.debezium.junit.SkipWhenKafkaVersion;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestRule;

public class ExtractNewDocumentStateTest {
    private static final String SERVER_NAME = "serverX";
    private ExtractNewDocumentState<SourceRecord> transformation;
    @Rule
    public TestRule skipTestRule = new SkipTestRule();
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Before
    public void setup() {
        this.transformation = new ExtractNewDocumentState();
        this.transformation.configure(Collections.singletonMap("array.encoding", "array"));
    }

    @After
    public void closeSmt() {
        this.transformation.close();
    }

    @Test
    @FixFor(value={"DBZ-1430"})
    public void shouldPassHeartbeatMessages() {
        Schema valueSchema = SchemaBuilder.struct().name("io.debezium.connector.common.Heartbeat").field("ts_ms", Schema.INT64_SCHEMA).build();
        Struct value = new Struct(valueSchema).put("ts_ms", (Object)1565787098802L);
        Schema keySchema = SchemaBuilder.struct().name("io.debezium.connector.common.ServerNameKey").field("serverName", Schema.STRING_SCHEMA).build();
        Struct key = new Struct(keySchema).put("serverName", (Object)"op.with.heartbeat");
        SourceRecord eventRecord = new SourceRecord(new HashMap(), new HashMap(), "op.with.heartbeat", keySchema, (Object)key, valueSchema, (Object)value);
        SourceRecord transformed = (SourceRecord)this.transformation.apply((ConnectRecord)eventRecord);
        Assertions.assertThat((Object)transformed).isSameAs((Object)eventRecord);
    }

    @Test
    @FixFor(value={"DBZ-1430"})
    public void shouldSkipMessagesWithoutDebeziumCdcEnvelopeDueToMissingSchemaName() {
        Schema valueSchema = SchemaBuilder.struct().field("ts_ms", Schema.INT64_SCHEMA).build();
        Struct value = new Struct(valueSchema);
        Schema keySchema = SchemaBuilder.struct().name("op.with.heartbeat.Key").field("id", Schema.STRING_SCHEMA).build();
        Struct key = new Struct(keySchema).put("id", (Object)"123");
        SourceRecord eventRecord = new SourceRecord(new HashMap(), new HashMap(), "op.with.heartbeat", keySchema, (Object)key, valueSchema, (Object)value);
        SourceRecord transformed = (SourceRecord)this.transformation.apply((ConnectRecord)eventRecord);
        Assertions.assertThat((Object)transformed).isSameAs((Object)eventRecord);
    }

    @Test
    @FixFor(value={"DBZ-1430"})
    public void shouldSkipMessagesWithoutDebeziumCdcEnvelopeDueToMissingSchemaNameSuffix() {
        Schema valueSchema = SchemaBuilder.struct().name("io.debezium.connector.common.Heartbeat").field("ts_ms", Schema.INT64_SCHEMA).build();
        Struct value = new Struct(valueSchema);
        Schema keySchema = SchemaBuilder.struct().name("op.with.heartbeat.Key").field("id", Schema.STRING_SCHEMA).build();
        Struct key = new Struct(keySchema).put("id", (Object)"123");
        SourceRecord eventRecord = new SourceRecord(new HashMap(), new HashMap(), "op.with.heartbeat", keySchema, (Object)key, valueSchema, (Object)value);
        SourceRecord transformed = (SourceRecord)this.transformation.apply((ConnectRecord)eventRecord);
        Assertions.assertThat((Object)transformed).isSameAs((Object)eventRecord);
    }

    @Test
    @FixFor(value={"DBZ-1430"})
    public void shouldSkipMessagesWithoutDebeziumCdcEnvelopeDueToMissingValueSchema() {
        Schema valueSchema = SchemaBuilder.struct().name("io.debezium.connector.common.Heartbeat.Envelope").field("ts_ms", Schema.INT64_SCHEMA).build();
        Struct value = new Struct(valueSchema);
        Schema keySchema = SchemaBuilder.struct().name("op.with.heartbeat.Key").field("id", Schema.STRING_SCHEMA).build();
        Struct key = new Struct(keySchema).put("id", (Object)"123");
        SourceRecord eventRecord = new SourceRecord(new HashMap(), new HashMap(), "op.with.heartbeat", keySchema, (Object)key, null, (Object)value);
        SourceRecord transformed = (SourceRecord)this.transformation.apply((ConnectRecord)eventRecord);
        Assertions.assertThat((Object)transformed).isSameAs((Object)eventRecord);
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.GREATER_THAN_OR_EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_241, description="Kafka throws IllegalArgumentException after 2.4.1")
    @FixFor(value={"DBZ-1430"})
    public void shouldFailWhenTheSchemaLooksValidButDoesNotHaveTheCorrectFieldsPreKafka241() {
        Schema valueSchema = SchemaBuilder.struct().name("io.debezium.connector.common.Heartbeat.Envelope").field("ts_ms", Schema.INT64_SCHEMA).build();
        Struct value = new Struct(valueSchema);
        Schema keySchema = SchemaBuilder.struct().name("op.with.heartbeat.Key").field("id", Schema.STRING_SCHEMA).build();
        Struct key = new Struct(keySchema).put("id", (Object)"123");
        SourceRecord eventRecord = new SourceRecord(new HashMap(), new HashMap(), "op.with.heartbeat", keySchema, (Object)key, valueSchema, (Object)value);
        this.exceptionRule.expect(NullPointerException.class);
        SourceRecord transformed = (SourceRecord)this.transformation.apply((ConnectRecord)eventRecord);
        Assertions.assertThat((Object)transformed).isNull();
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.LESS_THAN, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_241, description="Kafka throws NullPointerException prior to 2.4.1")
    @FixFor(value={"DBZ-1430"})
    public void shouldFailWhenTheSchemaLooksValidButDoesNotHaveTheCorrectFieldsPostKafka241() {
        Schema valueSchema = SchemaBuilder.struct().name("io.debezium.connector.common.Heartbeat.Envelope").field("ts_ms", Schema.INT64_SCHEMA).build();
        Struct value = new Struct(valueSchema);
        Schema keySchema = SchemaBuilder.struct().name("op.with.heartbeat.Key").field("id", Schema.STRING_SCHEMA).build();
        Struct key = new Struct(keySchema).put("id", (Object)"123");
        SourceRecord eventRecord = new SourceRecord(new HashMap(), new HashMap(), "op.with.heartbeat", keySchema, (Object)key, valueSchema, (Object)value);
        this.exceptionRule.expect(IllegalArgumentException.class);
        SourceRecord transformed = (SourceRecord)this.transformation.apply((ConnectRecord)eventRecord);
        Assertions.assertThat((Object)transformed).isNull();
    }
}

