/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.junit;

import io.debezium.connector.mongodb.junit.MongoDbDatabaseVersionResolver;
import io.debezium.connector.mongodb.junit.MongoDbPlatform;
import io.debezium.testing.testcontainers.MongoDbDeployment;
import io.debezium.testing.testcontainers.MongoDbReplicaSet;
import io.debezium.testing.testcontainers.MongoDbShardedCluster;
import io.debezium.testing.testcontainers.util.ParsingPortResolver;
import io.debezium.testing.testcontainers.util.PortResolver;

public final class MongoDbDatabaseProvider {
    public static final String MONGO_REPLICA_SIZE = "mongodb.replica.size";
    public static final String MONGO_SHARD_SIZE = "mongodb.shard.size";
    public static final String MONGO_SHARD_REPLICA_SIZE = "mongodb.shard.replica.size";
    public static final String MONGO_DOCKER_DESKTOP_PORT_PROPERTY = "mongodb.docker.desktop.ports";
    public static final String MONGO_DOCKER_DESKTOP_PORT_DEFAULT = "27017:27117";

    public static MongoDbReplicaSet dockerReplicaSet() {
        ParsingPortResolver portResolver = ParsingPortResolver.parseProperty((String)MONGO_DOCKER_DESKTOP_PORT_PROPERTY, (String)MONGO_DOCKER_DESKTOP_PORT_DEFAULT);
        int replicaSize = Integer.parseInt(System.getProperty(MONGO_REPLICA_SIZE, "1"));
        return MongoDbReplicaSet.replicaSet().memberCount(replicaSize).portResolver((PortResolver)portResolver).build();
    }

    public static MongoDbShardedCluster mongoDbShardedCluster() {
        ParsingPortResolver portResolver = ParsingPortResolver.parseProperty((String)MONGO_DOCKER_DESKTOP_PORT_PROPERTY, (String)MONGO_DOCKER_DESKTOP_PORT_DEFAULT);
        int shardSize = Integer.parseInt(System.getProperty(MONGO_SHARD_SIZE, "2"));
        int replicaSize = Integer.parseInt(System.getProperty(MONGO_SHARD_REPLICA_SIZE, "1"));
        return MongoDbShardedCluster.shardedCluster().shardCount(shardSize).replicaCount(replicaSize).routerCount(1).portResolver((PortResolver)portResolver).build();
    }

    public static MongoDbDeployment externalOrDockerReplicaSet() {
        MongoDbPlatform platform = MongoDbDatabaseVersionResolver.getPlatform();
        return platform.provider.get();
    }

    private MongoDbDatabaseProvider() {
    }
}

