/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.transforms.MongoDataConverter;
import io.debezium.data.Envelope;
import io.debezium.schema.FieldNameSelector;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.transforms.ExtractNewRecordStateConfigDefinition;
import io.debezium.transforms.SmtManager;
import io.debezium.util.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.Flatten;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SchemaUtil;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractNewDocumentState<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractNewDocumentState.class);
    private static final Pattern FIELD_SEPARATOR = Pattern.compile("\\.");
    private static final Pattern NEW_FIELD_SEPARATOR = Pattern.compile(":");
    private static final io.debezium.config.Field ARRAY_ENCODING = io.debezium.config.Field.create((String)"array.encoding").withDisplayName("Array encoding").withEnum(ArrayEncoding.class, (Enum)ArrayEncoding.ARRAY).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The arrays can be encoded using 'array' schema type (the default) or as a 'document' (similar to how BSON encodes arrays). 'array' is easier to consume but requires all elements in the array to be of the same type. Use 'document' if the arrays in data source mix different types together.");
    private static final io.debezium.config.Field FLATTEN_STRUCT = io.debezium.config.Field.create((String)"flatten.struct").withDisplayName("Flatten struct").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withDescription("Flattening structs by concatenating the fields into plain properties, using a (configurable) delimiter.");
    private static final io.debezium.config.Field DELIMITER = io.debezium.config.Field.create((String)"flatten.struct.delimiter").withDisplayName("Delimiter for flattened struct").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault("_").withDescription("Delimiter to concat between field names from the input record when generating field names for theoutput record.");
    private final ExtractField<R> beforeExtractor = new ExtractField.Value();
    private final ExtractField<R> afterExtractor = new ExtractField.Value();
    private final ExtractField<R> updateDescriptionExtractor = new ExtractField.Value();
    private final ExtractField<R> keyExtractor = new ExtractField.Key();
    private MongoDataConverter converter;
    private final Flatten<R> recordFlattener = new Flatten.Value();
    private List<FieldReference> additionalHeaders;
    private List<FieldReference> additionalFields;
    private boolean flattenStruct;
    private String delimiter;
    private boolean dropTombstones;
    private ExtractNewRecordStateConfigDefinition.DeleteHandling handleDeletes;
    private SmtManager<R> smtManager;

    public R apply(R record) {
        if (!this.smtManager.isValidKey(record)) {
            return record;
        }
        ConnectRecord keyRecord = this.keyExtractor.apply(record);
        BsonDocument keyDocument = BsonDocument.parse((String)("{ \"id\" : " + keyRecord.key().toString() + "}"));
        BsonDocument valueDocument = new BsonDocument();
        if (record.value() == null) {
            if (this.dropTombstones) {
                LOGGER.trace("Tombstone {} arrived and requested to be dropped", record.key());
                return null;
            }
            if (!this.additionalHeaders.isEmpty()) {
                Headers headersToAdd = this.makeHeaders(this.additionalHeaders, (Struct)record.value());
                headersToAdd.forEach(h -> record.headers().add(h));
            }
            return this.newRecord(record, keyDocument, valueDocument);
        }
        if (!this.smtManager.isValidEnvelope(record)) {
            return record;
        }
        ConnectRecord beforeRecord = this.beforeExtractor.apply(record);
        ConnectRecord afterRecord = this.afterExtractor.apply(record);
        ConnectRecord updateDescriptionRecord = this.updateDescriptionExtractor.apply(record);
        if (!this.additionalHeaders.isEmpty()) {
            Headers headersToAdd = this.makeHeaders(this.additionalHeaders, (Struct)record.value());
            headersToAdd.forEach(h -> record.headers().add(h));
        }
        if (afterRecord.value() != null) {
            valueDocument = this.getFullDocument(afterRecord, keyDocument);
        }
        if (afterRecord.value() == null && updateDescriptionRecord.value() != null) {
            valueDocument = this.getPartialUpdateDocument(beforeRecord, updateDescriptionRecord, keyDocument);
        }
        boolean isDeletion = false;
        if (afterRecord.value() == null && updateDescriptionRecord.value() == null) {
            if (this.handleDeletes.equals((Object)ExtractNewRecordStateConfigDefinition.DeleteHandling.DROP)) {
                LOGGER.trace("Delete {} arrived and requested to be dropped", record.key());
                return null;
            }
            if (beforeRecord.value() != null && this.handleDeletes.equals((Object)ExtractNewRecordStateConfigDefinition.DeleteHandling.REWRITE)) {
                valueDocument = this.getFullDocument(beforeRecord, keyDocument);
            }
            isDeletion = true;
        }
        if (this.handleDeletes.equals((Object)ExtractNewRecordStateConfigDefinition.DeleteHandling.REWRITE)) {
            valueDocument.append("__deleted", (BsonValue)new BsonBoolean(isDeletion));
        }
        return this.newRecord(record, keyDocument, valueDocument);
    }

    private R newRecord(R record, BsonDocument keyDocument, BsonDocument valueDocument) {
        SchemaBuilder keySchemaBuilder = SchemaBuilder.struct();
        Set keyPairs = keyDocument.entrySet();
        for (Map.Entry keyPairsForSchema : keyPairs) {
            this.converter.addFieldSchema(keyPairsForSchema, keySchemaBuilder);
        }
        Schema finalKeySchema = keySchemaBuilder.build();
        Struct finalKeyStruct = new Struct(finalKeySchema);
        for (Map.Entry keyPairsForStruct : keyPairs) {
            this.converter.convertRecord(keyPairsForStruct, finalKeySchema, finalKeyStruct);
        }
        Schema finalValueSchema = null;
        Struct finalValueStruct = null;
        if (valueDocument.size() > 0) {
            String newValueSchemaName = record.valueSchema().name();
            if (Envelope.isEnvelopeSchema((String)newValueSchemaName)) {
                newValueSchemaName = newValueSchemaName.substring(0, newValueSchemaName.length() - 9);
            }
            SchemaBuilder valueSchemaBuilder = SchemaBuilder.struct().name(newValueSchemaName);
            Set valuePairs = valueDocument.entrySet();
            for (Map.Entry valuePairsForSchema : valuePairs) {
                this.converter.addFieldSchema(valuePairsForSchema, valueSchemaBuilder);
            }
            if (!this.additionalFields.isEmpty()) {
                this.addAdditionalFieldsSchema(this.additionalFields, record, valueSchemaBuilder);
            }
            finalValueSchema = valueSchemaBuilder.build();
            finalValueStruct = new Struct(finalValueSchema);
            for (Map.Entry valuePairsForStruct : valuePairs) {
                this.converter.convertRecord(valuePairsForStruct, finalValueSchema, finalValueStruct);
            }
            if (!this.additionalFields.isEmpty()) {
                this.addFields(this.additionalFields, record, finalValueStruct);
            }
        }
        ConnectRecord newRecord = record.newRecord(record.topic(), record.kafkaPartition(), finalKeySchema, (Object)finalKeyStruct, finalValueSchema, finalValueStruct, record.timestamp());
        if (this.flattenStruct) {
            return (R)this.recordFlattener.apply(newRecord);
        }
        return (R)newRecord;
    }

    private void addAdditionalFieldsSchema(List<FieldReference> additionalFields, R originalRecord, SchemaBuilder valueSchemaBuilder) {
        Schema sourceSchema = originalRecord.valueSchema();
        for (FieldReference fieldReference : additionalFields) {
            valueSchemaBuilder.field(fieldReference.newFieldName, fieldReference.getSchema(sourceSchema));
        }
    }

    private void addFields(List<FieldReference> additionalFields, R originalRecord, Struct value) {
        Struct originalRecordValue = (Struct)originalRecord.value();
        for (FieldReference fieldReference : additionalFields) {
            value.put(fieldReference.newFieldName, fieldReference.getValue(originalRecordValue));
        }
    }

    private BsonDocument getPartialUpdateDocument(R beforeRecord, R updateDescriptionRecord, BsonDocument keyDocument) {
        BsonDocument valueDocument = new BsonDocument();
        Struct updateDescription = Requirements.requireStruct((Object)updateDescriptionRecord.value(), (String)"updateDescription");
        String updated = updateDescription.getString("updatedFields");
        List removed = updateDescription.getArray("removedFields");
        if (beforeRecord.value() != null) {
            valueDocument = BsonDocument.parse((String)beforeRecord.value().toString());
        }
        if (updated != null) {
            BsonDocument updatedBson = BsonDocument.parse((String)updated);
            for (Map.Entry valueEntry : updatedBson.entrySet()) {
                valueDocument.append((String)valueEntry.getKey(), (BsonValue)valueEntry.getValue());
            }
        }
        if (removed != null) {
            for (String field : removed) {
                valueDocument.keySet().remove(field);
            }
        }
        if (!valueDocument.containsKey((Object)"_id")) {
            valueDocument.append("_id", keyDocument.get((Object)"id"));
        }
        if (this.flattenStruct) {
            BsonDocument newDocument = new BsonDocument();
            valueDocument.forEach((fKey, fValue) -> newDocument.put(fKey.replace(".", this.delimiter), fValue));
            valueDocument = newDocument;
        }
        return valueDocument;
    }

    private BsonDocument getFullDocument(R record, BsonDocument key) {
        return BsonDocument.parse((String)record.value().toString());
    }

    private Headers makeHeaders(List<FieldReference> additionalHeaders, Struct originalRecordValue) {
        ConnectHeaders headers = new ConnectHeaders();
        for (FieldReference fieldReference : additionalHeaders) {
            if (originalRecordValue == null) {
                if (!"op".equals(fieldReference.field)) continue;
                headers.addString(fieldReference.newFieldName, Envelope.Operation.DELETE.code());
                continue;
            }
            if (!fieldReference.exists(originalRecordValue.schema())) continue;
            headers.add(fieldReference.getNewFieldName(), fieldReference.getValue(originalRecordValue), fieldReference.getSchema(originalRecordValue.schema()));
        }
        return headers;
    }

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        io.debezium.config.Field.group((ConfigDef)config, null, (io.debezium.config.Field[])new io.debezium.config.Field[]{ARRAY_ENCODING, FLATTEN_STRUCT, DELIMITER});
        return config;
    }

    public void close() {
    }

    public void configure(Map<String, ?> map) {
        Configuration config = Configuration.from(map);
        this.smtManager = new SmtManager(config);
        Field.Set configFields = io.debezium.config.Field.setOf((io.debezium.config.Field[])new io.debezium.config.Field[]{ARRAY_ENCODING, FLATTEN_STRUCT, DELIMITER, ExtractNewRecordStateConfigDefinition.HANDLE_DELETES, ExtractNewRecordStateConfigDefinition.DROP_TOMBSTONES, ExtractNewRecordStateConfigDefinition.ADD_HEADERS, ExtractNewRecordStateConfigDefinition.ADD_FIELDS});
        if (!config.validateAndRecord((Iterable)configFields, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new DebeziumException("Unable to validate config.");
        }
        CommonConnectorConfig.FieldNameAdjustmentMode fieldNameAdjustmentMode = CommonConnectorConfig.FieldNameAdjustmentMode.parse((String)config.getString(CommonConnectorConfig.FIELD_NAME_ADJUSTMENT_MODE));
        SchemaNameAdjuster fieldNameAdjuster = fieldNameAdjustmentMode.createAdjuster();
        this.converter = new MongoDataConverter(ArrayEncoding.parse(config.getString(ARRAY_ENCODING)), (FieldNameSelector.FieldNamer<String>)FieldNameSelector.defaultNonRelationalSelector((SchemaNameAdjuster)fieldNameAdjuster), fieldNameAdjustmentMode != CommonConnectorConfig.FieldNameAdjustmentMode.NONE);
        String addFieldsPrefix = config.getString(ExtractNewRecordStateConfigDefinition.ADD_FIELDS_PREFIX);
        String addHeadersPrefix = config.getString(ExtractNewRecordStateConfigDefinition.ADD_HEADERS_PREFIX);
        this.additionalHeaders = FieldReference.fromConfiguration(addHeadersPrefix, config.getString(ExtractNewRecordStateConfigDefinition.ADD_HEADERS));
        this.additionalFields = FieldReference.fromConfiguration(addFieldsPrefix, config.getString(ExtractNewRecordStateConfigDefinition.ADD_FIELDS));
        this.flattenStruct = config.getBoolean(FLATTEN_STRUCT);
        this.delimiter = config.getString(DELIMITER);
        this.dropTombstones = config.getBoolean(ExtractNewRecordStateConfigDefinition.DROP_TOMBSTONES);
        this.handleDeletes = ExtractNewRecordStateConfigDefinition.DeleteHandling.parse((String)config.getString(ExtractNewRecordStateConfigDefinition.HANDLE_DELETES));
        HashMap<String, String> beforeExtractorConfig = new HashMap<String, String>();
        beforeExtractorConfig.put("field", "before");
        HashMap<String, String> afterExtractorConfig = new HashMap<String, String>();
        afterExtractorConfig.put("field", "after");
        HashMap<String, String> updateDescriptionExtractorConfig = new HashMap<String, String>();
        updateDescriptionExtractorConfig.put("field", "updateDescription");
        HashMap<String, String> keyExtractorConfig = new HashMap<String, String>();
        keyExtractorConfig.put("field", "id");
        this.beforeExtractor.configure(beforeExtractorConfig);
        this.afterExtractor.configure(afterExtractorConfig);
        this.updateDescriptionExtractor.configure(updateDescriptionExtractorConfig);
        this.keyExtractor.configure(keyExtractorConfig);
        HashMap<String, String> delegateConfig = new HashMap<String, String>();
        delegateConfig.put("delimiter", this.delimiter);
        this.recordFlattener.configure(delegateConfig);
    }

    private static List<String> determineAdditionalSourceField(String addSourceFieldsConfig) {
        if (Strings.isNullOrEmpty((String)addSourceFieldsConfig)) {
            return Collections.emptyList();
        }
        return Arrays.stream(addSourceFieldsConfig.split(",")).map(String::trim).collect(Collectors.toList());
    }

    private static class FieldReference {
        private final String struct;
        private final String field;
        private final String newFieldName;

        private FieldReference(String prefix, String field) {
            String[] parts = NEW_FIELD_SEPARATOR.split(field);
            String[] splits = FIELD_SEPARATOR.split(parts[0]);
            this.field = splits.length == 1 ? splits[0] : splits[1];
            String string = this.struct = splits.length == 1 ? FieldReference.determineStruct(this.field) : splits[0];
            if (parts.length == 1) {
                this.newFieldName = prefix + (String)(splits.length == 1 ? this.field : this.struct + "_" + this.field);
            } else if (parts.length == 2) {
                this.newFieldName = prefix + parts[1];
            } else {
                throw new IllegalArgumentException("Unexpected field name: " + field);
            }
        }

        private static String determineStruct(String simpleFieldName) {
            switch (simpleFieldName) {
                case "op": 
                case "ts_ms": {
                    return null;
                }
                case "id": 
                case "data_collection_order": 
                case "total_order": {
                    return "transaction";
                }
                case "updateDescription": {
                    return "updateDescription";
                }
            }
            return "source";
        }

        static List<FieldReference> fromConfiguration(String fieldPrefix, String addHeadersConfig) {
            if (Strings.isNullOrEmpty((String)addHeadersConfig)) {
                return Collections.emptyList();
            }
            return Arrays.stream(addHeadersConfig.split(",")).map(String::trim).map(field -> new FieldReference(fieldPrefix, (String)field)).collect(Collectors.toList());
        }

        String getNewFieldName() {
            return this.newFieldName;
        }

        Object getValue(Struct originalRecordValue) {
            Struct parentStruct = this.struct != null ? (Struct)originalRecordValue.get(this.struct) : originalRecordValue;
            return parentStruct != null ? parentStruct.get(this.field) : null;
        }

        Schema getSchema(Schema originalRecordSchema) {
            Schema parentSchema = this.struct != null ? originalRecordSchema.field(this.struct).schema() : originalRecordSchema;
            Field schemaField = parentSchema.field(this.field);
            if (schemaField == null) {
                throw new IllegalArgumentException("Unexpected field name: " + this.field);
            }
            return SchemaUtil.copySchemaBasics((Schema)schemaField.schema()).optional().build();
        }

        private boolean exists(Schema originalRecordSchema) {
            Schema parentSchema = this.struct != null ? originalRecordSchema.field(this.struct).schema() : originalRecordSchema;
            Field schemaField = parentSchema.field(this.field);
            return schemaField != null;
        }
    }

    public static enum ArrayEncoding implements EnumeratedValue
    {
        ARRAY("array"),
        DOCUMENT("document");

        private final String value;

        private ArrayEncoding(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ArrayEncoding parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (ArrayEncoding option : ArrayEncoding.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static ArrayEncoding parse(String value, String defaultValue) {
            ArrayEncoding mode = ArrayEncoding.parse(value);
            if (mode == null && defaultValue != null) {
                mode = ArrayEncoding.parse(defaultValue);
            }
            return mode;
        }
    }
}

