/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms;

import io.confluent.connect.avro.AvroData;
import io.debezium.connector.mongodb.transforms.ExtractNewDocumentState;
import io.debezium.connector.mongodb.transforms.MongoDataConverter;
import io.debezium.doc.FixFor;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.assertj.core.api.Assertions;
import org.bson.BsonDocument;
import org.junit.Before;
import org.junit.Test;

public class ToAvroMongoDataConverterTest {
    private String record;
    private BsonDocument val;
    private SchemaBuilder builder;
    private AvroData avroData;
    private MongoDataConverter converter;

    @Before
    public void setup() throws Exception {
        this.record = this.getFile("complex_objects.json");
        this.val = BsonDocument.parse((String)this.record);
        this.builder = SchemaBuilder.struct().name("complex");
        this.avroData = new AvroData(100);
        this.converter = new MongoDataConverter(ExtractNewDocumentState.ArrayEncoding.ARRAY);
    }

    @Test
    public void shouldCreateStructWithNestedObject() {
        for (Map.Entry entry : this.val.entrySet()) {
            this.converter.addFieldSchema(entry, this.builder);
        }
        org.apache.kafka.connect.data.Schema finalSchema = this.builder.build();
        Struct struct = new Struct(finalSchema);
        for (Map.Entry entry : this.val.entrySet()) {
            this.converter.convertRecord(entry, finalSchema, struct);
        }
        GenericData.Record avro = (GenericData.Record)this.avroData.fromConnectData(finalSchema, (Object)struct);
        Assertions.assertThat((String)avro.toString()).isEqualTo((Object)"{\"_id\": 1, \"s1\": {\"s1f1\": \"field1s1\", \"s1f2\": \"field2s1\"}, \"s2\": {\"s2f1\": \"field1s2\", \"s2f2\": {\"in1\": 1}}}");
    }

    @Test
    @FixFor(value={"DBZ-650"})
    public void shouldCreateSchemaWithNestedObject() {
        for (Map.Entry entry : this.val.entrySet()) {
            this.converter.addFieldSchema(entry, this.builder);
        }
        org.apache.kafka.connect.data.Schema finalSchema = this.builder.build();
        Schema avroSchema = this.avroData.fromConnectSchema(finalSchema);
        Assertions.assertThat((String)avroSchema.toString()).isEqualTo((Object)"{\"type\":\"record\",\"name\":\"complex\",\"fields\":[{\"name\":\"_id\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"s1\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"s1\",\"namespace\":\"complex\",\"fields\":[{\"name\":\"s1f1\",\"type\":[\"null\",\"string\"],\"default\":null},{\"name\":\"s1f2\",\"type\":[\"null\",\"string\"],\"default\":null}],\"connect.name\":\"complex.s1\"}],\"default\":null},{\"name\":\"s2\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"s2\",\"namespace\":\"complex\",\"fields\":[{\"name\":\"s2f1\",\"type\":[\"null\",\"string\"],\"default\":null},{\"name\":\"s2f2\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"s2f2\",\"namespace\":\"complex.s2\",\"fields\":[{\"name\":\"in1\",\"type\":[\"null\",\"int\"],\"default\":null}],\"connect.name\":\"complex.s2.s2f2\"}],\"default\":null}],\"connect.name\":\"complex.s2\"}],\"default\":null}],\"connect.name\":\"complex\"}");
    }

    private String getFile(String fileName) throws IOException, URISyntaxException {
        URL jsonResource = this.getClass().getClassLoader().getResource(fileName);
        return new String(Files.readAllBytes(Paths.get(jsonResource.toURI())), StandardCharsets.UTF_8);
    }
}

