/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbOffsetContext;
import io.debezium.connector.mongodb.ResumeTokens;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.connector.mongodb.connection.ReplicaSet;
import io.debezium.pipeline.CommonOffsetContext;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.spi.schema.DataCollectionId;
import java.time.Instant;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ReplicaSetOffsetContext
extends CommonOffsetContext<SourceInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicaSetOffsetContext.class);
    private final MongoDbOffsetContext offsetContext;
    private final String replicaSetName;
    private final IncrementalSnapshotContext<CollectionId> incrementalSnapshotContext;

    public ReplicaSetOffsetContext(MongoDbOffsetContext offsetContext, ReplicaSet replicaSet, SourceInfo sourceInfo, IncrementalSnapshotContext<CollectionId> incrementalSnapshotContext) {
        super((BaseSourceInfo)sourceInfo);
        this.offsetContext = offsetContext;
        this.replicaSetName = replicaSet.replicaSetName();
        this.incrementalSnapshotContext = incrementalSnapshotContext;
    }

    public Map<String, ?> getOffset() {
        Map offsets = ((SourceInfo)this.sourceInfo).lastOffset(this.replicaSetName);
        return this.isSnapshotOngoing() ? offsets : this.incrementalSnapshotContext.store(this.offsetContext.getTransactionContext().store(offsets));
    }

    public Schema getSourceInfoSchema() {
        return this.offsetContext.getSourceInfoSchema();
    }

    public boolean isSnapshotRunning() {
        return this.offsetContext.isSnapshotRunning();
    }

    public void preSnapshotStart() {
        this.offsetContext.preSnapshotStart();
    }

    public void preSnapshotCompletion() {
        this.offsetContext.preSnapshotCompletion();
    }

    public void event(DataCollectionId collectionId, Instant timestamp) {
        throw new UnsupportedOperationException();
    }

    public TransactionContext getTransactionContext() {
        return this.offsetContext.getTransactionContext();
    }

    public String getReplicaSetName() {
        return this.replicaSetName;
    }

    public boolean isSnapshotOngoing() {
        return ((SourceInfo)this.sourceInfo).isInitialSyncOngoing(this.replicaSetName);
    }

    public boolean hasOffset() {
        return ((SourceInfo)this.sourceInfo).hasOffset(this.replicaSetName);
    }

    public void readEvent(CollectionId collectionId, Instant timestamp) {
        ((SourceInfo)this.sourceInfo).collectionEvent(this.replicaSetName, collectionId, 0L);
        ((SourceInfo)this.sourceInfo).lastOffset(this.replicaSetName);
    }

    public void initEvent(MongoChangeStreamCursor<ChangeStreamDocument<BsonDocument>> cursor) {
        ((SourceInfo)this.sourceInfo).initEvent(this.replicaSetName, cursor);
    }

    public void initFromOpTimeIfNeeded(MongoClient client) {
        if (this.lastResumeToken() != null) {
            return;
        }
        LOGGER.info("Initializing offset for replica-set {} from operation time", (Object)this.replicaSetName);
        MongoDatabase database = client.getDatabase("admin");
        BsonDocument result = (BsonDocument)database.runCommand((Bson)new Document("ping", (Object)1), BsonDocument.class);
        BsonTimestamp timestamp = result.getTimestamp((Object)"operationTime");
        ((SourceInfo)this.sourceInfo).noEvent(this.replicaSetName, timestamp);
    }

    public void noEvent(MongoChangeStreamCursor<?> cursor) {
        ((SourceInfo)this.sourceInfo).noEvent(this.replicaSetName, cursor);
    }

    public void changeStreamEvent(ChangeStreamDocument<BsonDocument> changeStreamEvent) {
        ((SourceInfo)this.sourceInfo).changeStreamEvent(this.replicaSetName, changeStreamEvent);
    }

    public String lastResumeToken() {
        return ((SourceInfo)this.sourceInfo).lastResumeToken(this.replicaSetName);
    }

    public BsonDocument lastResumeTokenDoc() {
        String data = ((SourceInfo)this.sourceInfo).lastResumeToken(this.replicaSetName);
        return data == null ? null : ResumeTokens.fromData(data);
    }

    public BsonTimestamp lastTimestamp() {
        return ((SourceInfo)this.sourceInfo).lastTimestamp(this.replicaSetName);
    }

    public IncrementalSnapshotContext<?> getIncrementalSnapshotContext() {
        return this.offsetContext.getIncrementalSnapshotContext();
    }
}

