/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.metrics;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.pipeline.JmxUtils;
import io.debezium.util.Collect;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.connect.errors.ConnectException;

@ThreadSafe
public abstract class Metrics {
    private final ObjectName name;
    private volatile boolean registered = false;

    protected Metrics(CdcSourceTaskContext taskContext, String contextName) {
        this.name = this.metricName(taskContext.getConnectorType(), taskContext.getConnectorName(), contextName);
    }

    protected Metrics(CdcSourceTaskContext taskContext, Map<String, String> tags) {
        this.name = this.metricName(taskContext.getConnectorType(), tags);
    }

    protected Metrics(CommonConnectorConfig connectorConfig, String contextName, boolean multiPartitionMode) {
        String connectorType = connectorConfig.getContextName();
        String connectorName = connectorConfig.getLogicalName();
        this.name = multiPartitionMode ? this.metricName(connectorType, Collect.linkMapOf("server", connectorName, "task", connectorConfig.getTaskId(), "context", contextName)) : this.metricName(connectorType, connectorName, contextName);
    }

    public synchronized void register() {
        JmxUtils.registerMXBean(this.name, this);
        this.registered = true;
    }

    public synchronized void unregister() {
        if (this.name != null && this.registered) {
            JmxUtils.unregisterMXBean(this.name);
            this.registered = false;
        }
    }

    protected ObjectName metricName(String connectorType, String connectorName, String contextName) {
        return this.metricName(connectorType, Collect.linkMapOf("context", contextName, "server", connectorName));
    }

    protected ObjectName metricName(String connectorType, Map<String, String> tags) {
        String metricName = "debezium." + connectorType.toLowerCase() + ":type=connector-metrics," + tags.entrySet().stream().map(e -> (String)e.getKey() + "=" + Sanitizer.jmxSanitize((String)((String)e.getValue()))).collect(Collectors.joining(","));
        try {
            return new ObjectName(metricName);
        }
        catch (MalformedObjectNameException e2) {
            throw new ConnectException("Invalid metric name '" + metricName + "'");
        }
    }
}

