/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.internal.MongoChangeStreamCursorImpl;
import com.mongodb.client.internal.MongoIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.model.changestream.FullDocumentBeforeChange;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.ChangeStreamOperation;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.RawBsonDocumentCodec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public class ChangeStreamIterableImpl<TResult>
extends MongoIterableImpl<ChangeStreamDocument<TResult>>
implements ChangeStreamIterable<TResult> {
    private final MongoNamespace namespace;
    private final CodecRegistry codecRegistry;
    private final List<? extends Bson> pipeline;
    private final Codec<ChangeStreamDocument<TResult>> codec;
    private final ChangeStreamLevel changeStreamLevel;
    private FullDocument fullDocument = FullDocument.DEFAULT;
    private FullDocumentBeforeChange fullDocumentBeforeChange = FullDocumentBeforeChange.DEFAULT;
    private BsonDocument resumeToken;
    private BsonDocument startAfter;
    private long maxAwaitTimeMS;
    private Collation collation;
    private BsonTimestamp startAtOperationTime;
    private BsonValue comment;
    private boolean showExpandedEvents;

    public ChangeStreamIterableImpl(@Nullable ClientSession clientSession, String databaseName, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor executor, List<? extends Bson> pipeline, Class<TResult> resultClass, ChangeStreamLevel changeStreamLevel, boolean retryReads) {
        this(clientSession, new MongoNamespace(databaseName, "ignored"), codecRegistry, readPreference, readConcern, executor, pipeline, resultClass, changeStreamLevel, retryReads);
    }

    public ChangeStreamIterableImpl(@Nullable ClientSession clientSession, MongoNamespace namespace, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor executor, List<? extends Bson> pipeline, Class<TResult> resultClass, ChangeStreamLevel changeStreamLevel, boolean retryReads) {
        super(clientSession, executor, readConcern, readPreference, retryReads);
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.pipeline = (List)Assertions.notNull((String)"pipeline", pipeline);
        this.codec = ChangeStreamDocument.createCodec((Class)((Class)Assertions.notNull((String)"resultClass", resultClass)), (CodecRegistry)codecRegistry);
        this.changeStreamLevel = (ChangeStreamLevel)Assertions.notNull((String)"changeStreamLevel", (Object)changeStreamLevel);
    }

    @Override
    public ChangeStreamIterable<TResult> fullDocument(FullDocument fullDocument) {
        this.fullDocument = (FullDocument)Assertions.notNull((String)"fullDocument", (Object)fullDocument);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> fullDocumentBeforeChange(FullDocumentBeforeChange fullDocumentBeforeChange) {
        this.fullDocumentBeforeChange = (FullDocumentBeforeChange)Assertions.notNull((String)"fullDocumentBeforeChange", (Object)fullDocumentBeforeChange);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> resumeAfter(BsonDocument resumeAfter) {
        this.resumeToken = (BsonDocument)Assertions.notNull((String)"resumeAfter", (Object)resumeAfter);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> collation(@Nullable Collation collation) {
        this.collation = (Collation)Assertions.notNull((String)"collation", (Object)collation);
        return this;
    }

    @Override
    public <TDocument> MongoIterable<TDocument> withDocumentClass(final Class<TDocument> clazz) {
        return new MongoIterableImpl<TDocument>(this.getClientSession(), this.getExecutor(), this.getReadConcern(), this.getReadPreference(), this.getRetryReads()){

            @Override
            public MongoCursor<TDocument> iterator() {
                return this.cursor();
            }

            @Override
            public MongoChangeStreamCursor<TDocument> cursor() {
                return new MongoChangeStreamCursorImpl((BatchCursor<RawBsonDocument>)ChangeStreamIterableImpl.this.execute(), ChangeStreamIterableImpl.this.codecRegistry.get(clazz), ChangeStreamIterableImpl.this.initialResumeToken());
            }

            @Override
            public ReadOperation<BatchCursor<TDocument>> asReadOperation() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ChangeStreamIterable<TResult> startAtOperationTime(BsonTimestamp startAtOperationTime) {
        this.startAtOperationTime = (BsonTimestamp)Assertions.notNull((String)"startAtOperationTime", (Object)startAtOperationTime);
        return this;
    }

    @Override
    public ChangeStreamIterableImpl<TResult> startAfter(BsonDocument startAfter) {
        this.startAfter = (BsonDocument)Assertions.notNull((String)"startAfter", (Object)startAfter);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> comment(@Nullable String comment) {
        this.comment = comment == null ? null : new BsonString(comment);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> showExpandedEvents(boolean showExpandedEvents) {
        this.showExpandedEvents = showExpandedEvents;
        return this;
    }

    @Override
    public MongoCursor<ChangeStreamDocument<TResult>> iterator() {
        return this.cursor();
    }

    @Override
    public MongoChangeStreamCursor<ChangeStreamDocument<TResult>> cursor() {
        return new MongoChangeStreamCursorImpl<ChangeStreamDocument<TResult>>(this.execute(), this.codec, this.initialResumeToken());
    }

    @Override
    @Nullable
    public ChangeStreamDocument<TResult> first() {
        try (MongoCursor cursor = this.cursor();){
            if (!cursor.hasNext()) {
                ChangeStreamDocument<TResult> changeStreamDocument = null;
                return changeStreamDocument;
            }
            ChangeStreamDocument changeStreamDocument = (ChangeStreamDocument)cursor.next();
            return changeStreamDocument;
        }
    }

    @Override
    public ReadOperation<BatchCursor<ChangeStreamDocument<TResult>>> asReadOperation() {
        throw new UnsupportedOperationException();
    }

    private ReadOperation<BatchCursor<RawBsonDocument>> createChangeStreamOperation() {
        return new ChangeStreamOperation(this.namespace, this.fullDocument, this.fullDocumentBeforeChange, this.createBsonDocumentList(this.pipeline), (Decoder)new RawBsonDocumentCodec(), this.changeStreamLevel).batchSize(this.getBatchSize()).collation(this.collation).comment(this.comment).maxAwaitTime(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS).resumeAfter(this.resumeToken).startAtOperationTime(this.startAtOperationTime).startAfter(this.startAfter).showExpandedEvents(this.showExpandedEvents).retryReads(this.getRetryReads());
    }

    private List<BsonDocument> createBsonDocumentList(List<? extends Bson> pipeline) {
        ArrayList<BsonDocument> aggregateList = new ArrayList<BsonDocument>(pipeline.size());
        for (Bson bson : pipeline) {
            if (bson == null) {
                throw new IllegalArgumentException("pipeline cannot contain a null value");
            }
            aggregateList.add(bson.toBsonDocument(BsonDocument.class, this.codecRegistry));
        }
        return aggregateList;
    }

    private BatchCursor<RawBsonDocument> execute() {
        return this.getExecutor().execute(this.createChangeStreamOperation(), this.getReadPreference(), this.getReadConcern(), this.getClientSession());
    }

    private BsonDocument initialResumeToken() {
        return this.startAfter != null ? this.startAfter : this.resumeToken;
    }
}

