/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.ChangeStreamPipeline;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.FieldSelector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.function.Predicates;
import io.debezium.util.Collect;
import java.util.Set;
import java.util.function.Predicate;

public final class Filters {
    private final FilterConfig config;
    private final Predicate<String> databaseFilter;
    private final Predicate<CollectionId> collectionFilter;
    private final FieldSelector fieldSelector;

    public Filters(Configuration configuration) {
        CollectionId signalDataCollectionId;
        this.config = new FilterConfig(configuration);
        String dbIncludeList = this.config.getDbIncludeList();
        String dbExcludeList = this.config.getDbExcludeList();
        this.databaseFilter = dbIncludeList != null ? Predicates.includes((String)dbIncludeList) : (dbExcludeList != null ? Predicates.excludes((String)dbExcludeList) : db -> true);
        String collectionIncludeList = this.config.getCollectionIncludeList();
        String collectionExcludeList = this.config.getCollectionExcludeList();
        Predicate collectionFilter = collectionIncludeList != null ? Predicates.includes((String)collectionIncludeList, CollectionId::namespace) : (collectionExcludeList != null ? Predicates.excludes((String)collectionExcludeList, CollectionId::namespace) : id -> true);
        Predicate<CollectionId> isNotBuiltIn = this::isNotBuiltIn;
        Predicate<CollectionId> finalCollectionFilter = isNotBuiltIn.and(collectionFilter);
        String signalDataCollection = this.config.getSignalDataCollection();
        if (signalDataCollection != null && !finalCollectionFilter.test(signalDataCollectionId = CollectionId.parse("UNUSED", signalDataCollection))) {
            Predicate signalDataCollectionPredicate = Predicates.includes((String)signalDataCollectionId.namespace(), CollectionId::namespace);
            finalCollectionFilter = finalCollectionFilter.or(signalDataCollectionPredicate);
        }
        this.collectionFilter = finalCollectionFilter;
        this.fieldSelector = FieldSelector.builder().excludeFields(this.config.getFieldExcludeList()).renameFields(this.config.getFieldRenames()).build();
    }

    public Predicate<String> databaseFilter() {
        return this.databaseFilter;
    }

    public Predicate<CollectionId> collectionFilter() {
        return this.collectionFilter;
    }

    public FieldSelector.FieldFilter fieldFilterFor(CollectionId id) {
        return this.fieldSelector.fieldFilterFor(id);
    }

    private boolean isNotBuiltIn(CollectionId id) {
        return !this.config.getBuiltInDbNames().contains(id.dbName());
    }

    public FilterConfig getConfig() {
        return this.config;
    }

    public static class FilterConfig {
        private static final Set<String> BUILT_IN_DB_NAMES = Collect.unmodifiableSet((Object[])new String[]{"local", "admin", "config"});
        private final String dbIncludeList;
        private final String dbExcludeList;
        private final String collectionIncludeList;
        private final String collectionExcludeList;
        private final String fieldRenames;
        private final String fieldExcludeList;
        private final String signalDataCollection;
        private final ChangeStreamPipeline userPipeline;

        public FilterConfig(Configuration config) {
            this.dbIncludeList = FilterConfig.resolveString(config, MongoDbConnectorConfig.DATABASE_INCLUDE_LIST);
            this.dbExcludeList = FilterConfig.resolveString(config, MongoDbConnectorConfig.DATABASE_EXCLUDE_LIST);
            this.collectionIncludeList = FilterConfig.resolveString(config, MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST);
            this.collectionExcludeList = FilterConfig.resolveString(config, MongoDbConnectorConfig.COLLECTION_EXCLUDE_LIST);
            this.fieldRenames = FilterConfig.resolveString(config, MongoDbConnectorConfig.FIELD_RENAMES);
            this.fieldExcludeList = FilterConfig.resolveString(config, MongoDbConnectorConfig.FIELD_EXCLUDE_LIST);
            this.signalDataCollection = FilterConfig.resolveString(config, MongoDbConnectorConfig.SIGNAL_DATA_COLLECTION);
            this.userPipeline = FilterConfig.resolveChangeStreamPipeline(config, MongoDbConnectorConfig.CURSOR_PIPELINE);
        }

        public String getDbIncludeList() {
            return this.dbIncludeList;
        }

        public String getDbExcludeList() {
            return this.dbExcludeList;
        }

        public String getCollectionIncludeList() {
            return this.collectionIncludeList;
        }

        public String getCollectionExcludeList() {
            return this.collectionExcludeList;
        }

        public String getFieldRenames() {
            return this.fieldRenames;
        }

        public String getFieldExcludeList() {
            return this.fieldExcludeList;
        }

        public String getSignalDataCollection() {
            return this.signalDataCollection;
        }

        public Set<String> getBuiltInDbNames() {
            return BUILT_IN_DB_NAMES;
        }

        public ChangeStreamPipeline getUserPipeline() {
            return this.userPipeline;
        }

        private static String resolveString(Configuration config, Field key) {
            return FilterConfig.normalize(config.getString(key));
        }

        private static ChangeStreamPipeline resolveChangeStreamPipeline(Configuration config, Field field) {
            String text = config.getString(field);
            return new ChangeStreamPipeline(text);
        }

        private static String normalize(String text) {
            if (text == null) {
                return null;
            }
            if ((text = text.trim()).isEmpty()) {
                return null;
            }
            return text;
        }
    }
}

