/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoSocketOpenException;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoIterable;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import io.debezium.connector.mongodb.MongoUtil;
import io.debezium.util.Collect;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class MongoUtilTest {
    @Test
    public void shouldGetClusterDescription() {
        ClusterDescription expectedClusterDescription = new ClusterDescription(ClusterConnectionMode.MULTIPLE, ClusterType.REPLICA_SET, List.of());
        MongoClient client = (MongoClient)Mockito.mock(MongoClient.class);
        Mockito.when((Object)client.getClusterDescription()).thenReturn((Object)expectedClusterDescription);
        ClusterDescription actualDescription = MongoUtil.clusterDescription((MongoClient)client);
        Assertions.assertThat((Object)actualDescription).isEqualTo((Object)expectedClusterDescription);
    }

    @Test
    public void shouldGetClusterDescriptionAfterForcedConnection() {
        ClusterDescription unknwonClusterDescription = new ClusterDescription(ClusterConnectionMode.MULTIPLE, ClusterType.UNKNOWN, List.of());
        ClusterDescription expectedClusterDescription = new ClusterDescription(ClusterConnectionMode.MULTIPLE, ClusterType.REPLICA_SET, List.of());
        MongoIterable iterable = (MongoIterable)Mockito.mock(MongoIterable.class);
        Mockito.when((Object)((String)iterable.first())).thenReturn((Object)"name");
        MongoClient client = (MongoClient)Mockito.mock(MongoClient.class);
        Mockito.when((Object)client.getClusterDescription()).thenReturn((Object)unknwonClusterDescription, (Object[])new ClusterDescription[]{expectedClusterDescription});
        Mockito.when((Object)client.listDatabaseNames()).thenReturn((Object)iterable);
        ClusterDescription actualDescription = MongoUtil.clusterDescription((MongoClient)client);
        Assertions.assertThat((Object)actualDescription).isEqualTo((Object)expectedClusterDescription);
    }

    @Test
    public void shouldGetReplicaSetName() {
        List rsNames = Collect.arrayListOf(null, (Object[])new String[]{"rs0", "rs1"});
        List addresses = Collect.arrayListOf((Object)new ServerAddress("host0"), (Object[])new ServerAddress[]{new ServerAddress("host1"), new ServerAddress("host2")});
        List<ServerDescription> serverDescriptions = List.of(ServerDescription.builder().address((ServerAddress)addresses.get(0)).state(ServerConnectionState.CONNECTING).exception((Throwable)new MongoSocketOpenException("can't connect", (ServerAddress)addresses.get(0))).build(), ServerDescription.builder().address((ServerAddress)addresses.get(1)).state(ServerConnectionState.CONNECTED).setName((String)rsNames.get(1)).build(), ServerDescription.builder().address((ServerAddress)addresses.get(2)).state(ServerConnectionState.CONNECTED).setName((String)rsNames.get(2)).build());
        ClusterDescription clusterDescription = new ClusterDescription(ClusterConnectionMode.MULTIPLE, ClusterType.REPLICA_SET, serverDescriptions);
        Optional actualRsName = MongoUtil.replicaSetName((ClusterDescription)clusterDescription);
        Assertions.assertThat((Optional)actualRsName).hasValue((Object)((String)rsNames.get(1)));
    }

    @Test
    public void shouldNotGetReplicaSetName() {
        ServerAddress address = new ServerAddress("host0");
        List<ServerDescription> serverDescriptions = List.of(ServerDescription.builder().address(address).state(ServerConnectionState.CONNECTING).exception((Throwable)new MongoSocketOpenException("can't connect", address)).build());
        ClusterDescription clusterDescription = new ClusterDescription(ClusterConnectionMode.MULTIPLE, ClusterType.REPLICA_SET, serverDescriptions);
        Optional actualRsName = MongoUtil.replicaSetName((ClusterDescription)clusterDescription);
        Assertions.assertThat((Optional)actualRsName).isEmpty();
    }
}

