/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms.UpdateOperators;

import com.mongodb.client.MongoClient;
import io.debezium.connector.mongodb.transforms.AbstractExtractNewDocumentStateTestIT;
import io.debezium.embedded.AbstractConnectorTest;
import java.util.List;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.conversions.Bson;

abstract class AbstractExtractNewDocumentStateUpdateOperatorsTestIT
extends AbstractExtractNewDocumentStateTestIT {
    AbstractExtractNewDocumentStateUpdateOperatorsTestIT() {
    }

    @Override
    protected String getCollectionName() {
        return "update_operators";
    }

    SourceRecord executeSimpleUpdateOperation(String updateDocument) throws InterruptedException {
        try (MongoClient client = this.connect();){
            this.createInsertItemDefault(client, 1);
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic(this.topicName())).hasSize(1);
        try (MongoClient client = this.connect();){
            this.createUpdateOneItem(client, 1, updateDocument);
        }
        return this.getUpdateRecord();
    }

    private void createInsertItemDefault(MongoClient client, int id) {
        client.getDatabase("transform_operations").getCollection(this.getCollectionName()).insertOne((Object)Document.parse((String)("{'_id': " + id + ",'dataStr': 'hello','dataInt': 123,'dataLong': 80000000000,'dataBoolean': true,'dataByte': -1,'dataArrayOfStr': ['a','c','e'],'nested': {'dataStr': 'hello','dataInt': 123,'dataLong': 80000000000,'dataBoolean': true,'dataByte': -1}}")));
    }

    private void createUpdateOneItem(MongoClient client, int id, String document) {
        client.getDatabase("transform_operations").getCollection(this.getCollectionName()).updateOne((Bson)Document.parse((String)String.format("{'_id' : %d}", id)), (Bson)Document.parse((String)document));
    }
}

