/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.InsertOneOptions;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.AbstractMongoConnectorIT;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.connector.mongodb.connection.ConnectionContext;
import io.debezium.data.Envelope;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.testing.testcontainers.MongoDbDeployment;
import io.debezium.util.IoUtil;
import io.debezium.util.Testing;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class MongoDbConnectorWithConnectionStringIT
extends AbstractMongoConnectorIT {
    private Configuration getConfig(String connectionString, boolean ssl) {
        Properties properties = TestHelper.getConfiguration((MongoDbDeployment)mongo).asProperties();
        properties.remove(MongoDbConnectorConfig.HOSTS.name());
        return ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.from((Properties)properties).edit().with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, "dbit.*")).with(CommonConnectorConfig.TOPIC_PREFIX, "mongo")).with(MongoDbConnectorConfig.CONNECTION_STRING, connectionString)).with(MongoDbConnectorConfig.SSL_ENABLED, ssl)).build();
    }

    @Test
    public void shouldMaskCredentials() {
        this.config = this.getConfig("mongodb://admin:password@localhost:27017/", false);
        ConnectionContext connectionContext = new ConnectionContext(this.config);
        String masked = connectionContext.maskedConnectionSeed();
        Assertions.assertThat((String)masked).isEqualTo((Object)"mongodb://***:***@localhost:27017/");
    }

    @Test
    public void shouldConsumeAllEventsFromSingleReplicaWithMongoProtocol() throws InterruptedException {
        this.shouldConsumeAllEventsFromDatabase(mongo.getConnectionString(), false);
    }

    @Test
    public void shouldConsumeAllEventsFromSingleReplicaWithMongoSrvProtocol() throws InterruptedException {
        String connectionString = System.getProperty("mongodb.connection.string");
        Assume.assumeThat((Object)connectionString, (Matcher)Matchers.notNullValue());
        this.shouldConsumeAllEventsFromDatabase(connectionString, true);
    }

    public void shouldConsumeAllEventsFromDatabase(String connectionString, boolean ssl) throws InterruptedException {
        Document doc;
        MongoCollection coll;
        MongoDatabase db1;
        this.config = this.getConfig(connectionString, ssl);
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase((MongoDbDeployment)mongo, "dbit");
        this.storeDocuments("dbit", "simpletons", "simple_objects.json");
        this.storeDocuments("dbit", "restaurants", "restaurants1.json");
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(12);
        records.topics().forEach(System.out::println);
        Assertions.assertThat((int)records.recordsForTopic("mongo.dbit.simpletons").size()).isEqualTo(6);
        Assertions.assertThat((int)records.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(6);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        AtomicBoolean foundLast = new AtomicBoolean(false);
        records.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyFromInitialSync((SourceRecord)record, foundLast);
            this.verifyReadOperation((SourceRecord)record);
        });
        Assertions.assertThat((boolean)foundLast.get()).isTrue();
        this.storeDocuments("dbit", "restaurants", "restaurants2.json");
        AbstractConnectorTest.SourceRecords records2 = this.consumeRecordsByTopic(4);
        Assertions.assertThat((int)records2.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(4);
        Assertions.assertThat((int)records2.topics().size()).isEqualTo(1);
        records2.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
        });
        this.stopConnector();
        this.storeDocuments("dbit", "restaurants", "restaurants3.json");
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records3 = this.consumeRecordsByTopic(5);
        Assertions.assertThat((int)records3.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(5);
        Assertions.assertThat((int)records3.topics().size()).isEqualTo(1);
        records3.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
        });
        this.storeDocuments("dbit", "restaurants", "restaurants4.json");
        AbstractConnectorTest.SourceRecords records4 = this.consumeRecordsByTopic(8);
        Assertions.assertThat((int)records4.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(8);
        Assertions.assertThat((int)records4.topics().size()).isEqualTo(1);
        records4.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
        });
        AtomicReference<String> id = new AtomicReference<String>();
        try (MongoClient client = this.connect();){
            db1 = client.getDatabase("dbit");
            coll = db1.getCollection("arbitrary");
            coll.drop();
            doc = Document.parse((String)"{\"a\": 1, \"b\": 2}");
            InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
            coll.insertOne((Object)doc, insertOptions);
            doc = (Document)coll.find().first();
            Testing.debug((Object)("Document: " + doc));
            id.set(doc.getObjectId((Object)"_id").toString());
            Testing.debug((Object)("Document ID: " + (String)id.get()));
        }
        client = this.connect();
        try {
            db1 = client.getDatabase("dbit");
            coll = db1.getCollection("arbitrary");
            doc = (Document)coll.find().first();
            Testing.debug((Object)("Document: " + doc));
            Document filter = Document.parse((String)"{\"a\": 1}");
            Document operation = Document.parse((String)"{ \"$set\": { \"b\": 10 } }");
            coll.updateOne((Bson)filter, (Bson)operation);
            doc = (Document)coll.find().first();
            Testing.debug((Object)("Document: " + doc));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        AbstractConnectorTest.SourceRecords insertAndUpdate = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)insertAndUpdate.recordsForTopic("mongo.dbit.arbitrary").size()).isEqualTo(2);
        Assertions.assertThat((int)insertAndUpdate.topics().size()).isEqualTo(1);
        records4.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
        });
        SourceRecord insertRecord = (SourceRecord)insertAndUpdate.allRecordsInOrder().get(0);
        SourceRecord updateRecord = (SourceRecord)insertAndUpdate.allRecordsInOrder().get(1);
        Testing.debug((Object)("Insert event: " + insertRecord));
        Testing.debug((Object)("Update event: " + updateRecord));
        Struct insertKey = (Struct)insertRecord.key();
        Struct updateKey = (Struct)updateRecord.key();
        String insertId = this.toObjectId(insertKey.getString("id")).toString();
        String updateId = this.toObjectId(updateKey.getString("id")).toString();
        Assertions.assertThat((String)insertId).isEqualTo(id.get());
        Assertions.assertThat((String)updateId).isEqualTo(id.get());
        try (MongoClient client = this.connect();){
            MongoDatabase db12 = client.getDatabase("dbit");
            MongoCollection coll2 = db12.getCollection("arbitrary");
            Document filter = Document.parse((String)"{\"a\": 1}");
            coll2.deleteOne((Bson)filter);
        }
        AbstractConnectorTest.SourceRecords delete = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)delete.recordsForTopic("mongo.dbit.arbitrary").size()).isEqualTo(2);
        Assertions.assertThat((int)delete.topics().size()).isEqualTo(1);
        SourceRecord deleteRecord = (SourceRecord)delete.allRecordsInOrder().get(0);
        this.validate(deleteRecord);
        this.verifyNotFromInitialSync(deleteRecord);
        this.verifyDeleteOperation(deleteRecord);
        SourceRecord tombStoneRecord = (SourceRecord)delete.allRecordsInOrder().get(1);
        this.validate(tombStoneRecord);
        Testing.debug((Object)("Delete event: " + deleteRecord));
        Testing.debug((Object)("Tombstone event: " + tombStoneRecord));
        Struct deleteKey = (Struct)deleteRecord.key();
        String deleteId = this.toObjectId(deleteKey.getString("id")).toString();
        Assertions.assertThat((String)deleteId).isEqualTo(id.get());
    }

    protected void verifyFromInitialSync(SourceRecord record, AtomicBoolean foundLast) {
        if (record.sourceOffset().containsKey("initsync")) {
            Assertions.assertThat((boolean)record.sourceOffset().containsKey("initsync")).isTrue();
            Struct value = (Struct)record.value();
            Assertions.assertThat((String)value.getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        } else {
            Assertions.assertThat((boolean)foundLast.getAndSet(true)).isFalse();
            Struct value = (Struct)record.value();
            Assertions.assertThat((String)value.getStruct("source").getString("snapshot")).isEqualTo((Object)"last");
        }
    }

    protected void verifyNotFromInitialSync(SourceRecord record) {
        Assertions.assertThat((boolean)record.sourceOffset().containsKey("initsync")).isFalse();
        Struct value = (Struct)record.value();
        Assertions.assertThat((String)value.getStruct("source").getString("snapshot")).isNull();
    }

    protected void verifyCreateOperation(SourceRecord record) {
        this.verifyOperation(record, Envelope.Operation.CREATE);
    }

    protected void verifyReadOperation(SourceRecord record) {
        this.verifyOperation(record, Envelope.Operation.READ);
    }

    protected void verifyDeleteOperation(SourceRecord record) {
        this.verifyOperation(record, Envelope.Operation.DELETE);
    }

    protected void verifyOperation(SourceRecord record, Envelope.Operation expected) {
        Struct value = (Struct)record.value();
        Assertions.assertThat((String)value.getString("op")).isEqualTo((Object)expected.code());
    }

    @Override
    protected void storeDocuments(String dbName, String collectionName, String pathOnClasspath) {
        try (MongoClient client = this.connect();){
            Testing.debug((Object)("Storing in '" + dbName + "." + collectionName + "' documents loaded from from '" + pathOnClasspath + "'"));
            MongoDatabase db1 = client.getDatabase(dbName);
            MongoCollection coll = db1.getCollection(collectionName);
            coll.drop();
            this.storeDocuments((MongoCollection<Document>)coll, pathOnClasspath);
        }
    }

    @Override
    protected void storeDocuments(MongoCollection<Document> collection, String pathOnClasspath) {
        InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
        this.loadTestDocuments(pathOnClasspath).forEach(doc -> {
            Assertions.assertThat((Map)doc).isNotNull();
            Assertions.assertThat((int)doc.size()).isGreaterThan(0);
            collection.insertOne(doc, insertOptions);
        });
    }

    @Override
    protected List<Document> loadTestDocuments(String pathOnClasspath) {
        ArrayList<Document> results = new ArrayList<Document>();
        try (InputStream stream = Testing.Files.readResourceAsStream((String)pathOnClasspath);){
            Assertions.assertThat((InputStream)stream).isNotNull();
            IoUtil.readLines((InputStream)stream, line -> {
                Document doc = Document.parse((String)line);
                Assertions.assertThat((int)doc.size()).isGreaterThan(0);
                results.add(doc);
            });
        }
        catch (IOException e) {
            Assert.fail((String)("Unable to find or read file '" + pathOnClasspath + "': " + e.getMessage()));
        }
        return results;
    }

    private String formatObjectId(ObjectId objId) {
        return "{\"$oid\": \"" + objId + "\"}";
    }

    private ObjectId toObjectId(String oid) {
        return new ObjectId(oid.substring(10, oid.length() - 2));
    }
}

