/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.TestHelper;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class MongoDbConnectorConfigTest {
    @Test
    public void parseSignallingMessage() {
        Schema schema = new SchemaBuilder(Schema.Type.STRUCT).field("after", Schema.STRING_SCHEMA).build();
        Struct struct = new Struct(schema);
        struct.put("after", (Object)"{\"_id\":\"test-1\",\"type\":\"execute-snapshot\",\"data\":{\"data-collections\":[\"database.collection\"],\"type\":\"incremental\"}}");
        MongoDbConnectorConfig mongoDbConnectorConfig = new MongoDbConnectorConfig(TestHelper.getConfiguration());
        Optional resultOpt = mongoDbConnectorConfig.parseSignallingMessage(struct);
        Assert.assertTrue((boolean)resultOpt.isPresent());
        String[] result = (String[])resultOpt.get();
        Assert.assertEquals((long)3L, (long)result.length);
        Assert.assertEquals((Object)"test-1", (Object)result[0]);
        Assert.assertEquals((Object)"execute-snapshot", (Object)result[1]);
        Assert.assertEquals((Object)"{\"data-collections\": [\"database.collection\"], \"type\": \"incremental\"}", (Object)result[2]);
    }

    @Test
    public void parseCursorPipeline() {
        MongoDbConnectorConfigTest.verifyCursorPipelineValidateError("This is not valid JSON pipeline", "Change stream pipeline JSON is invalid: JSON reader was expecting a value but found 'This'.");
        MongoDbConnectorConfigTest.verifyCursorPipelineValidateError("{$match: {}}", "Change stream pipeline JSON is invalid: Cannot cast org.bson.Document to java.util.List");
        MongoDbConnectorConfigTest.verifyCursorPipelineValidateSuccess(null);
        MongoDbConnectorConfigTest.verifyCursorPipelineValidateSuccess("");
        MongoDbConnectorConfigTest.verifyCursorPipelineValidateSuccess("[]");
        MongoDbConnectorConfigTest.verifyCursorPipelineValidateSuccess("[{$match: {}}]");
        MongoDbConnectorConfigTest.verifyCursorPipelineValidateSuccess("[{\"$match\": { \"$and\": [{\"operationType\": \"insert\"}, {\"fullDocument.eventId\": 1404 }] } }]\n");
    }

    private static void verifyCursorPipelineValidateError(String value, String expectedError) {
        MongoDbConnectorConfigTest.verifyCursorPipelineValidate(value, expectedError, false);
    }

    private static void verifyCursorPipelineValidateSuccess(String value) {
        MongoDbConnectorConfigTest.verifyCursorPipelineValidate(value, null, true);
    }

    private static void verifyCursorPipelineValidate(String value, String expectedError, boolean success) {
        Configuration config = (Configuration)Mockito.mock(Configuration.class);
        Field.ValidationOutput output = (Field.ValidationOutput)Mockito.mock(Field.ValidationOutput.class);
        ArgumentCaptor errorMessage = ArgumentCaptor.forClass(String.class);
        Field field = MongoDbConnectorConfig.CURSOR_PIPELINE;
        BDDMockito.given((Object)config.getString(field)).willReturn((Object)value);
        ((Field.ValidationOutput)Mockito.doNothing().when((Object)output)).accept((Field)ArgumentMatchers.eq((Object)field), ArgumentMatchers.eq((Object)value), (String)errorMessage.capture());
        field.validate(config, output);
        if (success) {
            Assertions.assertThat((List)errorMessage.getAllValues()).isEmpty();
        } else {
            ((ObjectAssert)((ListAssert)Assertions.assertThat((List)errorMessage.getAllValues()).hasSize(1)).element(0)).isEqualTo((Object)expectedError);
        }
    }
}

