/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mongodb.AbstractMongoConnectorIT;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.converters.CloudEventsConverterTest;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.testing.testcontainers.MongoDbDeployment;
import io.debezium.util.Testing;
import java.util.List;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.junit.Test;

public class CloudEventsConverterIT
extends AbstractMongoConnectorIT {
    @Test
    public void testCorrectFormat() throws Exception {
        Testing.Print.enable();
        this.config = ((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration((MongoDbDeployment)mongo).edit().with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, "dbA.c1")).with(MongoDbConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MongoDbConnectorConfig.SnapshotMode.INITIAL)).build();
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase((MongoDbDeployment)mongo, "dbA");
        this.start(MongoDbConnector.class, this.config);
        this.assertConnectorIsRunning();
        CloudEventsConverterIT.waitForSnapshotToBeCompleted("mongodb", "mongo1");
        List<Document> documentsToInsert = this.loadTestDocuments("restaurants1.json");
        this.insertDocuments("dbA", "c1", documentsToInsert.toArray(new Document[0]));
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Closed"));
        this.updateDocument("dbA", "c1", Document.parse((String)"{\"restaurant_id\": \"30075445\"}"), updateObj);
        Thread.sleep(1000L);
        this.deleteDocuments("dbA", "c1", Document.parse((String)"{\"restaurant_id\": \"30075445\"}"));
        int recCount = 8;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(8);
        List c1s = records.recordsForTopic("mongo1.dbA.c1");
        Assertions.assertThat((List)c1s).hasSize(8);
        List insertRecords = c1s.subList(0, 6);
        SourceRecord updateRecord = (SourceRecord)c1s.get(6);
        SourceRecord deleteRecord = (SourceRecord)c1s.get(7);
        for (SourceRecord record : insertRecords) {
            CloudEventsConverterTest.shouldConvertToCloudEventsInJson((SourceRecord)record, (boolean)false);
            CloudEventsConverterTest.shouldConvertToCloudEventsInJsonWithDataAsAvro((SourceRecord)record, (boolean)false);
            CloudEventsConverterTest.shouldConvertToCloudEventsInAvro((SourceRecord)record, (String)"mongodb", (String)"mongo1", (boolean)false);
        }
        CloudEventsConverterTest.shouldConvertToCloudEventsInJson((SourceRecord)deleteRecord, (boolean)false);
        CloudEventsConverterTest.shouldConvertToCloudEventsInAvro((SourceRecord)deleteRecord, (String)"mongodb", (String)"mongo1", (boolean)false);
        CloudEventsConverterTest.shouldConvertToCloudEventsInJson((SourceRecord)updateRecord, (boolean)false);
        CloudEventsConverterTest.shouldConvertToCloudEventsInJsonWithDataAsAvro((SourceRecord)updateRecord, (String)"updateDescription", (boolean)false);
        CloudEventsConverterTest.shouldConvertToCloudEventsInJsonWithDataAsAvro((SourceRecord)updateRecord, (String)"after", (boolean)false);
        CloudEventsConverterTest.shouldConvertToCloudEventsInAvro((SourceRecord)updateRecord, (String)"mongodb", (String)"mongo1", (boolean)false);
        this.stopConnector();
    }
}

