/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.DebeziumException;
import io.debezium.annotation.ThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbChangeEventSourceFactory;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbErrorHandler;
import io.debezium.connector.mongodb.MongoDbEventMetadataProvider;
import io.debezium.connector.mongodb.MongoDbOffsetContext;
import io.debezium.connector.mongodb.MongoDbPartition;
import io.debezium.connector.mongodb.MongoDbSchema;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.connector.mongodb.metrics.MongoDbChangeEventSourceMetricsFactory;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MongoDbConnectorTask
extends BaseSourceTask<MongoDbPartition, MongoDbOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbConnectorTask.class);
    private static final String CONTEXT_NAME = "mongodb-connector-task";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile String taskName;
    private volatile MongoDbTaskContext taskContext;
    private volatile ErrorHandler errorHandler;
    private volatile MongoDbSchema schema;

    public String version() {
        return Module.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeEventSourceCoordinator<MongoDbPartition, MongoDbOffsetContext> start(Configuration config) {
        MongoDbConnectorConfig connectorConfig = new MongoDbConnectorConfig(config);
        SchemaNameAdjuster schemaNameAdjuster = connectorConfig.schemaNameAdjuster();
        this.taskName = "task" + config.getInteger(MongoDbConnectorConfig.TASK_ID);
        this.taskContext = new MongoDbTaskContext(config);
        Schema structSchema = connectorConfig.getSourceInfoStructMaker().schema();
        this.schema = new MongoDbSchema(this.taskContext.filters(), this.taskContext.topicNamingStrategy(), structSchema, schemaNameAdjuster);
        ReplicaSets replicaSets = this.getReplicaSets(connectorConfig);
        MongoDbOffsetContext previousOffset = this.getPreviousOffset(connectorConfig, replicaSets);
        Clock clock = Clock.system();
        LoggingContext.PreviousContext previousLogContext = this.taskContext.configureLoggingContext(this.taskName);
        try {
            this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).maxQueueSizeInBytes(connectorConfig.getMaxQueueSizeInBytes()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
            this.errorHandler = new MongoDbErrorHandler(connectorConfig, this.queue);
            MongoDbEventMetadataProvider metadataProvider = new MongoDbEventMetadataProvider();
            EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)connectorConfig, this.taskContext.topicNamingStrategy(), (DatabaseSchema)this.schema, this.queue, this.taskContext.filters().collectionFilter()::test, DataChangeEvent::new, (EventMetadataProvider)metadataProvider, schemaNameAdjuster);
            ChangeEventSourceCoordinator coordinator = new ChangeEventSourceCoordinator(Offsets.of(Collections.singletonMap(new MongoDbPartition(), previousOffset)), this.errorHandler, MongoDbConnector.class, (CommonConnectorConfig)connectorConfig, (ChangeEventSourceFactory)new MongoDbChangeEventSourceFactory(connectorConfig, this.errorHandler, (EventDispatcher<MongoDbPartition, CollectionId>)dispatcher, clock, replicaSets, this.taskContext, this.schema), (ChangeEventSourceMetricsFactory)new MongoDbChangeEventSourceMetricsFactory(), dispatcher, (DatabaseSchema)this.schema);
            coordinator.start((CdcSourceTaskContext)this.taskContext, this.queue, (EventMetadataProvider)metadataProvider);
            ChangeEventSourceCoordinator changeEventSourceCoordinator = coordinator;
            return changeEventSourceCoordinator;
        }
        finally {
            previousLogContext.restore();
        }
    }

    public List<SourceRecord> doPoll() throws InterruptedException {
        List records = this.queue.poll();
        return records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
    }

    public void doStop() {
        LoggingContext.PreviousContext previousLogContext = this.taskContext.configureLoggingContext(this.taskName);
        try {
            if (this.schema != null) {
                this.schema.close();
            }
        }
        finally {
            previousLogContext.restore();
        }
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return MongoDbConnectorConfig.ALL_FIELDS;
    }

    private MongoDbOffsetContext getPreviousOffset(MongoDbConnectorConfig connectorConfig, ReplicaSets replicaSets) {
        MongoDbOffsetContext.Loader loader = new MongoDbOffsetContext.Loader(connectorConfig, replicaSets);
        Collection<Map<String, String>> partitions = loader.getPartitions();
        Map offsets = this.context.offsetStorageReader().offsets(partitions);
        if (offsets != null && offsets.values().stream().anyMatch(Objects::nonNull)) {
            MongoDbOffsetContext offsetContext = loader.loadOffsets(offsets);
            this.logger.info("Found previous offsets {}", (Object)offsetContext);
            return offsetContext;
        }
        return null;
    }

    private ReplicaSets getReplicaSets(MongoDbConnectorConfig connectorConfig) {
        ReplicaSets replicaSets = connectorConfig.getReplicaSets();
        if (replicaSets.size() == 0) {
            throw new DebeziumException("Unable to start MongoDB connector task since no replica sets were found");
        }
        return replicaSets;
    }

    protected Configuration withMaskedSensitiveOptions(Configuration config) {
        return super.withMaskedSensitiveOptions(config).withMasked(MongoDbConnectorConfig.CONNECTION_STRING.name());
    }
}

