/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.recordemitter;

import io.debezium.connector.mongodb.MongoDbCollectionSchema;
import io.debezium.connector.mongodb.MongoDbPartition;
import io.debezium.data.Envelope;
import io.debezium.pipeline.AbstractChangeRecordEmitter;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.util.Clock;
import org.apache.kafka.connect.data.Struct;
import org.bson.BsonDocument;

public class MongoDbSnapshotRecordEmitter
extends AbstractChangeRecordEmitter<MongoDbPartition, MongoDbCollectionSchema> {
    private final BsonDocument event;

    public MongoDbSnapshotRecordEmitter(MongoDbPartition partition, OffsetContext offsetContext, Clock clock, BsonDocument event) {
        super((Partition)partition, offsetContext, clock);
        this.event = event;
    }

    public Envelope.Operation getOperation() {
        return Envelope.Operation.READ;
    }

    protected void emitReadRecord(ChangeRecordEmitter.Receiver receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        Struct newKey = schema.keyFromDocumentSnapshot(this.event);
        assert (newKey != null);
        Struct value = schema.valueFromDocumentSnapshot(this.event, this.getOperation());
        value.put("source", (Object)this.getOffset().getSourceInfo());
        value.put("op", (Object)this.getOperation().code());
        value.put("ts_ms", (Object)this.getClock().currentTimeAsInstant().toEpochMilli());
        receiver.changeRecord(this.getPartition(), (DataCollectionSchema)schema, this.getOperation(), (Object)newKey, value, this.getOffset(), null);
    }

    protected void emitCreateRecord(ChangeRecordEmitter.Receiver receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected void emitUpdateRecord(ChangeRecordEmitter.Receiver receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected void emitDeleteRecord(ChangeRecordEmitter.Receiver receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        throw new UnsupportedOperationException();
    }
}

