/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.OperationType;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.ResumeTokens;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.data.VerifyRecord;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.assertj.core.api.Assertions;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.types.ObjectId;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SourceInfoTest {
    private static final String REPLICA_SET_NAME = "myReplicaSet";
    private static final String CHANGE_RESUME_TOKEN_DATA = "82635019A0000000012B042C0100296E5A1004AB1154ACACD849A48C61756D70D3B21F463C6F7065726174696F6E54797065003C696E736572740046646F63756D656E744B65790046645F69640064635019A078BE67426D7CF4D2000004";
    private static final BsonDocument CHANGE_RESUME_TOKEN = ResumeTokens.fromData((String)"82635019A0000000012B042C0100296E5A1004AB1154ACACD849A48C61756D70D3B21F463C6F7065726174696F6E54797065003C696E736572740046646F63756D656E744B65790046645F69640064635019A078BE67426D7CF4D2000004");
    private static final BsonTimestamp CHANGE_TIMESTAMP = new BsonTimestamp(1666193824, 1);
    private static final String CURSOR_RESUME_TOKEN_DATA = "8263515EAC000000022B0429296E1404";
    private static final BsonTimestamp CURSOR_TIMESTAMP = new BsonTimestamp(1666277036, 2);
    private static final BsonDocument CURSOR_RESUME_TOKEN = ResumeTokens.fromData((String)"8263515EAC000000022B0429296E1404");
    private SourceInfo source;
    private Map<String, String> partition;

    @Before
    public void beforeEach() {
        this.source = this.createSourceInfo();
    }

    private SourceInfo createSourceInfo() {
        MongoDbConnectorConfig config = new MongoDbConnectorConfig(((Configuration.Builder)Configuration.create().with(CommonConnectorConfig.TOPIC_PREFIX, "serverX")).build());
        return new SourceInfo(config);
    }

    private MongoChangeStreamCursor<ChangeStreamDocument<BsonDocument>> mockEventChangeStreamCursor() {
        MongoChangeStreamCursor cursor = (MongoChangeStreamCursor)Mockito.mock(MongoChangeStreamCursor.class);
        ChangeStreamDocument event = new ChangeStreamDocument(OperationType.INSERT.getValue(), CHANGE_RESUME_TOKEN, BsonDocument.parse((String)"{db: \"test\", coll: \"names\"}"), null, null, null, new BsonDocument("_id", (BsonValue)new BsonObjectId(new ObjectId("635019a078be67426d7cf4d2"))), CHANGE_TIMESTAMP, null, null, null, null, null);
        Mockito.when((Object)cursor.tryNext()).thenReturn((Object)event);
        return cursor;
    }

    private MongoChangeStreamCursor<ChangeStreamDocument<BsonDocument>> mockNoEventChangeStreamCursor() {
        MongoChangeStreamCursor cursor = (MongoChangeStreamCursor)Mockito.mock(MongoChangeStreamCursor.class);
        Mockito.when((Object)cursor.tryNext()).thenReturn(null);
        Mockito.when((Object)cursor.getResumeToken()).thenReturn((Object)CURSOR_RESUME_TOKEN);
        return cursor;
    }

    public void assertSourceInfoContents(SourceInfo source, MongoChangeStreamCursor<ChangeStreamDocument<BsonDocument>> cursor, String resumeTokenData, BsonTimestamp timestamp, String snapshot) {
        if (cursor != null) {
            Assertions.assertThat((boolean)source.hasOffset(REPLICA_SET_NAME)).isEqualTo(false);
            source.initEvent(REPLICA_SET_NAME, cursor);
        }
        this.assertSourceInfoContents(source, cursor != null, resumeTokenData, timestamp, snapshot);
    }

    public void assertSourceInfoContents(SourceInfo source, boolean hasOffset, String resumeTokenData, BsonTimestamp timestamp, String snapshot) {
        Assertions.assertThat((boolean)source.hasOffset(REPLICA_SET_NAME)).isEqualTo(hasOffset);
        Map offset = source.lastOffset(REPLICA_SET_NAME);
        Assertions.assertThat(offset.get("sec")).isEqualTo((Object)timestamp.getTime());
        Assertions.assertThat(offset.get("ord")).isEqualTo((Object)timestamp.getInc());
        String resumeToken = source.lastResumeToken(REPLICA_SET_NAME);
        Assertions.assertThat((String)resumeToken).isEqualTo((Object)resumeTokenData);
        source.collectionEvent(REPLICA_SET_NAME, new CollectionId(REPLICA_SET_NAME, "test", "names"), 0L);
        Struct struct = source.struct();
        Assertions.assertThat((Long)struct.getInt64("ts_ms")).isEqualTo((long)timestamp.getTime() * 1000L);
        Assertions.assertThat((Integer)struct.getInt32("ord")).isEqualTo(timestamp.getInc());
        Assertions.assertThat((String)struct.getString("db")).isEqualTo((Object)"test");
        Assertions.assertThat((String)struct.getString("collection")).isEqualTo((Object)"names");
        Assertions.assertThat((String)struct.getString("rs")).isEqualTo((Object)REPLICA_SET_NAME);
        Assertions.assertThat((String)struct.getString("name")).isEqualTo((Object)"serverX");
        Assertions.assertThat((String)struct.getString("snapshot")).isEqualTo((Object)snapshot);
    }

    @Test
    public void shouldSetAndReturnRecordedOffset() {
        MongoChangeStreamCursor<ChangeStreamDocument<BsonDocument>> cursor = this.mockEventChangeStreamCursor();
        this.assertSourceInfoContents(this.source, cursor, CHANGE_RESUME_TOKEN_DATA, CHANGE_TIMESTAMP, null);
        Map offset = this.source.lastOffset(REPLICA_SET_NAME);
        Map partition = this.source.partition(REPLICA_SET_NAME);
        SourceInfo newSource = this.createSourceInfo();
        newSource.setOffsetFor(partition, offset);
        this.assertSourceInfoContents(newSource, true, CHANGE_RESUME_TOKEN_DATA, CHANGE_TIMESTAMP, null);
    }

    @Test
    public void shouldReturnOffsetForUnusedReplicaName() {
        Assertions.assertThat((boolean)this.source.hasOffset(REPLICA_SET_NAME)).isEqualTo(false);
        this.assertSourceInfoContents(this.source, false, null, new BsonTimestamp(0L), null);
    }

    @Test
    public void shouldReturnRecordedOffsetForUsedReplicaName() {
        MongoChangeStreamCursor<ChangeStreamDocument<BsonDocument>> cursor = this.mockEventChangeStreamCursor();
        this.assertSourceInfoContents(this.source, cursor, CHANGE_RESUME_TOKEN_DATA, CHANGE_TIMESTAMP, null);
    }

    @Test
    public void shouldReturnRecordedOffsetForUsedReplicaNameWithoutEvent() {
        MongoChangeStreamCursor<ChangeStreamDocument<BsonDocument>> cursor = this.mockNoEventChangeStreamCursor();
        this.assertSourceInfoContents(this.source, cursor, CURSOR_RESUME_TOKEN_DATA, CURSOR_TIMESTAMP, null);
    }

    @Test
    public void shouldReturnOffsetForUnusedReplicaNameDuringInitialSync() {
        this.source.startInitialSync(REPLICA_SET_NAME);
        this.assertSourceInfoContents(this.source, false, null, new BsonTimestamp(0L), "true");
    }

    @Test
    public void shouldReturnRecordedOffsetForUsedReplicaNameDuringInitialSync() {
        this.source.startInitialSync(REPLICA_SET_NAME);
        MongoChangeStreamCursor<ChangeStreamDocument<BsonDocument>> cursor = this.mockEventChangeStreamCursor();
        this.assertSourceInfoContents(this.source, cursor, CHANGE_RESUME_TOKEN_DATA, CHANGE_TIMESTAMP, "true");
    }

    @Test
    public void shouldReturnRecordedOffsetForUsedReplicaNameDuringInitialSyncWithoutEvent() {
        this.source.startInitialSync(REPLICA_SET_NAME);
        MongoChangeStreamCursor<ChangeStreamDocument<BsonDocument>> cursor = this.mockNoEventChangeStreamCursor();
        this.assertSourceInfoContents(this.source, cursor, CURSOR_RESUME_TOKEN_DATA, CURSOR_TIMESTAMP, "true");
    }

    @Test
    public void shouldProducePartitionMap() {
        this.partition = this.source.partition(REPLICA_SET_NAME);
        Assertions.assertThat((String)this.partition.get("rs")).isEqualTo((Object)REPLICA_SET_NAME);
        Assertions.assertThat((String)this.partition.get("server_id")).isEqualTo((Object)"serverX");
        Assertions.assertThat((int)this.partition.size()).isEqualTo(2);
    }

    @Test
    public void shouldReturnSamePartitionMapForSameReplicaName() {
        this.partition = this.source.partition(REPLICA_SET_NAME);
        Assertions.assertThat(this.partition).isSameAs((Object)this.source.partition(REPLICA_SET_NAME));
    }

    @Test
    public void versionIsPresent() {
        MongoChangeStreamCursor<ChangeStreamDocument<BsonDocument>> cursor = this.mockEventChangeStreamCursor();
        this.source.initEvent(REPLICA_SET_NAME, cursor);
        Assertions.assertThat((String)this.source.struct().getString("version")).isEqualTo((Object)Module.version());
    }

    @Test
    public void connectorIsPresent() {
        MongoChangeStreamCursor<ChangeStreamDocument<BsonDocument>> cursor = this.mockEventChangeStreamCursor();
        this.source.initEvent(REPLICA_SET_NAME, cursor);
        Assertions.assertThat((String)this.source.struct().getString("connector")).isEqualTo((Object)Module.name());
    }

    @Test
    public void wallTimeIsPresent() {
        MongoChangeStreamCursor<ChangeStreamDocument<BsonDocument>> cursor = this.mockEventChangeStreamCursor();
        this.source.initEvent(REPLICA_SET_NAME, cursor);
        Assertions.assertThat((Long)this.source.struct().getInt64("wallTime")).isNull();
        this.source.collectionEvent(REPLICA_SET_NAME, new CollectionId(REPLICA_SET_NAME, "test", "names"), 10L);
        Assertions.assertThat((Long)this.source.struct().getInt64("wallTime")).isEqualTo(10L);
    }

    @Test
    public void shouldHaveSchemaForSource() {
        Schema schema = this.source.schema();
        Assertions.assertThat((String)schema.name()).isNotEmpty();
        Assertions.assertThat((Integer)schema.version()).isNull();
        Assertions.assertThat((Object)schema.field("name").schema()).isEqualTo((Object)Schema.STRING_SCHEMA);
        Assertions.assertThat((Object)schema.field("rs").schema()).isEqualTo((Object)Schema.STRING_SCHEMA);
        Assertions.assertThat((Object)schema.field("db").schema()).isEqualTo((Object)Schema.STRING_SCHEMA);
        Assertions.assertThat((Object)schema.field("collection").schema()).isEqualTo((Object)Schema.STRING_SCHEMA);
        Assertions.assertThat((Object)schema.field("ts_ms").schema()).isEqualTo((Object)Schema.INT64_SCHEMA);
        Assertions.assertThat((Object)schema.field("ord").schema()).isEqualTo((Object)Schema.INT32_SCHEMA);
        Assertions.assertThat((Object)schema.field("snapshot").schema()).isEqualTo((Object)AbstractSourceInfoStructMaker.SNAPSHOT_RECORD_SCHEMA);
    }

    @Test
    public void schemaIsCorrect() {
        Schema schema = SchemaBuilder.struct().name("io.debezium.connector.mongo.Source").field("version", Schema.STRING_SCHEMA).field("connector", Schema.STRING_SCHEMA).field("name", Schema.STRING_SCHEMA).field("ts_ms", Schema.INT64_SCHEMA).field("snapshot", AbstractSourceInfoStructMaker.SNAPSHOT_RECORD_SCHEMA).field("db", Schema.STRING_SCHEMA).field("sequence", Schema.OPTIONAL_STRING_SCHEMA).field("rs", Schema.STRING_SCHEMA).field("collection", Schema.STRING_SCHEMA).field("ord", Schema.INT32_SCHEMA).field("lsid", Schema.OPTIONAL_STRING_SCHEMA).field("txnNumber", Schema.OPTIONAL_INT64_SCHEMA).field("wallTime", Schema.OPTIONAL_INT64_SCHEMA).build();
        VerifyRecord.assertConnectSchemasAreEqual(null, (Schema)this.source.schema(), (Schema)schema);
    }
}

