/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.connector.mongodb.ChangeStreamPipeline;
import io.debezium.connector.mongodb.ChangeStreamPipelineFactory;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.data.Envelope;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.bson.conversions.Bson;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ChangeStreamPipelineFactoryTest {
    @InjectMocks
    private ChangeStreamPipelineFactory sut;
    @Mock
    private MongoDbConnectorConfig connectorConfig;
    @Mock
    private Filters.FilterConfig filterConfig;

    @Test
    public void testCreate() {
        BDDMockito.given((Object)this.connectorConfig.getSkippedOperations()).willReturn(EnumSet.of(Envelope.Operation.TRUNCATE));
        BDDMockito.given((Object)this.filterConfig.getCollectionIncludeList()).willReturn((Object)"dbit.*");
        BDDMockito.given((Object)this.filterConfig.getUserPipeline()).willReturn((Object)new ChangeStreamPipeline("[{\"$match\": { \"$and\": [{\"operationType\": \"insert\"}, {\"fullDocument.eventId\": 1404 }] } }]"));
        ChangeStreamPipeline pipeline = this.sut.create();
        ChangeStreamPipelineFactoryTest.assertPipelineStagesEquals(pipeline.getStages(), "{\n  \"$addFields\" : {\n    \"namespace\" : {\n      \"$concat\" : [ \"$ns.db\", \".\", \"$ns.coll\" ]\n    }\n  }\n}", "{\n  \"$match\" : {\n    \"$and\" : [ {\n      \"namespace\" : {\n        \"$regularExpression\" : {\n          \"pattern\" : \"dbit.*\",\n          \"options\" : \"i\"\n        }\n      }\n    }, {\n      \"operationType\" : {\n        \"$in\" : [ \"insert\", \"update\", \"replace\", \"delete\" ]\n      }\n    } ]\n  }\n}", "{\n  \"$addFields\" : {\n    \"namespace\" : \"$$REMOVE\"\n  }\n}", "{\n  \"$match\" : {\n    \"$and\" : [ {\n      \"operationType\" : \"insert\"\n    }, {\n      \"fullDocument.eventId\" : 1404\n    } ]\n  }\n}");
    }

    private static void assertPipelineStagesEquals(List<? extends Bson> stages, String ... expectedStageJsons) {
        Assertions.assertThat(stages).hasSameSizeAs((Object)expectedStageJsons);
        for (int i = 0; i < stages.size(); ++i) {
            String expectedStageJson = expectedStageJsons[i];
            ((ObjectAssert)Assertions.assertThat(stages).element(i)).satisfies(stage -> ChangeStreamPipelineFactoryTest.assertJsonEquals(stage.toBsonDocument().toJson(), expectedStageJson));
        }
    }

    private static void assertJsonEquals(String actual, String expected) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            actual = mapper.readTree(actual).toPrettyString();
            expected = mapper.readTree(expected).toPrettyString();
            Assertions.assertThat((String)actual).isEqualTo((Object)expected);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

