/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.InsertOneOptions;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.connector.mongodb.junit.MongoDbDatabaseProvider;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.testing.testcontainers.MongoDbDeployment;
import io.debezium.testing.testcontainers.MongoDbReplicaSet;
import io.debezium.testing.testcontainers.util.DockerUtils;
import io.debezium.util.Collect;
import io.debezium.util.IoUtil;
import io.debezium.util.Testing;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class AbstractMongoConnectorIT
extends AbstractConnectorTest {
    private static final int TASK_ID = 0;
    protected static MongoDbReplicaSet mongo;
    protected Configuration config;
    protected MongoDbTaskContext context;
    protected LogInterceptor logInterceptor;

    @Before
    public void beforeEach() {
        Testing.Debug.disable();
        Testing.Print.disable();
        this.stopConnector();
        this.initializeConnectorTestFramework();
    }

    @After
    public void afterEach() {
        this.stopConnector();
    }

    @BeforeClass
    public static void beforeAll() {
        DockerUtils.enableFakeDnsIfRequired();
        mongo = MongoDbDatabaseProvider.mongoDbReplicaSet();
        mongo.start();
    }

    @AfterClass
    public static void afterAll() {
        DockerUtils.disableFakeDns();
        if (mongo != null) {
            mongo.stop();
        }
    }

    protected List<Document> loadTestDocuments(String pathOnClasspath) {
        ArrayList<Document> documents = new ArrayList<Document>();
        try (InputStream stream = Testing.Files.readResourceAsStream((String)pathOnClasspath);){
            Assertions.assertThat((InputStream)stream).isNotNull();
            IoUtil.readLines((InputStream)stream, line -> {
                Document document = Document.parse((String)line);
                Assertions.assertThat((int)document.size()).isGreaterThan(0);
                documents.add(document);
            });
        }
        catch (IOException e) {
            Assert.fail((String)("Unable to find or read file '" + pathOnClasspath + "': " + e.getMessage()));
        }
        return documents;
    }

    protected void dropAndInsertDocuments(String dbName, String collectionName, Document ... documents) {
        if (documents.length == 0) {
            return;
        }
        try (MongoClient client = TestHelper.connect((MongoDbDeployment)mongo);){
            Testing.debug((Object)("Storing in '" + dbName + "." + collectionName + "' document"));
            MongoDatabase db = client.getDatabase(dbName);
            MongoCollection collection = db.getCollection(collectionName);
            collection.drop();
            for (Document document : documents) {
                InsertOneOptions options = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
                Assertions.assertThat((Map)document).isNotNull();
                Assertions.assertThat((int)document.size()).isGreaterThan(0);
                collection.insertOne((Object)document, options);
            }
        }
    }

    protected void insertDocuments(String dbName, String collectionName, Document ... documents) {
        if (documents.length == 0) {
            return;
        }
        try (MongoClient client = TestHelper.connect((MongoDbDeployment)mongo);){
            Testing.debug((Object)("Storing in '" + dbName + "." + collectionName + "' document"));
            MongoDatabase db = client.getDatabase(dbName);
            MongoCollection collection = db.getCollection(collectionName);
            for (Document document : documents) {
                InsertOneOptions options = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
                Assertions.assertThat((Map)document).isNotNull();
                Assertions.assertThat((int)document.size()).isGreaterThan(0);
                collection.insertOne((Object)document, options);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertDocumentsInTx(String dbName, String collectionName, Document ... documents) {
        Assertions.assertThat((boolean)TestHelper.transactionsSupported()).isTrue();
        try (MongoClient client = TestHelper.connect((MongoDbDeployment)mongo);){
            Testing.debug((Object)("Storing documents in '" + dbName + "." + collectionName + "'"));
            MongoDatabase db = client.getDatabase(dbName);
            if (!AbstractMongoConnectorIT.collectionExists(db, collectionName)) {
                db.createCollection(collectionName);
            }
            MongoCollection collection = db.getCollection(collectionName);
            try (ClientSession session = client.startSession();){
                session.startTransaction();
                InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
                for (Document document : documents) {
                    Assertions.assertThat((Map)document).isNotNull();
                    Assertions.assertThat((int)document.size()).isGreaterThan(0);
                    collection.insertOne(session, (Object)document, insertOptions);
                }
                session.commitTransaction();
            }
        }
    }

    protected void updateDocument(String dbName, String collectionName, Document filter, Document document) {
        try (MongoClient client = TestHelper.connect((MongoDbDeployment)mongo);){
            Testing.debug((Object)("Updating document with filter '" + filter + "' in '" + dbName + "." + collectionName + "'"));
            MongoDatabase db = client.getDatabase(dbName);
            MongoCollection collection = db.getCollection(collectionName);
            collection.updateOne((Bson)filter, (Bson)document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDocumentsInTx(String dbName, String collectionName, Document filter, Document document) {
        Assertions.assertThat((boolean)TestHelper.transactionsSupported()).isTrue();
        try (MongoClient client = this.connect();){
            Testing.debug((Object)("Updating document with filter '" + filter + "' in '" + dbName + "." + collectionName + "'"));
            MongoDatabase db = client.getDatabase(dbName);
            MongoCollection collection = db.getCollection(collectionName);
            try (ClientSession session = client.startSession();){
                session.startTransaction();
                collection.updateMany((Bson)filter, (Bson)document);
                session.commitTransaction();
            }
        }
    }

    protected void deleteDocuments(String dbName, String collectionName, Document filter) {
        try (MongoClient client = this.connect();){
            MongoDatabase db = client.getDatabase(dbName);
            MongoCollection coll = db.getCollection(collectionName);
            coll.deleteOne((Bson)filter);
        }
    }

    protected MongoClient connect() {
        return MongoClients.create((String)mongo.getConnectionString());
    }

    private static boolean collectionExists(MongoDatabase database, String collectionName) {
        MongoIterable collections = database.listCollectionNames();
        MongoCursor cursor = collections.cursor();
        while (cursor.hasNext()) {
            if (!collectionName.equalsIgnoreCase((String)cursor.next())) continue;
            return true;
        }
        return false;
    }

    protected void storeDocuments(String dbName, String collectionName, String pathOnClasspath) {
        try (MongoClient client = this.connect();){
            Testing.debug((Object)("Storing in '" + dbName + "." + collectionName + "' documents loaded from from '" + pathOnClasspath + "'"));
            MongoDatabase db1 = client.getDatabase(dbName);
            MongoCollection coll = db1.getCollection(collectionName);
            coll.drop();
            this.storeDocuments((MongoCollection<Document>)coll, pathOnClasspath);
        }
    }

    protected void storeDocuments(MongoCollection<Document> collection, String pathOnClasspath) {
        InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
        this.loadTestDocuments(pathOnClasspath).forEach(doc -> {
            Assertions.assertThat((Map)doc).isNotNull();
            Assertions.assertThat((int)doc.size()).isGreaterThan(0);
            collection.insertOne(doc, insertOptions);
        });
    }

    public static ObjectName getSnapshotMetricsObjectName(String connector, String server) {
        return AbstractMongoConnectorIT.getSnapshotMetricsObjectName(connector, server, 0);
    }

    public static ObjectName getSnapshotMetricsObjectName(String connector, String server, int taskId) {
        return AbstractMongoConnectorIT.getMetricsObjectNameWithTags(connector, Collect.linkMapOf((Object)"context", (Object)"snapshot", (Object)"server", (Object)server, (Object)"task", (Object)String.valueOf(taskId)));
    }

    public static void waitForSnapshotToBeCompleted(String connector, String server) {
        AbstractMongoConnectorIT.waitForSnapshotToBeCompleted(AbstractMongoConnectorIT.getSnapshotMetricsObjectName(connector, server));
    }

    public static void waitForSnapshotToBeCompleted(String connector, String server, int taskId) {
        AbstractMongoConnectorIT.waitForSnapshotToBeCompleted(AbstractMongoConnectorIT.getSnapshotMetricsObjectName(connector, server, taskId));
    }

    public static ObjectName getStreamingMetricsObjectName(String connector, String server) {
        return AbstractMongoConnectorIT.getStreamingMetricsObjectName(connector, server, 0);
    }

    public static ObjectName getStreamingMetricsObjectName(String connector, String server, int taskId) {
        return AbstractMongoConnectorIT.getMetricsObjectNameWithTags(connector, Collect.linkMapOf((Object)"context", (Object)AbstractMongoConnectorIT.getStreamingNamespace(), (Object)"server", (Object)server, (Object)"task", (Object)String.valueOf(taskId)));
    }

    public static void waitForStreamingRunning(String connector, String server) {
        AbstractMongoConnectorIT.waitForStreamingRunning(AbstractMongoConnectorIT.getStreamingMetricsObjectName(connector, server));
    }

    public static void waitForStreamingRunning(String connector, String server, int taskId) {
        AbstractMongoConnectorIT.waitForStreamingRunning(AbstractMongoConnectorIT.getStreamingMetricsObjectName(connector, server, taskId));
    }

    private static void waitForSnapshotToBeCompleted(ObjectName objectName) {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        Awaitility.await().alias("Streaming was not started on time").pollInterval(100L, TimeUnit.MILLISECONDS).atMost((long)(AbstractMongoConnectorIT.waitTimeForRecords() * 30), TimeUnit.SECONDS).ignoreException(InstanceNotFoundException.class).until(() -> (boolean)((Boolean)mbeanServer.getAttribute(objectName, "SnapshotCompleted")));
    }

    private static void waitForStreamingRunning(ObjectName objectName) {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        Awaitility.await().alias("Streaming was not started on time").pollInterval(100L, TimeUnit.MILLISECONDS).atMost((long)(AbstractMongoConnectorIT.waitTimeForRecords() * 30), TimeUnit.SECONDS).ignoreException(InstanceNotFoundException.class).until(() -> (boolean)((Boolean)mbeanServer.getAttribute(objectName, "Connected")));
    }

    private static ObjectName getMetricsObjectNameWithTags(String connector, Map<String, String> tags) {
        try {
            return new ObjectName("debezium." + connector + ":type=connector-metrics," + tags.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(",")));
        }
        catch (MalformedObjectNameException e2) {
            throw new RuntimeException(e2);
        }
    }
}

