/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.signal;

import io.debezium.document.Document;
import io.debezium.pipeline.signal.Signal;
import io.debezium.pipeline.spi.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSnapshotSignal<P extends Partition>
implements Signal.Action<P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSnapshotSignal.class);
    protected static final String FIELD_DATA_COLLECTIONS = "data-collections";
    protected static final String FIELD_TYPE = "type";
    protected static final String FIELD_ADDITIONAL_CONDITION = "additional-condition";
    protected static final String FIELD_SURROGATE_KEY = "surrogate-key";

    public static SnapshotType getSnapshotType(Document data) {
        String typeStr = data.getString(FIELD_TYPE);
        SnapshotType type = SnapshotType.INCREMENTAL;
        if (typeStr != null) {
            for (SnapshotType option : SnapshotType.values()) {
                if (!option.name().equalsIgnoreCase(typeStr)) continue;
                return option;
            }
            LOGGER.warn("Detected an unexpected snapshot type '{}'", (Object)typeStr);
            return null;
        }
        return type;
    }

    public static enum SnapshotType {
        INCREMENTAL;

    }
}

