/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.MongoClient;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.model.changestream.FullDocumentBeforeChange;
import io.debezium.connector.mongodb.ChangeStreamPipeline;
import io.debezium.connector.mongodb.ChangeStreamPipelineFactory;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbIncrementalSnapshotContext;
import io.debezium.connector.mongodb.MongoDbOffsetContext;
import io.debezium.connector.mongodb.MongoDbPartition;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.ReplicaSetOffsetContext;
import io.debezium.connector.mongodb.ReplicaSetPartition;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.connector.mongodb.connection.ConnectionContext;
import io.debezium.connector.mongodb.connection.MongoDbConnection;
import io.debezium.connector.mongodb.connection.ReplicaSet;
import io.debezium.connector.mongodb.recordemitter.MongoDbChangeRecordEmitter;
import io.debezium.function.BlockingConsumer;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import io.debezium.util.Threads;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbStreamingChangeEventSource
implements StreamingChangeEventSource<MongoDbPartition, MongoDbOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbStreamingChangeEventSource.class);
    private final MongoDbConnectorConfig connectorConfig;
    private final EventDispatcher<MongoDbPartition, CollectionId> dispatcher;
    private final ErrorHandler errorHandler;
    private final Clock clock;
    private final ConnectionContext connectionContext;
    private final ReplicaSets replicaSets;
    private final MongoDbTaskContext taskContext;
    private final MongoDbConnection.ChangeEventSourceConnectionFactory connections;

    public MongoDbStreamingChangeEventSource(MongoDbConnectorConfig connectorConfig, MongoDbTaskContext taskContext, MongoDbConnection.ChangeEventSourceConnectionFactory connections, ReplicaSets replicaSets, EventDispatcher<MongoDbPartition, CollectionId> dispatcher, ErrorHandler errorHandler, Clock clock) {
        this.connectorConfig = connectorConfig;
        this.connectionContext = taskContext.getConnectionContext();
        this.dispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.clock = clock;
        this.replicaSets = replicaSets;
        this.taskContext = taskContext;
        this.connections = connections;
    }

    public void execute(ChangeEventSource.ChangeEventSourceContext context, MongoDbPartition partition, MongoDbOffsetContext offsetContext) throws InterruptedException {
        List<ReplicaSet> validReplicaSets = this.replicaSets.all();
        if (offsetContext == null) {
            offsetContext = this.emptyOffsets(this.connectorConfig);
        }
        if (validReplicaSets.size() == 1) {
            this.streamChangesForReplicaSet(context, partition, validReplicaSets.get(0), offsetContext);
        } else if (validReplicaSets.size() > 1) {
            this.streamChangesForReplicaSets(context, partition, validReplicaSets, offsetContext);
        }
    }

    private void streamChangesForReplicaSet(ChangeEventSource.ChangeEventSourceContext context, MongoDbPartition partition, ReplicaSet replicaSet, MongoDbOffsetContext offsetContext) {
        try (MongoDbConnection mongo = this.connections.get(replicaSet, partition);){
            mongo.execute("read from change stream on '" + replicaSet + "'", (BlockingConsumer<MongoClient>)((BlockingConsumer)client -> this.readChangeStream((MongoClient)client, replicaSet, context, offsetContext)));
        }
        catch (Throwable t) {
            LOGGER.error("Streaming for replica set {} failed", (Object)replicaSet.replicaSetName(), (Object)t);
            this.errorHandler.setProducerThrowable(t);
        }
    }

    private void streamChangesForReplicaSets(ChangeEventSource.ChangeEventSourceContext context, MongoDbPartition partition, List<ReplicaSet> replicaSets, MongoDbOffsetContext offsetContext) {
        int threads = replicaSets.size();
        ExecutorService executor = Threads.newFixedThreadPool(MongoDbConnector.class, (String)this.taskContext.serverName(), (String)"replicator-streaming", (int)threads);
        CountDownLatch latch = new CountDownLatch(threads);
        LOGGER.info("Starting {} thread(s) to stream changes for replica sets: {}", (Object)threads, replicaSets);
        replicaSets.forEach(replicaSet -> executor.submit(() -> {
            try {
                this.streamChangesForReplicaSet(context, partition, (ReplicaSet)replicaSet, offsetContext);
            }
            finally {
                latch.countDown();
            }
        }));
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        executor.shutdown();
    }

    private void readChangeStream(MongoClient client, ReplicaSet replicaSet, ChangeEventSource.ChangeEventSourceContext context, MongoDbOffsetContext offsetContext) {
        ReplicaSetPartition rsPartition = offsetContext.getReplicaSetPartition(replicaSet);
        ReplicaSetOffsetContext rsOffsetContext = offsetContext.getReplicaSetOffsetContext(replicaSet);
        LOGGER.info("Reading change stream for '{}'", (Object)replicaSet);
        ChangeStreamPipeline pipeline = new ChangeStreamPipelineFactory(rsOffsetContext, this.taskContext.getConnectorConfig(), this.taskContext.filters().getConfig()).create();
        ChangeStreamIterable rsChangeStream = client.watch(pipeline.getStages(), BsonDocument.class);
        if (this.taskContext.getCaptureMode().isFullUpdate()) {
            rsChangeStream.fullDocument(FullDocument.UPDATE_LOOKUP);
        }
        if (this.taskContext.getCaptureMode().isIncludePreImage()) {
            rsChangeStream.fullDocumentBeforeChange(FullDocumentBeforeChange.WHEN_AVAILABLE);
        }
        if (rsOffsetContext.lastResumeToken() != null) {
            LOGGER.info("Resuming streaming from token '{}'", (Object)rsOffsetContext.lastResumeToken());
            BsonDocument doc = new BsonDocument();
            doc.put("_data", (BsonValue)new BsonString(rsOffsetContext.lastResumeToken()));
            rsChangeStream.resumeAfter(doc);
        }
        if (this.connectorConfig.getCursorMaxAwaitTime() > 0) {
            rsChangeStream.maxAwaitTime((long)this.connectorConfig.getCursorMaxAwaitTime(), TimeUnit.MILLISECONDS);
        }
        try (MongoChangeStreamCursor cursor = rsChangeStream.cursor();){
            Metronome pause = Metronome.sleeper((Duration)Duration.ofMillis(500L), (Clock)this.clock);
            while (context.isRunning()) {
                ChangeStreamDocument event = (ChangeStreamDocument)cursor.tryNext();
                if (event != null) {
                    LOGGER.trace("Arrived Change Stream event: {}", (Object)event);
                    rsOffsetContext.changeStreamEvent((ChangeStreamDocument<BsonDocument>)event);
                    CollectionId collectionId = new CollectionId(replicaSet.replicaSetName(), event.getNamespace().getDatabaseName(), event.getNamespace().getCollectionName());
                    try {
                        this.dispatcher.dispatchDataChangeEvent((Partition)rsPartition, (DataCollectionId)collectionId, (ChangeRecordEmitter)new MongoDbChangeRecordEmitter(rsPartition, (OffsetContext)rsOffsetContext, this.clock, (ChangeStreamDocument<BsonDocument>)event));
                        continue;
                    }
                    catch (Exception e) {
                        this.errorHandler.setProducerThrowable((Throwable)e);
                        if (cursor != null) {
                            cursor.close();
                        }
                        return;
                    }
                }
                try {
                    if (cursor.getResumeToken() != null) {
                        rsOffsetContext.noEvent(cursor);
                        this.dispatcher.dispatchHeartbeatEvent((Partition)rsPartition, (OffsetContext)rsOffsetContext);
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.info("Replicator thread is interrupted");
                    Thread.currentThread().interrupt();
                    if (cursor != null) {
                        cursor.close();
                    }
                    return;
                }
                try {
                    pause.pause();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    protected MongoDbOffsetContext emptyOffsets(MongoDbConnectorConfig connectorConfig) {
        LOGGER.info("Initializing empty Offset context");
        return new MongoDbOffsetContext(new SourceInfo(connectorConfig), new TransactionContext(), new MongoDbIncrementalSnapshotContext<CollectionId>(false));
    }
}

