/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.MongoSocketException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerApi;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.ServerType;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.event.ServerHeartbeatFailedEvent;
import com.mongodb.event.ServerHeartbeatStartedEvent;
import com.mongodb.event.ServerHeartbeatSucceededEvent;
import com.mongodb.event.ServerMonitorListener;
import com.mongodb.internal.connection.ClusterClock;
import com.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.CommandMessage;
import com.mongodb.internal.connection.DescriptionHelper;
import com.mongodb.internal.connection.ExponentiallyWeightedMovingAverage;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.InternalConnectionFactory;
import com.mongodb.internal.connection.MessageSettings;
import com.mongodb.internal.connection.NoOpSessionContext;
import com.mongodb.internal.connection.SdamServerDescriptionManager;
import com.mongodb.internal.connection.ServerDescriptionHelper;
import com.mongodb.internal.connection.ServerMonitor;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.internal.inject.Provider;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.types.ObjectId;

@ThreadSafe
class DefaultServerMonitor
implements ServerMonitor {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private final ServerId serverId;
    private final ServerMonitorListener serverMonitorListener;
    private final ClusterClock clusterClock;
    private final Provider<SdamServerDescriptionManager> sdamProvider;
    private final InternalConnectionFactory internalConnectionFactory;
    private final ClusterConnectionMode clusterConnectionMode;
    @Nullable
    private final ServerApi serverApi;
    private final ServerSettings serverSettings;
    private final ServerMonitorRunnable monitor;
    private final Thread monitorThread;
    private final RoundTripTimeRunnable roundTripTimeMonitor;
    private final ExponentiallyWeightedMovingAverage averageRoundTripTime = new ExponentiallyWeightedMovingAverage(0.2);
    private final Thread roundTripTimeMonitorThread;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private volatile boolean isClosed;

    DefaultServerMonitor(ServerId serverId, ServerSettings serverSettings, ClusterClock clusterClock, InternalConnectionFactory internalConnectionFactory, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, Provider<SdamServerDescriptionManager> sdamProvider) {
        this.serverSettings = Assertions.notNull("serverSettings", serverSettings);
        this.serverId = Assertions.notNull("serverId", serverId);
        this.serverMonitorListener = EventListenerHelper.singleServerMonitorListener(serverSettings);
        this.clusterClock = Assertions.notNull("clusterClock", clusterClock);
        this.internalConnectionFactory = Assertions.notNull("internalConnectionFactory", internalConnectionFactory);
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.serverApi = serverApi;
        this.sdamProvider = sdamProvider;
        this.monitor = new ServerMonitorRunnable();
        this.monitorThread = new Thread((Runnable)this.monitor, "cluster-" + this.serverId.getClusterId() + "-" + this.serverId.getAddress());
        this.monitorThread.setDaemon(true);
        this.roundTripTimeMonitor = new RoundTripTimeRunnable();
        this.roundTripTimeMonitorThread = new Thread((Runnable)this.roundTripTimeMonitor, "cluster-rtt-" + this.serverId.getClusterId() + "-" + this.serverId.getAddress());
        this.roundTripTimeMonitorThread.setDaemon(true);
        this.isClosed = false;
    }

    @Override
    public void start() {
        this.monitorThread.start();
        this.roundTripTimeMonitorThread.start();
    }

    @Override
    public void connect() {
        this.lock.lock();
        try {
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.monitor.close();
        this.monitorThread.interrupt();
        this.roundTripTimeMonitor.close();
        this.roundTripTimeMonitorThread.interrupt();
    }

    @Override
    public void cancelCurrentCheck() {
        this.monitor.cancelCurrentCheck();
    }

    static boolean shouldLogStageChange(ServerDescription previous, ServerDescription current) {
        String thatExceptionMessage;
        Class<?> thatExceptionClass;
        if (previous.isOk() != current.isOk()) {
            return true;
        }
        if (!previous.getAddress().equals(current.getAddress())) {
            return true;
        }
        if (previous.getCanonicalAddress() != null ? !previous.getCanonicalAddress().equals(current.getCanonicalAddress()) : current.getCanonicalAddress() != null) {
            return true;
        }
        if (!previous.getHosts().equals(current.getHosts())) {
            return true;
        }
        if (!previous.getArbiters().equals(current.getArbiters())) {
            return true;
        }
        if (!previous.getPassives().equals(current.getPassives())) {
            return true;
        }
        if (previous.getPrimary() != null ? !previous.getPrimary().equals(current.getPrimary()) : current.getPrimary() != null) {
            return true;
        }
        if (previous.getSetName() != null ? !previous.getSetName().equals(current.getSetName()) : current.getSetName() != null) {
            return true;
        }
        if (previous.getState() != current.getState()) {
            return true;
        }
        if (!previous.getTagSet().equals(current.getTagSet())) {
            return true;
        }
        if (previous.getType() != current.getType()) {
            return true;
        }
        if (previous.getMaxWireVersion() != current.getMaxWireVersion()) {
            return true;
        }
        ObjectId previousElectionId = previous.getElectionId();
        if (previousElectionId != null ? !previousElectionId.equals((Object)current.getElectionId()) : current.getElectionId() != null) {
            return true;
        }
        Integer setVersion = previous.getSetVersion();
        if (setVersion != null ? !setVersion.equals(current.getSetVersion()) : current.getSetVersion() != null) {
            return true;
        }
        Throwable previousException = previous.getException();
        Throwable currentException = current.getException();
        Class<?> thisExceptionClass = previousException != null ? previousException.getClass() : null;
        Class<?> clazz = thatExceptionClass = currentException != null ? currentException.getClass() : null;
        if (!Objects.equals(thisExceptionClass, thatExceptionClass)) {
            return true;
        }
        String thisExceptionMessage = previousException != null ? previousException.getMessage() : null;
        String string = thatExceptionMessage = currentException != null ? currentException.getMessage() : null;
        return !Objects.equals(thisExceptionMessage, thatExceptionMessage);
    }

    private void waitForNext() {
        try {
            Thread.sleep(this.serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String getHandshakeCommandName(ServerDescription serverDescription) {
        return serverDescription.isHelloOk() ? "hello" : "isMaster";
    }

    class ServerMonitorRunnable
    implements Runnable {
        private volatile InternalConnection connection = null;
        private volatile boolean currentCheckCancelled;

        ServerMonitorRunnable() {
        }

        void close() {
            InternalConnection connection = this.connection;
            if (connection != null) {
                connection.close();
            }
        }

        @Override
        public void run() {
            ServerDescription currentServerDescription = ServerDescriptionHelper.unknownConnectingServerDescription(DefaultServerMonitor.this.serverId, null);
            try {
                while (!DefaultServerMonitor.this.isClosed) {
                    ServerDescription previousServerDescription = currentServerDescription;
                    currentServerDescription = this.lookupServerDescription(currentServerDescription);
                    if (DefaultServerMonitor.this.isClosed) continue;
                    if (this.currentCheckCancelled) {
                        this.waitForNext();
                        this.currentCheckCancelled = false;
                        continue;
                    }
                    this.logStateChange(previousServerDescription, currentServerDescription);
                    ((SdamServerDescriptionManager)DefaultServerMonitor.this.sdamProvider.get()).update(currentServerDescription);
                    if ((this.connection == null || this.shouldStreamResponses(currentServerDescription)) && currentServerDescription.getTopologyVersion() != null || this.connection != null && this.connection.hasMoreToCome() || currentServerDescription.getException() instanceof MongoSocketException && previousServerDescription.getType() != ServerType.UNKNOWN) continue;
                    this.waitForNext();
                }
            }
            finally {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServerDescription lookupServerDescription(ServerDescription currentServerDescription) {
            try {
                if (this.connection == null || this.connection.isClosed()) {
                    this.currentCheckCancelled = false;
                    InternalConnection newConnection = DefaultServerMonitor.this.internalConnectionFactory.create(DefaultServerMonitor.this.serverId);
                    newConnection.open();
                    this.connection = newConnection;
                    DefaultServerMonitor.this.averageRoundTripTime.addSample(this.connection.getInitialServerDescription().getRoundTripTimeNanos());
                    return this.connection.getInitialServerDescription();
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Checking status of %s", DefaultServerMonitor.this.serverId.getAddress()));
                }
                DefaultServerMonitor.this.serverMonitorListener.serverHearbeatStarted(new ServerHeartbeatStartedEvent(this.connection.getDescription().getConnectionId()));
                long start = System.nanoTime();
                try {
                    ClusterClockAdvancingSessionContext sessionContext = new ClusterClockAdvancingSessionContext(NoOpSessionContext.INSTANCE, DefaultServerMonitor.this.clusterClock);
                    if (!this.connection.hasMoreToCome()) {
                        BsonDocument helloDocument = new BsonDocument(DefaultServerMonitor.this.getHandshakeCommandName(currentServerDescription), (BsonValue)new BsonInt32(1)).append("helloOk", (BsonValue)BsonBoolean.TRUE);
                        if (this.shouldStreamResponses(currentServerDescription)) {
                            helloDocument.append("topologyVersion", (BsonValue)currentServerDescription.getTopologyVersion().asDocument());
                            helloDocument.append("maxAwaitTimeMS", (BsonValue)new BsonInt64(DefaultServerMonitor.this.serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS)));
                        }
                        this.connection.send(this.createCommandMessage(helloDocument, this.connection, currentServerDescription), new BsonDocumentCodec(), sessionContext);
                    }
                    BsonDocument helloResult = this.shouldStreamResponses(currentServerDescription) ? (BsonDocument)this.connection.receive(new BsonDocumentCodec(), sessionContext, Math.toIntExact(DefaultServerMonitor.this.serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS))) : (BsonDocument)this.connection.receive(new BsonDocumentCodec(), sessionContext);
                    long elapsedTimeNanos = System.nanoTime() - start;
                    DefaultServerMonitor.this.serverMonitorListener.serverHeartbeatSucceeded(new ServerHeartbeatSucceededEvent(this.connection.getDescription().getConnectionId(), helloResult, elapsedTimeNanos, currentServerDescription.getTopologyVersion() != null));
                    return DescriptionHelper.createServerDescription(DefaultServerMonitor.this.serverId.getAddress(), helloResult, DefaultServerMonitor.this.averageRoundTripTime.getAverage());
                }
                catch (Exception e) {
                    DefaultServerMonitor.this.serverMonitorListener.serverHeartbeatFailed(new ServerHeartbeatFailedEvent(this.connection.getDescription().getConnectionId(), System.nanoTime() - start, currentServerDescription.getTopologyVersion() != null, e));
                    throw e;
                }
            }
            catch (Throwable t) {
                InternalConnection localConnection;
                DefaultServerMonitor.this.averageRoundTripTime.reset();
                ServerMonitorRunnable serverMonitorRunnable = this;
                synchronized (serverMonitorRunnable) {
                    localConnection = this.connection;
                    this.connection = null;
                }
                if (localConnection != null) {
                    localConnection.close();
                }
                return ServerDescriptionHelper.unknownConnectingServerDescription(DefaultServerMonitor.this.serverId, t);
            }
        }

        private boolean shouldStreamResponses(ServerDescription currentServerDescription) {
            return currentServerDescription.getTopologyVersion() != null && this.connection.supportsAdditionalTimeout();
        }

        private CommandMessage createCommandMessage(BsonDocument command, InternalConnection connection, ServerDescription currentServerDescription) {
            return new CommandMessage(new MongoNamespace("admin", "$cmd"), command, new NoOpFieldNameValidator(), ReadPreference.primary(), MessageSettings.builder().maxWireVersion(connection.getDescription().getMaxWireVersion()).build(), this.shouldStreamResponses(currentServerDescription), DefaultServerMonitor.this.clusterConnectionMode, DefaultServerMonitor.this.serverApi);
        }

        private void logStateChange(ServerDescription previousServerDescription, ServerDescription currentServerDescription) {
            if (DefaultServerMonitor.shouldLogStageChange(previousServerDescription, currentServerDescription)) {
                if (currentServerDescription.getException() != null) {
                    LOGGER.info(String.format("Exception in monitor thread while connecting to server %s", DefaultServerMonitor.this.serverId.getAddress()), currentServerDescription.getException());
                } else {
                    LOGGER.info(String.format("Monitor thread successfully connected to server with description %s", currentServerDescription));
                }
            }
        }

        private void waitForNext() {
            try {
                long millisToSleep;
                long minimumNanosToWait;
                long timeWaiting;
                long timeRemaining = this.waitForSignalOrTimeout();
                if (timeRemaining > 0L && (timeWaiting = DefaultServerMonitor.this.serverSettings.getHeartbeatFrequency(TimeUnit.NANOSECONDS) - timeRemaining) < (minimumNanosToWait = DefaultServerMonitor.this.serverSettings.getMinHeartbeatFrequency(TimeUnit.NANOSECONDS)) && (millisToSleep = TimeUnit.MILLISECONDS.convert(minimumNanosToWait - timeWaiting, TimeUnit.NANOSECONDS)) > 0L) {
                    Thread.sleep(millisToSleep);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private long waitForSignalOrTimeout() throws InterruptedException {
            DefaultServerMonitor.this.lock.lock();
            try {
                long l = DefaultServerMonitor.this.condition.awaitNanos(DefaultServerMonitor.this.serverSettings.getHeartbeatFrequency(TimeUnit.NANOSECONDS));
                return l;
            }
            finally {
                DefaultServerMonitor.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelCurrentCheck() {
            InternalConnection localConnection = null;
            ServerMonitorRunnable serverMonitorRunnable = this;
            synchronized (serverMonitorRunnable) {
                if (this.connection != null && !this.currentCheckCancelled) {
                    localConnection = this.connection;
                    this.currentCheckCancelled = true;
                }
            }
            if (localConnection != null) {
                localConnection.close();
            }
        }
    }

    private class RoundTripTimeRunnable
    implements Runnable {
        private volatile InternalConnection connection = null;

        private RoundTripTimeRunnable() {
        }

        void close() {
            InternalConnection connection = this.connection;
            if (connection != null) {
                connection.close();
            }
        }

        @Override
        public void run() {
            try {
                while (!DefaultServerMonitor.this.isClosed) {
                    block9: {
                        try {
                            if (this.connection == null) {
                                this.initialize();
                            } else {
                                this.pingServer(this.connection);
                            }
                        }
                        catch (Throwable t) {
                            if (this.connection == null) break block9;
                            this.connection.close();
                            this.connection = null;
                        }
                    }
                    DefaultServerMonitor.this.waitForNext();
                }
            }
            finally {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
        }

        private void initialize() {
            this.connection = null;
            this.connection = DefaultServerMonitor.this.internalConnectionFactory.create(DefaultServerMonitor.this.serverId);
            this.connection.open();
            DefaultServerMonitor.this.averageRoundTripTime.addSample(this.connection.getInitialServerDescription().getRoundTripTimeNanos());
        }

        private void pingServer(InternalConnection connection) {
            long start = System.nanoTime();
            CommandHelper.executeCommand("admin", new BsonDocument(DefaultServerMonitor.this.getHandshakeCommandName(connection.getInitialServerDescription()), (BsonValue)new BsonInt32(1)), DefaultServerMonitor.this.clusterClock, DefaultServerMonitor.this.clusterConnectionMode, DefaultServerMonitor.this.serverApi, connection);
            long elapsedTimeNanos = System.nanoTime() - start;
            DefaultServerMonitor.this.averageRoundTripTime.addSample(elapsedTimeNanos);
        }
    }
}

