/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.connection;

import com.mongodb.ConnectionString;
import com.mongodb.ReadPreference;
import com.mongodb.client.MongoClient;
import io.debezium.DebeziumException;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoUtil;
import io.debezium.connector.mongodb.connection.ConnectionStrings;
import io.debezium.connector.mongodb.connection.MongoDbClientFactory;
import io.debezium.connector.mongodb.connection.ReplicaSet;
import io.debezium.function.BlockingConsumer;
import io.debezium.function.BlockingFunction;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public final class MongoDbConnection
implements AutoCloseable {
    private static final Duration PAUSE_AFTER_ERROR = Duration.ofMillis(500L);
    public static ErrorHandler DEFAULT_ERROR_HANDLER = (desc, error) -> {
        throw new DebeziumException("Error while attempting to " + desc, error);
    };
    private final Filters filters;
    private final ErrorHandler errorHandler;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final String name;
    private final Supplier<MongoClient> connectionSupplier;

    protected MongoDbConnection(ReplicaSet replicaSet, ReadPreference readPreference, MongoDbClientFactory clientFactory, Filters filters, ErrorHandler errorHandler) {
        this.name = replicaSet.replicaSetName();
        this.connectionSupplier = () -> clientFactory.client(replicaSet, readPreference);
        this.filters = filters;
        this.errorHandler = errorHandler;
    }

    protected MongoDbConnection(ConnectionString connectionString, MongoDbClientFactory clientFactory, Filters filters) {
        this.name = ConnectionStrings.mask(connectionString.getConnectionString());
        this.connectionSupplier = () -> clientFactory.client(connectionString);
        this.filters = filters;
        this.errorHandler = DEFAULT_ERROR_HANDLER;
    }

    public void execute(String desc, BlockingConsumer<MongoClient> operation) throws InterruptedException {
        this.execute(desc, client -> {
            operation.accept(client);
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(String desc, BlockingFunction<MongoClient, T> operation) throws InterruptedException {
        Metronome errorMetronome = Metronome.sleeper((Duration)PAUSE_AFTER_ERROR, (Clock)Clock.SYSTEM);
        while (true) {
            try (MongoClient client = this.connectionSupplier.get();){
                Object object = operation.apply((Object)client);
                return (T)object;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable t) {
                this.errorHandler.onError(desc, t);
                if (!this.isRunning()) {
                    throw new DebeziumException("Operation failed and MongoDB connection to '" + this.name + "' termination requested", t);
                }
                errorMetronome.pause();
                continue;
            }
            break;
        }
    }

    public Set<String> databaseNames() throws InterruptedException {
        return (Set)this.execute("get database names", client -> {
            HashSet databaseNames = new HashSet();
            MongoUtil.forEachDatabaseName(client, dbName -> {
                if (this.filters.databaseFilter().test((String)dbName)) {
                    databaseNames.add(dbName);
                }
            });
            return databaseNames;
        });
    }

    public List<CollectionId> collections() throws InterruptedException {
        return (List)this.execute("get collections in databases", client -> {
            ArrayList collections = new ArrayList();
            Set<String> databaseNames = this.databaseNames();
            for (String dbName : databaseNames) {
                MongoUtil.forEachCollectionNameInDatabase(client, dbName, collectionName -> {
                    CollectionId collectionId = new CollectionId(this.name, dbName, (String)collectionName);
                    if (this.filters.collectionFilter().test(collectionId)) {
                        collections.add(collectionId);
                    }
                });
            }
            return collections;
        });
    }

    private boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void close() {
        this.running.set(false);
    }

    @FunctionalInterface
    public static interface ErrorHandler {
        public void onError(String var1, Throwable var2);
    }
}

