/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.util.HexConverter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;

public final class ResumeTokens {
    public static BsonTimestamp getTimestamp(BsonDocument resumeToken) {
        BsonValue data = ResumeTokens.getData(resumeToken);
        byte[] dataBytes = ResumeTokens.getDataBytes(data);
        ByteBuffer dataBuffer = ByteBuffer.wrap(dataBytes).order(ByteOrder.BIG_ENDIAN);
        int canonicalType = dataBuffer.get() & 0xFF;
        if (canonicalType != 130) {
            throw new IllegalArgumentException("Expected canonical type equal to 130, but found " + canonicalType);
        }
        long timestampAsLong = dataBuffer.asLongBuffer().get();
        return new BsonTimestamp(timestampAsLong);
    }

    public static BsonValue getData(BsonDocument resumeToken) {
        if (!resumeToken.containsKey((Object)"_data")) {
            throw new IllegalArgumentException("Expected _data field in resume token");
        }
        return resumeToken.get((Object)"_data");
    }

    private static byte[] getDataBytes(BsonValue data) {
        if (data.isString()) {
            String hexString = data.asString().getValue();
            return HexConverter.convertFromHex((String)hexString);
        }
        if (data.isBinary()) {
            return data.asBinary().getData();
        }
        throw new IllegalArgumentException("Expected binary or string for _data field in resume token but found " + data.getBsonType());
    }

    private ResumeTokens() {
        throw new AssertionError((Object)(this.getClass().getName() + " should not be instantiated"));
    }
}

