/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.connection.ClusterConnectionMode;
import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.MongoUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@ThreadSafe
public class MongoClients {
    private final Map<ServerAddress, MongoClient> directConnections = new ConcurrentHashMap<ServerAddress, MongoClient>();
    private final Map<List<ServerAddress>, MongoClient> connections = new ConcurrentHashMap<List<ServerAddress>, MongoClient>();
    private final Map<ConnectionString, MongoClient> stringConnections = new ConcurrentHashMap<ConnectionString, MongoClient>();
    private final Supplier<MongoClientSettings.Builder> settingsSupplier;

    public static Builder create() {
        return new Builder();
    }

    protected static Supplier<MongoClientSettings.Builder> createSettingsSupplier(MongoClientSettings settings) {
        return () -> MongoClientSettings.builder((MongoClientSettings)settings);
    }

    private MongoClients(MongoClientSettings.Builder settings) {
        this.settingsSupplier = MongoClients.createSettingsSupplier(settings.build());
    }

    protected MongoClientSettings.Builder settings() {
        return this.settingsSupplier.get();
    }

    public void clear() {
        this.directConnections.values().forEach(MongoClient::close);
        this.connections.values().forEach(MongoClient::close);
        this.stringConnections.values().forEach(MongoClient::close);
        this.directConnections.clear();
        this.connections.clear();
        this.stringConnections.clear();
    }

    public MongoClient clientFor(String addressString) {
        return this.clientFor(MongoUtil.parseAddress(addressString));
    }

    public MongoClient clientFor(ServerAddress address) {
        return this.directConnections.computeIfAbsent(address, this::directConnection);
    }

    public MongoClient clientForMembers(String addressList) {
        return this.clientForMembers(MongoUtil.parseAddresses(addressList));
    }

    public MongoClient clientForMembers(ConnectionString connectionString) {
        return this.stringConnections.computeIfAbsent(connectionString, this::connection);
    }

    public MongoClient clientForMembers(List<ServerAddress> seedAddresses) {
        return this.connections.computeIfAbsent(seedAddresses, this::connection);
    }

    protected MongoClient directConnection(ServerAddress address) {
        MongoClientSettings.Builder settings = this.settings().applyToClusterSettings(builder -> builder.hosts(Collections.singletonList(address)));
        return com.mongodb.client.MongoClients.create((MongoClientSettings)settings.build());
    }

    protected MongoClient connection(List<ServerAddress> addresses) {
        MongoClientSettings.Builder settings = this.settings().applyToClusterSettings(builder -> builder.hosts(addresses));
        if (addresses.size() > 1) {
            settings.applyToClusterSettings(builder -> builder.mode(ClusterConnectionMode.MULTIPLE));
        }
        return com.mongodb.client.MongoClients.create((MongoClientSettings)settings.build());
    }

    protected MongoClient connection(ConnectionString connectionString) {
        MongoClientSettings.Builder settings = this.settings().applyConnectionString(connectionString);
        return com.mongodb.client.MongoClients.create((MongoClientSettings)settings.build());
    }

    public static class Builder {
        private final MongoClientSettings.Builder settingsBuilder = MongoClientSettings.builder();

        public Builder withCredential(MongoCredential credential) {
            if (credential != null) {
                this.settingsBuilder.credential(credential);
            }
            return this;
        }

        public MongoClientSettings.Builder settings() {
            return this.settingsBuilder;
        }

        public MongoClients build() {
            return new MongoClients(this.settingsBuilder);
        }
    }
}

