/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.ReadPreference;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.debezium.DebeziumException;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.DisconnectEvent;
import io.debezium.connector.mongodb.MongoDbChangeSnapshotOplogRecordEmitter;
import io.debezium.connector.mongodb.MongoDbCollectionSchema;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbPartition;
import io.debezium.connector.mongodb.MongoDbSchema;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.ReplicaSetOffsetContext;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.function.BlockingConsumer;
import io.debezium.pipeline.ConnectorEvent;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MongoDbIncrementalSnapshotChangeEventSource
implements IncrementalSnapshotChangeEventSource<MongoDbPartition, CollectionId> {
    private static final String DOCUMENT_ID = "_id";
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbIncrementalSnapshotChangeEventSource.class);
    private static final String AUTHORIZATION_FAILURE_MESSAGE = "Command failed with error 13";
    private final MongoDbConnectorConfig connectorConfig;
    private final Clock clock;
    private final MongoDbSchema collectionSchema;
    private final SnapshotProgressListener<MongoDbPartition> progressListener;
    private final DataChangeEventListener<MongoDbPartition> dataListener;
    private long totalRowsScanned = 0L;
    private final ReplicaSets replicaSets;
    private final ConnectionContext connectionContext;
    private final MongoDbTaskContext taskContext;
    private MongoDbCollectionSchema currentCollection;
    protected EventDispatcher<MongoDbPartition, CollectionId> dispatcher;
    protected IncrementalSnapshotContext<CollectionId> context = null;
    protected final Map<Struct, Object[]> window = new LinkedHashMap<Struct, Object[]>();
    private ConnectionContext.MongoPreferredNode primary;
    private ConnectionContext.MongoPreferredNode secondary;
    private CollectionId signallingCollectionId;

    public MongoDbIncrementalSnapshotChangeEventSource(MongoDbConnectorConfig config, MongoDbTaskContext taskContext, ReplicaSets replicaSets, EventDispatcher<MongoDbPartition, CollectionId> dispatcher, MongoDbSchema collectionSchema, Clock clock, SnapshotProgressListener<MongoDbPartition> progressListener, DataChangeEventListener<MongoDbPartition> dataChangeEventListener) {
        this.connectorConfig = config;
        this.replicaSets = replicaSets;
        this.taskContext = taskContext;
        this.connectionContext = taskContext.getConnectionContext();
        this.dispatcher = dispatcher;
        this.collectionSchema = collectionSchema;
        this.clock = clock;
        this.progressListener = progressListener;
        this.dataListener = dataChangeEventListener;
        this.signallingCollectionId = this.connectorConfig.getSignalingDataCollectionId() == null ? null : CollectionId.parse("UNUSED", this.connectorConfig.getSignalingDataCollectionId());
    }

    public void closeWindow(MongoDbPartition partition, String id, OffsetContext offsetContext) throws InterruptedException {
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (!this.context.closeWindow(id)) {
            return;
        }
        this.sendWindowEvents(partition, offsetContext);
        this.readChunk(partition);
    }

    public void pauseSnapshot(MongoDbPartition partition, OffsetContext offsetContext) throws InterruptedException {
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (this.context.snapshotRunning() && !this.context.isSnapshotPaused()) {
            this.context.pauseSnapshot();
            this.progressListener.snapshotPaused((Partition)partition);
        }
    }

    public void resumeSnapshot(MongoDbPartition partition, OffsetContext offsetContext) throws InterruptedException {
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (this.context.snapshotRunning() && this.context.isSnapshotPaused()) {
            this.context.resumeSnapshot();
            this.progressListener.snapshotResumed((Partition)partition);
            this.window.clear();
            this.context.revertChunk();
            this.readChunk(partition);
        }
    }

    protected String getSignalCollectionName(String dataCollectionId) {
        return dataCollectionId;
    }

    protected void sendWindowEvents(MongoDbPartition partition, OffsetContext offsetContext) throws InterruptedException {
        LOGGER.debug("Sending {} events from window buffer", (Object)this.window.size());
        offsetContext.incrementalSnapshotEvents();
        for (Object[] row : this.window.values()) {
            this.sendEvent(partition, this.dispatcher, offsetContext, row);
        }
        offsetContext.postSnapshotCompletion();
        this.window.clear();
    }

    protected void sendEvent(MongoDbPartition partition, EventDispatcher<MongoDbPartition, CollectionId> dispatcher, OffsetContext offsetContext, Object[] row) throws InterruptedException {
        this.context.sendEvent(this.keyFromRow(row));
        ((ReplicaSetOffsetContext)offsetContext).readEvent((CollectionId)this.context.currentDataCollectionId().getId(), this.clock.currentTimeAsInstant());
        dispatcher.dispatchSnapshotEvent((Partition)partition, (DataCollectionId)((CollectionId)this.context.currentDataCollectionId().getId()), this.getChangeRecordEmitter(partition, offsetContext, row), dispatcher.getIncrementalSnapshotChangeEventReceiver(this.dataListener));
    }

    protected ChangeRecordEmitter<MongoDbPartition> getChangeRecordEmitter(MongoDbPartition partition, OffsetContext offsetContext, Object[] row) {
        return new MongoDbChangeSnapshotOplogRecordEmitter(partition, offsetContext, this.clock, (BsonDocument)row[0], true);
    }

    protected void deduplicateWindow(DataCollectionId dataCollectionId, Object key) {
        if (this.context.currentDataCollectionId() == null || !((CollectionId)this.context.currentDataCollectionId().getId()).equals(dataCollectionId)) {
            return;
        }
        if (key instanceof Struct && this.window.remove((Struct)key) != null) {
            LOGGER.info("Removed '{}' from window", key);
        }
    }

    protected void emitWindowOpen() throws InterruptedException {
        CollectionId collectionId = this.signallingCollectionId;
        String id = this.context.currentChunkId() + "-open";
        this.primary.executeBlocking("emit window open for chunk '" + this.context.currentChunkId() + "'", (BlockingConsumer<MongoClient>)((BlockingConsumer)client -> {
            MongoDatabase database = client.getDatabase(collectionId.dbName());
            MongoCollection collection = database.getCollection(collectionId.name());
            LOGGER.trace("Emitting open window for chunk = '{}'", (Object)this.context.currentChunkId());
            Document signal = new Document();
            signal.put(DOCUMENT_ID, (Object)id);
            signal.put("type", (Object)"snapshot-window-open");
            signal.put("payload", (Object)"");
            collection.insertOne((Object)signal);
        }));
    }

    protected void emitWindowClose() throws InterruptedException {
        CollectionId collectionId = this.signallingCollectionId;
        String id = this.context.currentChunkId() + "-close";
        this.primary.executeBlocking("emit window close for chunk '" + this.context.currentChunkId() + "'", (BlockingConsumer<MongoClient>)((BlockingConsumer)client -> {
            MongoDatabase database = client.getDatabase(collectionId.dbName());
            MongoCollection collection = database.getCollection(collectionId.name());
            LOGGER.trace("Emitting close window for chunk = '{}'", (Object)this.context.currentChunkId());
            Document signal = new Document();
            signal.put(DOCUMENT_ID, (Object)id);
            signal.put("type", (Object)"snapshot-window-close");
            signal.put("payload", (Object)"");
            collection.insertOne((Object)signal);
        }));
    }

    public void init(MongoDbPartition partition, OffsetContext offsetContext) {
        this.primary = this.establishConnection(partition, ReadPreference.primary(), this.replicaSets.all().get(0));
        this.secondary = this.establishConnection(partition, ReadPreference.secondaryPreferred(), this.replicaSets.all().get(0));
        if (offsetContext == null) {
            LOGGER.info("Empty incremental snapshot change event source started, no action needed");
            this.postIncrementalSnapshotCompleted();
            return;
        }
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (!this.context.snapshotRunning()) {
            LOGGER.info("No incremental snapshot in progress, no action needed on start");
            this.postIncrementalSnapshotCompleted();
            return;
        }
        LOGGER.info("Incremental snapshot in progress, need to read new chunk on start");
        try {
            this.progressListener.snapshotStarted((Partition)partition);
            this.readChunk(partition);
        }
        catch (InterruptedException e) {
            throw new DebeziumException("Reading of an initial chunk after connector restart has been interrupted");
        }
        LOGGER.info("Incremental snapshot in progress, loading of initial chunk completed");
    }

    protected void readChunk(MongoDbPartition partition) throws InterruptedException {
        if (!this.context.snapshotRunning()) {
            LOGGER.info("Skipping read chunk because snapshot is not running");
            this.postIncrementalSnapshotCompleted();
            return;
        }
        if (this.context.isSnapshotPaused()) {
            LOGGER.info("Incremental snapshot was paused.");
            return;
        }
        try {
            this.preReadChunk(this.context);
            this.context.startNewChunk();
            this.emitWindowOpen();
            while (this.context.snapshotRunning()) {
                CollectionId currentDataCollectionId = (CollectionId)this.context.currentDataCollectionId().getId();
                this.currentCollection = (MongoDbCollectionSchema)this.collectionSchema.schemaFor(currentDataCollectionId);
                if (this.replicaSets.all().size() > 1) {
                    LOGGER.warn("Incremental snapshotting supported only for single result set topology, skipping collection '{}', known collections {}", (Object)currentDataCollectionId);
                    this.nextDataCollection(partition);
                    continue;
                }
                if (this.currentCollection == null) {
                    LOGGER.warn("Schema not found for collection '{}', known collections {}", (Object)currentDataCollectionId, (Object)this.collectionSchema);
                    this.nextDataCollection(partition);
                    continue;
                }
                if (!this.context.maximumKey().isPresent()) {
                    this.context.maximumKey(this.readMaximumKey());
                    if (!this.context.maximumKey().isPresent()) {
                        LOGGER.info("No maximum key returned by the query, incremental snapshotting of collection '{}' finished as it is empty", (Object)currentDataCollectionId);
                        this.nextDataCollection(partition);
                        continue;
                    }
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Incremental snapshot for collection '{}' will end at position {}", (Object)currentDataCollectionId, (Object)this.context.maximumKey().orElse(new Object[0]));
                    }
                }
                this.createDataEventsForDataCollection(partition);
                if (!this.window.isEmpty()) break;
                LOGGER.info("No data returned by the query, incremental snapshotting of table '{}' finished", (Object)currentDataCollectionId);
                this.collectionScanCompleted(partition);
                this.nextDataCollection(partition);
            }
            this.emitWindowClose();
        }
        finally {
            this.postReadChunk(this.context);
            if (!this.context.snapshotRunning()) {
                this.postIncrementalSnapshotCompleted();
            }
        }
    }

    private void nextDataCollection(MongoDbPartition partition) {
        this.context.nextDataCollection();
        if (!this.context.snapshotRunning()) {
            this.progressListener.snapshotCompleted((Partition)partition);
        }
    }

    private Object[] readMaximumKey() throws InterruptedException {
        Object[] objectArray;
        CollectionId collectionId = (CollectionId)this.currentCollection.id();
        AtomicReference key = new AtomicReference();
        this.secondary.executeBlocking("maximum key for '" + collectionId + "'", (BlockingConsumer<MongoClient>)((BlockingConsumer)client -> {
            MongoDatabase database = client.getDatabase(collectionId.dbName());
            MongoCollection collection = database.getCollection(collectionId.name());
            Document lastDocument = (Document)collection.find().sort((Bson)new Document(DOCUMENT_ID, (Object)-1)).limit(1).first();
            if (lastDocument != null) {
                key.set(lastDocument.get((Object)DOCUMENT_ID));
            }
        }));
        if (key.get() != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = key.get();
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    public void addDataCollectionNamesToSnapshot(MongoDbPartition partition, List<String> dataCollectionIds, Optional<String> additionalCondition, OffsetContext offsetContext) throws InterruptedException {
        if (additionalCondition != null && additionalCondition.isPresent()) {
            throw new UnsupportedOperationException("Additional condition not supported for MongoDB");
        }
        this.context = offsetContext.getIncrementalSnapshotContext();
        boolean shouldReadChunk = !this.context.snapshotRunning();
        String rsName = this.replicaSets.all().get(0).replicaSetName();
        dataCollectionIds = dataCollectionIds.stream().map(x -> rsName + "." + x).collect(Collectors.toList());
        List newDataCollectionIds = this.context.addDataCollectionNamesToSnapshot(dataCollectionIds, null);
        if (shouldReadChunk) {
            this.progressListener.snapshotStarted((Partition)partition);
            this.progressListener.monitoredDataCollectionsDetermined((Partition)partition, (Iterable)newDataCollectionIds.stream().map(x -> (CollectionId)x.getId()).collect(Collectors.toList()));
            this.readChunk(partition);
        }
    }

    public void stopSnapshot(MongoDbPartition partition, List<String> dataCollectionIds, OffsetContext offsetContext) {
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (this.context.snapshotRunning()) {
            if (dataCollectionIds == null || dataCollectionIds.isEmpty()) {
                LOGGER.info("Stopping incremental snapshot.");
                try {
                    this.context.stopSnapshot();
                    this.window.clear();
                    this.closeWindow(partition, this.context.currentChunkId(), offsetContext);
                    this.progressListener.snapshotAborted((Partition)partition);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Failed to stop snapshot successfully.", (Throwable)e);
                }
            } else {
                LOGGER.info("Removing '{}' collections from incremental snapshot", dataCollectionIds);
                String rsName = this.replicaSets.all().get(0).replicaSetName();
                dataCollectionIds = dataCollectionIds.stream().map(x -> rsName + "." + x).collect(Collectors.toList());
                for (String dataCollectionId : dataCollectionIds) {
                    CollectionId collectionId = CollectionId.parse(dataCollectionId);
                    if (this.currentCollection != null && this.currentCollection.id().equals(collectionId)) {
                        this.window.clear();
                        LOGGER.info("Removed '{}' from incremental snapshot collection list.", (Object)collectionId);
                        this.collectionScanCompleted(partition);
                        this.nextDataCollection(partition);
                        continue;
                    }
                    if (this.context.removeDataCollectionFromSnapshot(dataCollectionId)) {
                        LOGGER.info("Removed '{}' from incremental snapshot collection list.", (Object)collectionId);
                        continue;
                    }
                    LOGGER.warn("Could not remove '{}', collection is not part of the incremental snapshot.", (Object)collectionId);
                }
            }
        } else {
            LOGGER.warn("No active incremental snapshot, stop ignored");
        }
    }

    private void createDataEventsForDataCollection(MongoDbPartition partition) throws InterruptedException {
        CollectionId collectionId = (CollectionId)this.currentCollection.id();
        long exportStart = this.clock.currentTimeInMillis();
        LOGGER.debug("Exporting data chunk from collection '{}' (total {} collections)", (Object)this.currentCollection.id(), (Object)this.context.dataCollectionsToBeSnapshottedCount());
        this.secondary.executeBlocking("chunk query key for '" + this.currentCollection.id() + "'", (BlockingConsumer<MongoClient>)((BlockingConsumer)client -> {
            MongoDatabase database = client.getDatabase(collectionId.dbName());
            MongoCollection collection = database.getCollection(collectionId.name(), BsonDocument.class);
            Document maxKeyPredicate = new Document();
            Document maxKeyOp = new Document();
            maxKeyOp.put("$lte", ((Object[])this.context.maximumKey().get())[0]);
            maxKeyPredicate.put(DOCUMENT_ID, (Object)maxKeyOp);
            Document predicate = maxKeyPredicate;
            if (this.context.chunkEndPosititon() != null) {
                Document chunkEndPredicate = new Document();
                Document chunkEndOp = new Document();
                chunkEndOp.put("$gt", this.context.chunkEndPosititon()[0]);
                chunkEndPredicate.put(DOCUMENT_ID, (Object)chunkEndOp);
                predicate = new Document();
                predicate.put("$and", Arrays.asList(chunkEndPredicate, maxKeyPredicate));
            }
            LOGGER.debug("\t For collection '{}' using query: '{}', key: '{}', maximum key: '{}'", new Object[]{this.currentCollection.id(), predicate.toJson(), this.context.chunkEndPosititon(), this.context.maximumKey().get()});
            long rows = 0L;
            Threads.Timer logTimer = this.getTableScanLogTimer();
            Object[] lastRow = null;
            Object[] firstRow = null;
            for (BsonDocument doc : collection.find((Bson)predicate).sort((Bson)new Document(DOCUMENT_ID, (Object)1)).limit(this.connectorConfig.getIncrementalSnashotChunkSize())) {
                ++rows;
                Object[] row = new Object[]{doc};
                if (firstRow == null) {
                    firstRow = row;
                }
                Struct keyStruct = this.currentCollection.keyFromDocumentOplog(doc);
                this.window.put(keyStruct, row);
                if (logTimer.expired()) {
                    long stop = this.clock.currentTimeInMillis();
                    LOGGER.debug("\t Exported {} records for collection '{}' after {}", new Object[]{rows, this.currentCollection.id(), Strings.duration((long)(stop - exportStart))});
                    logTimer = this.getTableScanLogTimer();
                }
                lastRow = row;
            }
            Object[] firstKey = this.keyFromRow(firstRow);
            Object[] lastKey = this.keyFromRow(lastRow);
            if (this.context.isNonInitialChunk()) {
                this.progressListener.currentChunk((Partition)partition, this.context.currentChunkId(), firstKey, lastKey);
            } else {
                this.progressListener.currentChunk((Partition)partition, this.context.currentChunkId(), firstKey, lastKey, (Object[])this.context.maximumKey().orElse(null));
            }
            this.context.nextChunkPosition(lastKey);
            if (lastRow != null) {
                LOGGER.debug("\t Next window will resume from {}", (Object)this.context.chunkEndPosititon());
            }
            LOGGER.debug("\t Finished exporting {} records for window of collection '{}'; total duration '{}'", new Object[]{rows, this.currentCollection.id(), Strings.duration((long)(this.clock.currentTimeInMillis() - exportStart))});
            this.incrementTableRowsScanned(rows);
        }));
    }

    private void incrementTableRowsScanned(long rows) {
        this.totalRowsScanned += rows;
    }

    private void collectionScanCompleted(MongoDbPartition partition) {
        this.progressListener.dataCollectionSnapshotCompleted((Partition)partition, this.currentCollection.id(), this.totalRowsScanned);
        this.totalRowsScanned = 0L;
        this.progressListener.currentChunk(null, null, null, null);
    }

    private Threads.Timer getTableScanLogTimer() {
        return Threads.timer((Clock)this.clock, (Duration)AbstractSnapshotChangeEventSource.LOG_INTERVAL);
    }

    private Object[] keyFromRow(Object[] row) {
        Object key;
        if (row == null) {
            return null;
        }
        BsonValue documentId = ((BsonDocument)row[0]).get((Object)DOCUMENT_ID);
        switch (documentId.getBsonType()) {
            case DOUBLE: {
                key = documentId.asDouble().getValue();
                break;
            }
            case INT32: {
                key = documentId.asInt32().getValue();
                break;
            }
            case INT64: {
                key = documentId.asInt64().getValue();
                break;
            }
            case DECIMAL128: {
                key = documentId.asDecimal128().getValue();
                break;
            }
            case OBJECT_ID: {
                key = documentId.asObjectId().getValue();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported type of document id");
            }
        }
        return new Object[]{key};
    }

    protected void setContext(IncrementalSnapshotContext<CollectionId> context) {
        this.context = context;
    }

    protected void preReadChunk(IncrementalSnapshotContext<CollectionId> context) {
    }

    protected void postReadChunk(IncrementalSnapshotContext<CollectionId> context) {
    }

    protected void postIncrementalSnapshotCompleted() {
    }

    public void processMessage(MongoDbPartition partition, DataCollectionId dataCollectionId, Object key, OffsetContext offsetContext) throws InterruptedException {
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (this.context == null) {
            LOGGER.warn("Context is null, skipping message processing");
            return;
        }
        LOGGER.trace("Checking window for table '{}', key '{}', window contains '{}'", new Object[]{dataCollectionId, key, this.window});
        if (!this.window.isEmpty() && this.context.deduplicationNeeded()) {
            this.deduplicateWindow(dataCollectionId, key);
        }
    }

    private ConnectionContext.MongoPreferredNode establishConnection(MongoDbPartition partition, ReadPreference preference, ReplicaSet replicaSet) {
        return this.connectionContext.preferredFor(replicaSet, preference, this.taskContext.filters(), (desc, error) -> {
            if (error.getMessage() != null && error.getMessage().startsWith(AUTHORIZATION_FAILURE_MESSAGE)) {
                throw new ConnectException("Error while attempting to " + desc, error);
            }
            this.dispatcher.dispatchConnectorEvent((Partition)partition, (ConnectorEvent)new DisconnectEvent());
            LOGGER.error("Error while attempting to {}: {}", new Object[]{desc, error.getMessage(), error});
            throw new ConnectException("Error while attempting to " + desc, error);
        });
    }
}

