/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.junit;

import io.debezium.testing.testcontainers.MongoDbReplicaSet;
import io.debezium.testing.testcontainers.util.ParsingPortResolver;
import io.debezium.testing.testcontainers.util.PortResolver;

public final class MongoDbDatabaseProvider {
    public static final String MONGO_REPLICA_SIZE = "mongodb.replica.size";
    public static final String MONGO_DOCKER_DESKTOP_PORT_PROPERTY = "mongodb.docker.desktop.ports";
    public static final String MONGO_DOCKER_DESKTOP_PORT_DEFAULT = "27017,27018,27019";

    public static MongoDbReplicaSet mongoDbReplicaSet() {
        ParsingPortResolver portResolver = ParsingPortResolver.parseProperty((String)MONGO_DOCKER_DESKTOP_PORT_PROPERTY, (String)MONGO_DOCKER_DESKTOP_PORT_DEFAULT);
        int replicaSize = Integer.parseInt(System.getProperty(MONGO_REPLICA_SIZE, "1"));
        return MongoDbReplicaSet.replicaSet().memberCount(replicaSize).portResolver((PortResolver)portResolver).build();
    }

    private MongoDbDatabaseProvider() {
    }
}

