/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.ServerAddress;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.ReplicaSets;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ReplicaSetsTest {
    private ReplicaSets sets;
    private ReplicaSet rs;

    @Test
    public void shouldHaveNoReplicaSetsInEmptyInstance() {
        Assertions.assertThat((int)ReplicaSets.empty().replicaSetCount()).isEqualTo(0);
    }

    @Test
    public void shouldParseNullHostString() {
        Assertions.assertThat((Object)ReplicaSets.parse(null)).isEqualTo((Object)ReplicaSets.empty());
    }

    @Test
    public void shouldParseEmptyHostString() {
        Assertions.assertThat((Object)ReplicaSets.parse((String)"")).isEqualTo((Object)ReplicaSets.empty());
    }

    @Test
    public void shouldParseBlankHostString() {
        Assertions.assertThat((Object)ReplicaSets.parse((String)"   ")).isEqualTo((Object)ReplicaSets.empty());
    }

    @Test
    public void shouldParseHostStringWithStandaloneAddress() {
        this.sets = ReplicaSets.parse((String)"localhost:27017");
        Assertions.assertThat((int)this.sets.replicaSetCount()).isEqualTo(1);
        Assertions.assertThat((String)this.sets.hosts()).isEqualTo((Object)"localhost:27017");
        this.rs = (ReplicaSet)this.sets.all().get(0);
        Assertions.assertThat((boolean)this.rs.hasReplicaSetName()).isFalse();
        Assertions.assertThat((boolean)this.rs.isStandaloneServer()).isTrue();
        Assertions.assertThat((String)this.rs.replicaSetName()).isNull();
        Assertions.assertThat((String)this.rs.shardName()).isNull();
        ServerAddress expected = new ServerAddress("localhost", 27017);
        Assertions.assertThat((int)this.rs.addresses().size()).isEqualTo(1);
        Assertions.assertThat((List)this.rs.addresses()).containsOnly((Object[])new ServerAddress[]{expected});
    }

    @Test
    public void shouldParseHostStringWithStandaloneAddresses() {
        this.sets = ReplicaSets.parse((String)"localhost:27017,1.2.3.4:27017,localhost:28017,[fe80::601:9bff:feab:ec01]:27017");
        Assertions.assertThat((int)this.sets.replicaSetCount()).isEqualTo(1);
        Assertions.assertThat((String)this.sets.hosts()).isEqualTo((Object)"1.2.3.4:27017,[fe80::601:9bff:feab:ec01]:27017,localhost:27017,localhost:28017");
        this.rs = (ReplicaSet)this.sets.all().get(0);
        Assertions.assertThat((boolean)this.rs.hasReplicaSetName()).isFalse();
        Assertions.assertThat((boolean)this.rs.isStandaloneServer()).isTrue();
        Assertions.assertThat((String)this.rs.replicaSetName()).isNull();
        Assertions.assertThat((String)this.rs.shardName()).isNull();
        ServerAddress expected1 = new ServerAddress("1.2.3.4", 27017);
        ServerAddress expected2 = new ServerAddress("[fe80::601:9bff:feab:ec01]", 27017);
        ServerAddress expected3 = new ServerAddress("localhost", 27017);
        ServerAddress expected4 = new ServerAddress("localhost", 28017);
        Assertions.assertThat((int)this.rs.addresses().size()).isEqualTo(4);
        Assertions.assertThat((List)this.rs.addresses()).containsOnly((Object[])new ServerAddress[]{expected1, expected2, expected3, expected4});
    }

    @Test
    public void shouldParseHostStringWithAddressForOneReplicaSet() {
        this.sets = ReplicaSets.parse((String)"myReplicaSet/localhost:27017");
        Assertions.assertThat((int)this.sets.replicaSetCount()).isEqualTo(1);
        Assertions.assertThat((String)this.sets.hosts()).isEqualTo((Object)"myReplicaSet/localhost:27017");
        this.rs = (ReplicaSet)this.sets.all().get(0);
        Assertions.assertThat((boolean)this.rs.hasReplicaSetName()).isTrue();
        Assertions.assertThat((boolean)this.rs.isStandaloneServer()).isFalse();
        Assertions.assertThat((String)this.rs.replicaSetName()).isEqualTo((Object)"myReplicaSet");
        Assertions.assertThat((String)this.rs.shardName()).isNull();
        ServerAddress expected = new ServerAddress("localhost", 27017);
        Assertions.assertThat((int)this.rs.addresses().size()).isEqualTo(1);
        Assertions.assertThat((List)this.rs.addresses()).containsOnly((Object[])new ServerAddress[]{expected});
    }

    @Test
    public void shouldParseHostStringWithIpv6AddressForOneReplicaSet() {
        this.sets = ReplicaSets.parse((String)"myReplicaSet/[fe80::601:9bff:feab:ec01]:27017");
        Assertions.assertThat((int)this.sets.replicaSetCount()).isEqualTo(1);
        Assertions.assertThat((String)this.sets.hosts()).isEqualTo((Object)"myReplicaSet/[fe80::601:9bff:feab:ec01]:27017");
        this.rs = (ReplicaSet)this.sets.all().get(0);
        Assertions.assertThat((boolean)this.rs.hasReplicaSetName()).isTrue();
        Assertions.assertThat((boolean)this.rs.isStandaloneServer()).isFalse();
        Assertions.assertThat((String)this.rs.replicaSetName()).isEqualTo((Object)"myReplicaSet");
        Assertions.assertThat((String)this.rs.shardName()).isNull();
        ServerAddress expected = new ServerAddress("[fe80::601:9bff:feab:ec01]", 27017);
        Assertions.assertThat((int)this.rs.addresses().size()).isEqualTo(1);
        Assertions.assertThat((List)this.rs.addresses()).containsOnly((Object[])new ServerAddress[]{expected});
    }

    @Test
    public void shouldParseHostStringWithAddressesForOneReplicaSet() {
        this.sets = ReplicaSets.parse((String)"myReplicaSet/localhost:27017,1.2.3.4:27017,localhost:28017,[fe80::601:9bff:feab:ec01]:27017");
        Assertions.assertThat((int)this.sets.replicaSetCount()).isEqualTo(1);
        Assertions.assertThat((String)this.sets.hosts()).isEqualTo((Object)"myReplicaSet/1.2.3.4:27017,[fe80::601:9bff:feab:ec01]:27017,localhost:27017,localhost:28017");
        this.rs = (ReplicaSet)this.sets.all().get(0);
        Assertions.assertThat((boolean)this.rs.hasReplicaSetName()).isTrue();
        Assertions.assertThat((boolean)this.rs.isStandaloneServer()).isFalse();
        Assertions.assertThat((String)this.rs.replicaSetName()).isEqualTo((Object)"myReplicaSet");
        Assertions.assertThat((String)this.rs.shardName()).isNull();
        ServerAddress expected1 = new ServerAddress("1.2.3.4", 27017);
        ServerAddress expected2 = new ServerAddress("[fe80::601:9bff:feab:ec01]", 27017);
        ServerAddress expected3 = new ServerAddress("localhost", 27017);
        ServerAddress expected4 = new ServerAddress("localhost", 28017);
        Assertions.assertThat((int)this.rs.addresses().size()).isEqualTo(4);
        Assertions.assertThat((List)this.rs.addresses()).containsOnly((Object[])new ServerAddress[]{expected1, expected2, expected3, expected4});
    }

    @Test
    public void shouldParseHostStringWithAddressesForMultipleReplicaSet() {
        this.sets = ReplicaSets.parse((String)"myReplicaSet/host1:27017,[fe80::601:9bff:feab:ec01]:27017;otherReplicaset/1.2.3.4:27017,localhost:28017");
        Assertions.assertThat((int)this.sets.replicaSetCount()).isEqualTo(2);
        Assertions.assertThat((String)this.sets.hosts()).isEqualTo((Object)"myReplicaSet/[fe80::601:9bff:feab:ec01]:27017,host1:27017;otherReplicaset/1.2.3.4:27017,localhost:28017");
        this.rs = (ReplicaSet)this.sets.all().get(0);
        Assertions.assertThat((boolean)this.rs.hasReplicaSetName()).isTrue();
        Assertions.assertThat((boolean)this.rs.isStandaloneServer()).isFalse();
        Assertions.assertThat((String)this.rs.replicaSetName()).isEqualTo((Object)"myReplicaSet");
        Assertions.assertThat((String)this.rs.shardName()).isNull();
        ServerAddress expected1 = new ServerAddress("[fe80::601:9bff:feab:ec01]", 27017);
        ServerAddress expected2 = new ServerAddress("host1", 27017);
        Assertions.assertThat((int)this.rs.addresses().size()).isEqualTo(2);
        Assertions.assertThat((List)this.rs.addresses()).containsOnly((Object[])new ServerAddress[]{expected1, expected2});
        this.rs = (ReplicaSet)this.sets.all().get(1);
        Assertions.assertThat((boolean)this.rs.hasReplicaSetName()).isTrue();
        Assertions.assertThat((boolean)this.rs.isStandaloneServer()).isFalse();
        Assertions.assertThat((String)this.rs.replicaSetName()).isEqualTo((Object)"otherReplicaset");
        Assertions.assertThat((String)this.rs.shardName()).isNull();
        expected1 = new ServerAddress("1.2.3.4", 27017);
        expected2 = new ServerAddress("localhost", 28017);
        Assertions.assertThat((int)this.rs.addresses().size()).isEqualTo(2);
        Assertions.assertThat((List)this.rs.addresses()).containsOnly((Object[])new ServerAddress[]{expected1, expected2});
    }

    @Test
    public void shouldParseHostStringWithAddressesForOneShard() {
        this.sets = ReplicaSets.parse((String)"shard1=myReplicaSet/localhost:27017,1.2.3.4:27017,localhost:28017,[fe80::601:9bff:feab:ec01]:27017");
        Assertions.assertThat((int)this.sets.replicaSetCount()).isEqualTo(1);
        Assertions.assertThat((String)this.sets.hosts()).isEqualTo((Object)"shard1=myReplicaSet/1.2.3.4:27017,[fe80::601:9bff:feab:ec01]:27017,localhost:27017,localhost:28017");
        this.rs = (ReplicaSet)this.sets.all().get(0);
        Assertions.assertThat((boolean)this.rs.hasReplicaSetName()).isTrue();
        Assertions.assertThat((boolean)this.rs.isStandaloneServer()).isFalse();
        Assertions.assertThat((String)this.rs.replicaSetName()).isEqualTo((Object)"myReplicaSet");
        Assertions.assertThat((String)this.rs.shardName()).isEqualTo((Object)"shard1");
        ServerAddress expected1 = new ServerAddress("1.2.3.4", 27017);
        ServerAddress expected2 = new ServerAddress("[fe80::601:9bff:feab:ec01]", 27017);
        ServerAddress expected3 = new ServerAddress("localhost", 27017);
        ServerAddress expected4 = new ServerAddress("localhost", 28017);
        Assertions.assertThat((int)this.rs.addresses().size()).isEqualTo(4);
        Assertions.assertThat((List)this.rs.addresses()).containsOnly((Object[])new ServerAddress[]{expected1, expected2, expected3, expected4});
    }

    @Test
    public void shouldParseHostStringWithAddressesForMultipleShard() {
        this.sets = ReplicaSets.parse((String)"shard1=myReplicaSet/host1:27017,[fe80::601:9bff:feab:ec01]:27017;shard2=otherReplicaset/1.2.3.4:27017,localhost:28017");
        Assertions.assertThat((int)this.sets.replicaSetCount()).isEqualTo(2);
        Assertions.assertThat((String)this.sets.hosts()).isEqualTo((Object)"shard1=myReplicaSet/[fe80::601:9bff:feab:ec01]:27017,host1:27017;shard2=otherReplicaset/1.2.3.4:27017,localhost:28017");
        this.rs = (ReplicaSet)this.sets.all().get(0);
        Assertions.assertThat((boolean)this.rs.hasReplicaSetName()).isTrue();
        Assertions.assertThat((boolean)this.rs.isStandaloneServer()).isFalse();
        Assertions.assertThat((String)this.rs.replicaSetName()).isEqualTo((Object)"myReplicaSet");
        Assertions.assertThat((String)this.rs.shardName()).isEqualTo((Object)"shard1");
        ServerAddress expected1 = new ServerAddress("[fe80::601:9bff:feab:ec01]", 27017);
        ServerAddress expected2 = new ServerAddress("host1", 27017);
        Assertions.assertThat((int)this.rs.addresses().size()).isEqualTo(2);
        Assertions.assertThat((List)this.rs.addresses()).containsOnly((Object[])new ServerAddress[]{expected1, expected2});
        this.rs = (ReplicaSet)this.sets.all().get(1);
        Assertions.assertThat((boolean)this.rs.hasReplicaSetName()).isTrue();
        Assertions.assertThat((boolean)this.rs.isStandaloneServer()).isFalse();
        Assertions.assertThat((String)this.rs.replicaSetName()).isEqualTo((Object)"otherReplicaset");
        Assertions.assertThat((String)this.rs.shardName()).isEqualTo((Object)"shard2");
        expected1 = new ServerAddress("1.2.3.4", 27017);
        expected2 = new ServerAddress("localhost", 28017);
        Assertions.assertThat((int)this.rs.addresses().size()).isEqualTo(2);
        Assertions.assertThat((List)this.rs.addresses()).containsOnly((Object[])new ServerAddress[]{expected1, expected2});
    }

    @Test
    public void shouldConsiderUnchangedSameInstance() {
        this.sets = ReplicaSets.parse((String)"localhost:27017");
        Assertions.assertThat((boolean)this.sets.haveChangedSince(this.sets)).isFalse();
    }

    @Test
    public void shouldConsiderUnchangedSimilarReplicaSets() {
        ReplicaSets sets1 = ReplicaSets.parse((String)"localhost:27017");
        ReplicaSets sets2 = ReplicaSets.parse((String)"localhost:27017");
        Assertions.assertThat((boolean)sets1.haveChangedSince(sets2)).isFalse();
        sets1 = ReplicaSets.parse((String)"shard1=myReplicaSet/host1:27017,[fe80::601:9bff:feab:ec01]:27017;shard2=otherReplicaset/1.2.3.4:27017,localhost:28017");
        sets2 = ReplicaSets.parse((String)"shard1=myReplicaSet/host1:27017,[fe80::601:9bff:feab:ec01]:27017;shard2=otherReplicaset/1.2.3.4:27017,localhost:28017");
        Assertions.assertThat((boolean)sets1.haveChangedSince(sets2)).isFalse();
    }

    @Test
    public void shouldConsiderChangedReplicaSetsWithOneReplicaSetContainingDifferentLocalServers() {
        ReplicaSets sets1 = ReplicaSets.parse((String)"localhost:27017");
        ReplicaSets sets2 = ReplicaSets.parse((String)"localhost:27017,host2:27017");
        Assertions.assertThat((boolean)sets1.haveChangedSince(sets2)).isTrue();
    }

    @Test
    public void shouldConsiderUnchangedReplicaSetsWithAdditionalServerAddressInExistingReplicaSet() {
        ReplicaSets sets1 = ReplicaSets.parse((String)"rs1/localhost:27017");
        ReplicaSets sets2 = ReplicaSets.parse((String)"rs1/localhost:27017,host2:27017");
        Assertions.assertThat((boolean)sets1.haveChangedSince(sets2)).isFalse();
    }

    @Test
    public void shouldConsiderChangedReplicaSetsWithAdditionalReplicaSet() {
        ReplicaSets sets1 = ReplicaSets.parse((String)"rs1/localhost:27017;rs2/host2:17017");
        ReplicaSets sets2 = ReplicaSets.parse((String)"rs1/localhost:27017");
        Assertions.assertThat((boolean)sets1.haveChangedSince(sets2)).isTrue();
    }

    @Test
    public void shouldConsiderChangedReplicaSetsWithRemovedReplicaSet() {
        ReplicaSets sets1 = ReplicaSets.parse((String)"rs1/localhost:27017");
        ReplicaSets sets2 = ReplicaSets.parse((String)"rs1/localhost:27017;rs2/host2:17017");
        Assertions.assertThat((boolean)sets1.haveChangedSince(sets2)).isTrue();
    }

    @Test
    public void shouldNotSubdivideOneReplicaSet() {
        this.sets = ReplicaSets.parse((String)"rs1/host1:27017,host2:27017");
        ArrayList divided = new ArrayList();
        this.sets.subdivide(1, divided::add);
        Assertions.assertThat((int)divided.size()).isEqualTo(1);
        Assertions.assertThat((Object)((ReplicaSets)divided.get(0))).isSameAs((Object)this.sets);
    }

    @Test
    public void shouldNotSubdivideMultipleReplicaSetsIntoOneGroup() {
        this.sets = ReplicaSets.parse((String)"rs1/host1:27017,host2:27017;rs2/host3:27017");
        ArrayList divided = new ArrayList();
        this.sets.subdivide(1, divided::add);
        Assertions.assertThat((int)divided.size()).isEqualTo(1);
        Assertions.assertThat((Object)((ReplicaSets)divided.get(0))).isSameAs((Object)this.sets);
    }

    @Test
    public void shouldSubdivideMultipleReplicaSetsWithIntoMultipleGroups() {
        this.sets = ReplicaSets.parse((String)"rs1/host1:27017,host2:27017;rs2/host3:27017");
        ArrayList divided = new ArrayList();
        this.sets.subdivide(2, divided::add);
        Assertions.assertThat((int)divided.size()).isEqualTo(2);
        ReplicaSets dividedSet1 = (ReplicaSets)divided.get(0);
        Assertions.assertThat((int)dividedSet1.replicaSetCount()).isEqualTo(1);
        Assertions.assertThat((Comparable)((ReplicaSet)dividedSet1.all().get(0))).isSameAs(this.sets.all().get(0));
        ReplicaSets dividedSet2 = (ReplicaSets)divided.get(1);
        Assertions.assertThat((int)dividedSet2.replicaSetCount()).isEqualTo(1);
        Assertions.assertThat((Comparable)((ReplicaSet)dividedSet2.all().get(0))).isSameAs(this.sets.all().get(1));
    }
}

