/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.connection.ServerDescription;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.AbstractMongoIT;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoUtil;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class MongoUtilIT
extends AbstractMongoIT {
    @Test
    public void testGetPrimaryAddress() {
        Optional<ServerAddress> expectedPrimaryAddress;
        this.useConfiguration(((Configuration.Builder)this.config.edit().with(MongoDbConnectorConfig.AUTO_DISCOVER_MEMBERS, true)).build());
        try (MongoClient client = this.connect();){
            client.listDatabaseNames().first();
            List servers = client.getClusterDescription().getServerDescriptions();
            expectedPrimaryAddress = servers.stream().filter(ServerDescription::isPrimary).findFirst().map(ServerDescription::getAddress);
        }
        Assertions.assertThat(expectedPrimaryAddress).isPresent();
        this.primary.execute("shouldConnect", mongo -> {
            ServerAddress primaryAddress = MongoUtil.getPreferredAddress((MongoClient)mongo, (ReadPreference)ReadPreference.primary());
            Assertions.assertThat((String)primaryAddress.getHost()).isEqualTo((Object)expectedPrimaryAddress.map(ServerAddress::getHost).get());
            Assertions.assertThat((int)primaryAddress.getPort()).isEqualTo((Object)expectedPrimaryAddress.map(ServerAddress::getPort).get());
        });
    }
}

